/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.CharTable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TreeChangeEventImpl
implements TreeChangeEvent {
    private static final Logger LOG = Logger.getInstance("#com.intellij.pom.tree.events.impl.TreeChangeEventImpl");
    private final Map<ASTNode, TreeChange> myChangedElements;
    private final List<Set<ASTNode>> myOfEqualDepth;
    private final PomModelAspect myAspect;
    private final FileElement myFileElement;

    public TreeChangeEventImpl(@NotNull PomModelAspect aspect, @NotNull FileElement treeElement) {
        if (aspect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aspect", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "<init>"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "<init>"));
        }
        this.myChangedElements = new THashMap<ASTNode, TreeChange>();
        this.myOfEqualDepth = new ArrayList<Set<ASTNode>>(10);
        this.myAspect = aspect;
        this.myFileElement = treeElement;
    }

    public TreeChange getChangesByElement(@NotNull ASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "getChangesByElement"));
        }
        LOG.assertTrue(TreeChangeEventImpl.isAncestor(element, this.myFileElement), element);
        return this.myChangedElements.get(element);
    }

    private static boolean isAncestor(ASTNode thisElement, FileElement fileElement) {
        TreeElement element = (TreeElement)thisElement;
        while (element.getTreeParent() != null) {
            element = element.getTreeParent();
        }
        return element == fileElement;
    }

    @Override
    public void addElementaryChange(@NotNull ASTNode element, @NotNull ChangeInfo change) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "addElementaryChange"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "addElementaryChange"));
        }
        LOG.assertTrue(TreeChangeEventImpl.isAncestor(element, this.myFileElement), element);
        ASTNode parent = element.getTreeParent();
        if (parent == null) {
            return;
        }
        ASTNode prevParent = element;
        int depth = 0;
        for (ASTNode currentParent = parent; currentParent != null; currentParent = currentParent.getTreeParent()) {
            if (this.myChangedElements.containsKey(currentParent)) {
                boolean currentParentHasChange;
                TreeChange changesByElement = this.getChangesByElement(currentParent);
                boolean bl = currentParentHasChange = changesByElement.getChangeByChild(prevParent) != null;
                if (currentParentHasChange && prevParent != element) {
                    return;
                }
                if (prevParent != element) {
                    ChangeInfoImpl newChange = ChangeInfoImpl.create((short)3, prevParent);
                    if (change.getChangeType() != 1) {
                        newChange.processElementaryChange(change, element);
                    }
                    change = newChange;
                }
                this.processElementaryChange(currentParent, prevParent, change, -1);
                return;
            }
            ++depth;
            prevParent = currentParent;
        }
        this.compactChanges(parent, depth - 1);
        this.processElementaryChange(parent, element, change, depth - 1);
    }

    private static int getDepth(ASTNode element) {
        int depth = 0;
        while ((element = element.getTreeParent()) != null) {
            ++depth;
        }
        return depth;
    }

    private void processElementaryChange(ASTNode parent, ASTNode element, ChangeInfo change, int depth) {
        TreeChange treeChange = this.myChangedElements.get(parent);
        if (treeChange == null) {
            treeChange = new TreeChangeImpl(parent);
            this.myChangedElements.put(parent, treeChange);
            int index = depth >= 0 ? depth : TreeChangeEventImpl.getDepth(parent);
            this.addToEqualsDepthList(index, parent);
        }
        treeChange.addChange(element, change);
        if (change.getChangeType() == 1) {
            element.putUserData(CharTable.CHAR_TABLE_KEY, this.myFileElement.getCharTable());
        }
        if (treeChange.isEmpty()) {
            this.removeAssociatedChanges(parent, depth);
        }
    }

    private void addToEqualsDepthList(int depth, ASTNode parent) {
        Set<ASTNode> treeElements;
        Set<ASTNode> set = treeElements = depth < this.myOfEqualDepth.size() ? this.myOfEqualDepth.get(depth) : null;
        if (treeElements == null) {
            treeElements = new HashSet<ASTNode>();
            while (depth > this.myOfEqualDepth.size()) {
                this.myOfEqualDepth.add(new HashSet());
            }
            this.myOfEqualDepth.add(depth, treeElements);
        }
        treeElements.add(parent);
    }

    private void compactChanges(ASTNode parent, int depth) {
        int currentDepth = this.myOfEqualDepth.size();
        while (--currentDepth > depth) {
            Set<ASTNode> treeElements = this.myOfEqualDepth.get(currentDepth);
            if (treeElements == null) continue;
            Iterator<ASTNode> iterator2 = treeElements.iterator();
            while (iterator2.hasNext()) {
                TreeElement treeElement;
                boolean isUnderCompacted = false;
                for (ASTNode currentParent = treeElement = (TreeElement)iterator2.next(); currentParent != null; currentParent = currentParent.getTreeParent()) {
                    if (currentParent != parent) continue;
                    isUnderCompacted = true;
                    break;
                }
                if (!isUnderCompacted) continue;
                ChangeInfoImpl compactedChange = ChangeInfoImpl.create((short)3, treeElement);
                compactedChange.compactChange(this.getChangesByElement(treeElement));
                iterator2.remove();
                this.removeAssociatedChanges(treeElement, currentDepth);
                CompositeElement treeParent = treeElement.getTreeParent();
                TreeChange changesByElement = this.getChangesByElement(treeParent);
                if (changesByElement != null) {
                    ChangeInfoImpl changeByChild = (ChangeInfoImpl)changesByElement.getChangeByChild(treeElement);
                    if (changeByChild != null) {
                        changeByChild.setOldLength(compactedChange.getOldLength());
                        continue;
                    }
                    changesByElement.addChange(treeElement, compactedChange);
                    continue;
                }
                this.processElementaryChange(treeParent, treeElement, compactedChange, currentDepth - 1);
            }
        }
    }

    private void removeAssociatedChanges(ASTNode treeElement, int depth) {
        if (this.myChangedElements.remove(treeElement) != null) {
            if (depth < 0) {
                depth = TreeChangeEventImpl.getDepth(treeElement);
            }
            if (depth < this.myOfEqualDepth.size()) {
                this.myOfEqualDepth.get(depth < 0 ? TreeChangeEventImpl.getDepth(treeElement) : depth).remove(treeElement);
            }
        }
    }

    @Override
    public void merge(@NotNull PomChangeSet blocked) {
        ASTNode changed;
        if (blocked == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocked", "com/intellij/pom/tree/events/impl/TreeChangeEventImpl", "merge"));
        }
        if (!(blocked instanceof TreeChangeEventImpl)) {
            return;
        }
        TreeChangeEventImpl blockedTreeChange = (TreeChangeEventImpl)blocked;
        HashMap<ASTNode, TreeChange> changedElements = new HashMap<ASTNode, TreeChange>(blockedTreeChange.myChangedElements);
        Iterator iterator2 = changedElements.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            ASTNode changed2 = (ASTNode)entry.getKey();
            LOG.assertTrue(TreeChangeEventImpl.isAncestor(changed2, this.myFileElement), changed2);
            TreeChange treeChange = this.myChangedElements.get(changed2);
            if (treeChange == null) continue;
            iterator2.remove();
            treeChange.add((TreeChange)entry.getValue());
        }
        int depth = 0;
        Iterator iterator3 = changedElements.entrySet().iterator();
        block1: while (iterator3.hasNext()) {
            Map.Entry entry = iterator3.next();
            changed = (ASTNode)entry.getKey();
            TreeElement prevParent = (TreeElement)changed;
            for (CompositeElement currentParent = (CompositeElement)changed.getTreeParent(); currentParent != null; currentParent = currentParent.getTreeParent()) {
                if (this.myChangedElements.containsKey(currentParent)) {
                    ChangeInfoImpl newChange = ChangeInfoImpl.create((short)3, prevParent);
                    int newLength = ((TreeElement)changed).getNotCachedLength();
                    int oldLength = ((TreeChange)entry.getValue()).getOldLength();
                    newChange.setOldLength(prevParent.getNotCachedLength() - newLength + oldLength);
                    this.processElementaryChange(currentParent, prevParent, newChange, -1);
                    iterator3.remove();
                    continue block1;
                }
                ++depth;
                prevParent = currentParent;
            }
        }
        for (Map.Entry entry : changedElements.entrySet()) {
            changed = (ASTNode)entry.getKey();
            this.myChangedElements.put(changed, (TreeChange)entry.getValue());
            this.addToEqualsDepthList(depth, changed);
            this.compactChanges(changed, depth);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<ASTNode, TreeChange> entry : this.myChangedElements.entrySet()) {
            buffer.append(entry.getKey().getElementType().toString());
            buffer.append(": ");
            buffer.append(entry.getValue().toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

