/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JsInvocation
extends JsExpressionImpl.JsExpressionHasArguments {
    private JsExpression qualifier;

    public JsInvocation() {
        super(new SmartList<JsExpression>());
    }

    public JsInvocation(JsExpression qualifier, @NotNull List<JsExpression> arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/google/dart/compiler/backend/js/ast/JsInvocation", "<init>"));
        }
        super(arguments);
        this.qualifier = qualifier;
    }

    public JsInvocation(JsExpression qualifier, JsExpression arg) {
        this(qualifier, Collections.singletonList(arg));
    }

    public JsInvocation(JsExpression qualifier, JsExpression ... arguments) {
        this(qualifier, Arrays.asList(arguments));
    }

    public JsInvocation(JsExpression qualifier) {
        this();
        this.qualifier = qualifier;
    }

    @Override
    @NotNull
    public List<JsExpression> getArguments() {
        List list = this.arguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsInvocation", "getArguments"));
        }
        return list;
    }

    public JsExpression getQualifier() {
        return this.qualifier;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitInvocation(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        visitor.accept(this.qualifier);
        visitor.acceptList(this.arguments);
    }
}

