/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import com.google.dart.compiler.backend.js.ast.JsVars;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.foreach.ForTranslator;
import org.jetbrains.k2js.translate.expression.foreach.RangeForTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TemporariesUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class RangeLiteralForTranslator
extends ForTranslator {
    @NotNull
    private final JsExpression rangeStart;
    @NotNull
    private final TemporaryVariable rangeEnd;

    @NotNull
    public static JsStatement doTranslate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "doTranslate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "doTranslate"));
        }
        JsBlock jsBlock = new RangeLiteralForTranslator(expression, context).translate();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "doTranslate"));
        }
        return jsBlock;
    }

    public static boolean isApplicable(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "isApplicable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "isApplicable"));
        }
        JetExpression loopRange = PsiUtils.getLoopRange(expression);
        if (!(loopRange instanceof JetBinaryExpression)) {
            return false;
        }
        boolean isRangeToOperation = ((JetBinaryExpression)loopRange).getOperationToken() == JetTokens.RANGE;
        return isRangeToOperation && RangeForTranslator.isApplicable(expression, context);
    }

    private RangeLiteralForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "<init>"));
        }
        super(forExpression, context);
        JetExpression loopRange = PsiUtils.getLoopRange(this.expression);
        assert (loopRange instanceof JetBinaryExpression);
        JetBinaryExpression loopRangeAsBinary = (JetBinaryExpression)loopRange;
        this.rangeStart = TranslationUtils.translateLeftExpression(context, loopRangeAsBinary);
        this.rangeEnd = context.declareTemporary(this.getRangeEnd(loopRangeAsBinary));
    }

    @NotNull
    private JsExpression getRangeEnd(@NotNull JetBinaryExpression loopRangeAsBinary) {
        if (loopRangeAsBinary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopRangeAsBinary", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "getRangeEnd"));
        }
        JsExpression rightExpression = TranslationUtils.translateRightExpression(this.context(), loopRangeAsBinary);
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ADD, rightExpression, this.program().getNumberLiteral(1));
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "getRangeEnd"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsBlock translate() {
        ArrayList<JsStatement> blockStatements = Lists.newArrayList();
        blockStatements.add(TemporariesUtils.temporariesInitialization(this.rangeEnd).makeStmt());
        blockStatements.add(new JsFor(this.initExpression(), this.getCondition(), this.getIncrExpression(), this.translateBody(null)));
        JsBlock jsBlock = new JsBlock(blockStatements);
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "translate"));
        }
        return jsBlock;
    }

    @NotNull
    private JsVars initExpression() {
        JsVars jsVars = JsAstUtils.newVar(this.parameterName, this.rangeStart);
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "initExpression"));
        }
        return jsVars;
    }

    @NotNull
    private JsExpression getCondition() {
        JsBinaryOperation jsBinaryOperation = JsAstUtils.inequality(this.parameterName.makeRef(), this.rangeEnd.reference());
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "getCondition"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsExpression getIncrExpression() {
        JsPostfixOperation jsPostfixOperation = new JsPostfixOperation(JsUnaryOperator.INC, this.parameterName.makeRef());
        if (jsPostfixOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/RangeLiteralForTranslator", "getIncrExpression"));
        }
        return jsPostfixOperation;
    }
}

