/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ClosureExpressionsTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingComponents;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingFacade;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitorForStatements;
import org.jetbrains.jet.lang.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.jet.util.ReenteringLazyValueComputationException;

public class ExpressionTypingVisitorDispatcher
extends JetVisitor<JetTypeInfo, ExpressionTypingContext>
implements ExpressionTypingInternals {
    private final ExpressionTypingComponents components;
    private final BasicExpressionTypingVisitor basic;
    private final ExpressionTypingVisitorForStatements statements;
    private final ClosureExpressionsTypingVisitor closures;
    private final ControlStructureTypingVisitor controlStructures;
    private final PatternMatchingTypingVisitor patterns;

    @NotNull
    public static ExpressionTypingFacade create(@NotNull ExpressionTypingComponents components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "create"));
        }
        ExpressionTypingVisitorDispatcher expressionTypingVisitorDispatcher = new ExpressionTypingVisitorDispatcher(components, null);
        if (expressionTypingVisitorDispatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "create"));
        }
        return expressionTypingVisitorDispatcher;
    }

    @NotNull
    public static ExpressionTypingInternals createForBlock(@NotNull ExpressionTypingComponents components, @NotNull WritableScope writableScope) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "createForBlock"));
        }
        if (writableScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writableScope", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "createForBlock"));
        }
        ExpressionTypingVisitorDispatcher expressionTypingVisitorDispatcher = new ExpressionTypingVisitorDispatcher(components, writableScope);
        if (expressionTypingVisitorDispatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "createForBlock"));
        }
        return expressionTypingVisitorDispatcher;
    }

    private ExpressionTypingVisitorDispatcher(@NotNull ExpressionTypingComponents components, WritableScope writableScope) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "<init>"));
        }
        this.components = components;
        this.basic = new BasicExpressionTypingVisitor(this);
        this.controlStructures = new ControlStructureTypingVisitor(this);
        this.patterns = new PatternMatchingTypingVisitor(this);
        this.statements = writableScope != null ? new ExpressionTypingVisitorForStatements(this, writableScope, this.basic, this.controlStructures, this.patterns) : null;
        this.closures = new ClosureExpressionsTypingVisitor(this);
    }

    @Override
    @NotNull
    public ExpressionTypingComponents getComponents() {
        ExpressionTypingComponents expressionTypingComponents = this.components;
        if (expressionTypingComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getComponents"));
        }
        return expressionTypingComponents;
    }

    @Override
    @NotNull
    public JetTypeInfo checkInExpression(JetElement callElement, @NotNull JetSimpleNameExpression operationSign, @Nullable JetExpression left, @NotNull JetExpression right, ExpressionTypingContext context) {
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        JetTypeInfo jetTypeInfo = this.basic.checkInExpression(callElement, operationSign, left, right, context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo safeGetTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
        }
        JetTypeInfo typeInfo = this.getTypeInfo(expression, context);
        if (typeInfo.getType() != null) {
            JetTypeInfo jetTypeInfo = typeInfo;
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(ErrorUtils.createErrorType("Type for " + expression.getText()), context.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context, this);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context, boolean isStatement2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        if (!isStatement2) {
            JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (this.statements != null) {
            JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context, this.statements);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context, this.createStatementVisitor(context));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    private ExpressionTypingVisitorForStatements createStatementVisitor(ExpressionTypingContext context) {
        return new ExpressionTypingVisitorForStatements(this, ExpressionTypingUtils.newWritableScopeImpl(context, "statement scope"), this.basic, this.controlStructures, this.patterns);
    }

    @Override
    public void checkStatementType(@NotNull JetExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "checkStatementType"));
        }
        expression.accept(this.createStatementVisitor(context), context);
    }

    @NotNull
    private JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context, JetVisitor<JetTypeInfo, ExpressionTypingContext> visitor) {
        JetTypeInfo result2;
        block12: {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            JetTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression, context.trace.getBindingContext());
            if (recordedTypeInfo != null) {
                JetTypeInfo jetTypeInfo = recordedTypeInfo;
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
                }
                return jetTypeInfo;
            }
            result2 = expression.accept(visitor, context);
            if (!context.trace.get(BindingContext.PROCESSED, expression).booleanValue()) break block12;
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(context.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression), result2.getDataFlowInfo());
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            return jetTypeInfo;
        }
        try {
            if (result2.getType() instanceof DeferredType) {
                result2 = JetTypeInfo.create(((DeferredType)result2.getType()).getDelegate(), result2.getDataFlowInfo());
            }
            if (result2.getType() != null) {
                context.trace.record(BindingContext.EXPRESSION_TYPE, expression, result2.getType());
            }
        }
        catch (ReenteringLazyValueComputationException e) {
            context.trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(expression));
            result2 = JetTypeInfo.create(null, context.dataFlowInfo);
        }
        if (!context.trace.get(BindingContext.PROCESSED, expression).booleanValue() && !BindingContextUtils.isExpressionWithValidReference(expression, context.trace.getBindingContext())) {
            context.trace.record(BindingContext.RESOLUTION_SCOPE, expression, context.scope);
        }
        context.trace.record(BindingContext.PROCESSED, expression);
        if (result2.getDataFlowInfo() != DataFlowInfo.EMPTY) {
            context.trace.record(BindingContext.EXPRESSION_DATA_FLOW_INFO, expression, result2.getDataFlowInfo());
        }
        JetTypeInfo jetTypeInfo = result2;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitFunctionLiteralExpression"));
        }
        return expression.accept(this.closures, data2);
    }

    @Override
    public JetTypeInfo visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitObjectLiteralExpression"));
        }
        return expression.accept(this.closures, data2);
    }

    @Override
    public JetTypeInfo visitThrowExpression(@NotNull JetThrowExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitThrowExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitReturnExpression(@NotNull JetReturnExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitReturnExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitContinueExpression(@NotNull JetContinueExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitContinueExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitIfExpression(@NotNull JetIfExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitIfExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitTryExpression(@NotNull JetTryExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitTryExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitForExpression(@NotNull JetForExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitForExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitWhileExpression(@NotNull JetWhileExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitWhileExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(@NotNull JetDoWhileExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitDoWhileExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitBreakExpression(@NotNull JetBreakExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitBreakExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitIsExpression(@NotNull JetIsExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitIsExpression"));
        }
        return expression.accept(this.patterns, data2);
    }

    @Override
    public JetTypeInfo visitWhenExpression(@NotNull JetWhenExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitWhenExpression"));
        }
        return expression.accept(this.patterns, data2);
    }

    @Override
    public JetTypeInfo visitJetElement(@NotNull JetElement element, ExpressionTypingContext data2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitJetElement"));
        }
        return element.accept(this.basic, data2);
    }
}

