/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.impl.AbstractLazyTypeParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStubbedPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.LazyEntity;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class LazyTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor
implements LazyEntity {
    private final ResolveSession resolveSession;
    private final JetTypeParameter jetTypeParameter;

    public LazyTypeParameterDescriptor(@NotNull ResolveSession resolveSession, @NotNull LazyClassDescriptor containingDeclaration, @NotNull JetTypeParameter jetTypeParameter, int index) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "<init>"));
        }
        if (jetTypeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeParameter", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "<init>"));
        }
        super(resolveSession.getStorageManager(), containingDeclaration, jetTypeParameter.getNameAsSafeName(), jetTypeParameter.getVariance(), jetTypeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), index);
        this.resolveSession = resolveSession;
        this.jetTypeParameter = jetTypeParameter;
        this.resolveSession.getTrace().record(BindingContext.TYPE_PARAMETER, jetTypeParameter, this);
    }

    @Override
    @NotNull
    protected Set<JetType> resolveUpperBounds() {
        LinkedHashSet<JetType> upperBounds = Sets.newLinkedHashSet();
        JetTypeParameter jetTypeParameter = this.jetTypeParameter;
        this.resolveUpperBoundsFromWhereClause(upperBounds);
        JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
        if (extendsBound != null) {
            upperBounds.add(this.resolveBoundType(extendsBound));
        }
        if (upperBounds.isEmpty()) {
            upperBounds.add(KotlinBuiltIns.getInstance().getDefaultBound());
        }
        LinkedHashSet<JetType> linkedHashSet = upperBounds;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "resolveUpperBounds"));
        }
        return linkedHashSet;
    }

    private void resolveUpperBoundsFromWhereClause(Set<JetType> upperBounds) {
        JetClassOrObject classOrObject = JetStubbedPsiUtil.getPsiOrStubParent(this.jetTypeParameter, JetClassOrObject.class, true);
        if (classOrObject instanceof JetClass) {
            JetClass jetClass = (JetClass)classOrObject;
            for (JetTypeConstraint jetTypeConstraint : jetClass.getTypeConstraints()) {
                DescriptorResolver.reportUnsupportedClassObjectConstraint(this.resolveSession.getTrace(), jetTypeConstraint);
                JetSimpleNameExpression constrainedParameterName = jetTypeConstraint.getSubjectTypeParameterName();
                if (constrainedParameterName == null || !this.getName().equals(constrainedParameterName.getReferencedNameAsName())) continue;
                this.resolveSession.getTrace().record(BindingContext.REFERENCE_TARGET, constrainedParameterName, this);
                JetTypeReference boundTypeReference = jetTypeConstraint.getBoundTypeReference();
                if (boundTypeReference == null) continue;
                JetType boundType = this.resolveBoundType(boundTypeReference);
                if (jetTypeConstraint.isClassObjectConstraint()) continue;
                upperBounds.add(boundType);
            }
        }
    }

    private JetType resolveBoundType(@NotNull JetTypeReference boundTypeReference) {
        if (boundTypeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundTypeReference", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "resolveBoundType"));
        }
        return this.resolveSession.getTypeResolver().resolveType(this.getContainingDeclaration().getScopeForClassHeaderResolution(), boundTypeReference, this.resolveSession.getTrace(), false);
    }

    @Override
    @NotNull
    public LazyClassDescriptor getContainingDeclaration() {
        LazyClassDescriptor lazyClassDescriptor = (LazyClassDescriptor)super.getContainingDeclaration();
        if (lazyClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyTypeParameterDescriptor", "getContainingDeclaration"));
        }
        return lazyClassDescriptor;
    }

    @Override
    public void forceResolveAllContents() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        ForceResolveUtil.forceResolveAllContents(this.getClassObjectType());
        this.getContainingDeclaration();
        this.getDefaultType();
        this.getIndex();
        ForceResolveUtil.forceResolveAllContents(this.getLowerBounds());
        this.getOriginal();
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
        ForceResolveUtil.forceResolveAllContents(this.getUpperBounds());
        this.getUpperBoundsAsType();
        this.getVariance();
    }
}

