/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.google.common.collect.ImmutableBiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMapBuilder;

class CollectionClassMapping
extends JavaToKotlinClassMapBuilder {
    private static CollectionClassMapping instance = null;
    private ImmutableBiMap.Builder<ClassDescriptor, ClassDescriptor> mapBuilder = ImmutableBiMap.builder();
    private final ImmutableBiMap<ClassDescriptor, ClassDescriptor> mutableToReadOnlyMap;

    @NotNull
    public static CollectionClassMapping getInstance() {
        if (instance == null) {
            instance = new CollectionClassMapping();
        }
        CollectionClassMapping collectionClassMapping = instance;
        if (collectionClassMapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "getInstance"));
        }
        return collectionClassMapping;
    }

    private CollectionClassMapping() {
        this.init();
        this.mutableToReadOnlyMap = this.mapBuilder.build();
        this.mapBuilder = null;
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "register"));
        }
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinDescriptor", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "register"));
        }
        if (kotlinMutableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinMutableDescriptor", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "register"));
        }
        this.mapBuilder.put((Object)kotlinMutableDescriptor, (Object)kotlinDescriptor);
    }

    public boolean isMutableCollection(@NotNull ClassDescriptor mutable) {
        if (mutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutable", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "isMutableCollection"));
        }
        return this.mutableToReadOnlyMap.containsKey(mutable);
    }

    public boolean isReadOnlyCollection(@NotNull ClassDescriptor immutable) {
        if (immutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "immutable", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "isReadOnlyCollection"));
        }
        return this.mutableToReadOnlyMap.containsValue(immutable);
    }

    @NotNull
    public ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        if (mutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutable", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "convertMutableToReadOnly"));
        }
        ClassDescriptor readOnly = (ClassDescriptor)this.mutableToReadOnlyMap.get(mutable);
        if (readOnly == null) {
            throw new IllegalArgumentException("Given class " + mutable + " is not a mutable collection");
        }
        ClassDescriptor classDescriptor = readOnly;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "convertMutableToReadOnly"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        if (readOnly == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnly", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "convertReadOnlyToMutable"));
        }
        ClassDescriptor mutable = (ClassDescriptor)this.mutableToReadOnlyMap.inverse().get(readOnly);
        if (mutable == null) {
            throw new IllegalArgumentException("Given class " + readOnly + " is not a read-only collection");
        }
        ClassDescriptor classDescriptor = mutable;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/CollectionClassMapping", "convertReadOnlyToMutable"));
        }
        return classDescriptor;
    }
}

