/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.name.FqName;

public abstract class JetFilesProvider {
    @NotNull
    public static JetFilesProvider getInstance(Project project) {
        JetFilesProvider jetFilesProvider = ServiceManager.getService(project, JetFilesProvider.class);
        if (jetFilesProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JetFilesProvider", "getInstance"));
        }
        return jetFilesProvider;
    }

    public final Collection<JetFile> allPackageFiles(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/java/JetFilesProvider", "allPackageFiles"));
        }
        final FqName name = file.getPackageFqName();
        return Collections2.filter(this.sampleToAllFilesInModule(file), new Predicate<PsiFile>(){

            @Override
            public boolean apply(PsiFile psiFile) {
                return ((JetFile)psiFile).getPackageFqName().equals(name);
            }
        });
    }

    protected abstract Collection<JetFile> sampleToAllFilesInModule(@NotNull JetFile var1);

    @NotNull
    public abstract Collection<JetFile> allInScope(@NotNull GlobalSearchScope var1);

    public abstract boolean isFileInScope(@NotNull JetFile var1, @NotNull GlobalSearchScope var2);
}

