/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.calls.autocasts.Nullability;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DataFlowValue {
    public static final DataFlowValue NULL = new DataFlowValue(new Object(), KotlinBuiltIns.getInstance().getNullableNothingType(), false, Nullability.NULL);
    public static final DataFlowValue NULLABLE = new DataFlowValue(new Object(), KotlinBuiltIns.getInstance().getNullableAnyType(), false, Nullability.UNKNOWN);
    private final boolean stableIdentifier;
    private final JetType type;
    private final Object id;
    private final Nullability immanentNullability;

    DataFlowValue(Object id, JetType type, boolean stableIdentifier, Nullability immanentNullability) {
        this.stableIdentifier = stableIdentifier;
        this.type = type;
        this.id = id;
        this.immanentNullability = immanentNullability;
    }

    @Nullable
    public Object getId() {
        return this.id;
    }

    @NotNull
    public Nullability getImmanentNullability() {
        Nullability nullability = this.immanentNullability;
        if (nullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValue", "getImmanentNullability"));
        }
        return nullability;
    }

    public boolean isStableIdentifier() {
        return this.stableIdentifier;
    }

    @NotNull
    public JetType getType() {
        JetType jetType = this.type;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValue", "getType"));
        }
        return jetType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFlowValue that = (DataFlowValue)o;
        if (this.stableIdentifier != that.stableIdentifier) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.type != null ? !((Object)this.type).equals(that.type) : that.type != null);
    }

    public String toString() {
        return (this.stableIdentifier ? "stable " : "unstable ") + (this.id == null ? null : this.id.toString()) + " " + (Object)((Object)this.immanentNullability);
    }

    public int hashCode() {
        int result2 = this.stableIdentifier ? 1 : 0;
        result2 = 31 * result2 + (this.type != null ? this.type.hashCode() : 0);
        result2 = 31 * result2 + (this.id != null ? this.id.hashCode() : 0);
        return result2;
    }
}

