/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.parsing.JetScriptDefinition;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;

public final class ScriptParameterResolver {
    @NotNull
    public static List<ValueParameterDescriptor> resolveScriptParameters(@NotNull JetScript declaration, @NotNull ScriptDescriptor scriptDescriptor) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameters"));
        }
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameters"));
        }
        ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
        JetFile file = declaration.getContainingJetFile();
        JetScriptDefinition scriptDefinition = JetScriptDefinitionProvider.getInstance(file.getProject()).findScriptDefinition(file);
        int index = 0;
        for (AnalyzerScriptParameter scriptParameter : scriptDefinition.getScriptParameters()) {
            ValueParameterDescriptor parameter = ScriptParameterResolver.resolveScriptParameter(scriptParameter, index, scriptDescriptor);
            valueParameters.add(parameter);
            ++index;
        }
        ArrayList<ValueParameterDescriptor> arrayList = valueParameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameters"));
        }
        return arrayList;
    }

    @NotNull
    private static ValueParameterDescriptor resolveScriptParameter(@NotNull AnalyzerScriptParameter scriptParameter, int index, @NotNull ScriptDescriptor script) {
        if (scriptParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameter", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameter"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameter"));
        }
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(script, null, index, Annotations.EMPTY, scriptParameter.getName(), scriptParameter.getType(), false, null);
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameter"));
        }
        return valueParameterDescriptorImpl;
    }

    private ScriptParameterResolver() {
    }
}

