/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilder;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.ScriptHeaderResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class DeclarationResolver {
    @NotNull
    private AnnotationResolver annotationResolver;
    @NotNull
    private ImportsResolver importsResolver;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private BindingTrace trace;

    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setAnnotationResolver"));
        }
        this.annotationResolver = annotationResolver;
    }

    public void setImportsResolver(@NotNull ImportsResolver importsResolver) {
        if (importsResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setImportsResolver"));
        }
        this.importsResolver = importsResolver;
    }

    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        if (descriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setDescriptorResolver"));
        }
        this.descriptorResolver = descriptorResolver;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void process(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "process"));
        }
        this.resolveAnnotationConstructors(c);
        this.resolveConstructorHeaders(c);
        this.resolveAnnotationStubsOnClassesAndConstructors(c);
        this.resolveFunctionAndPropertyHeaders(c);
        ScriptHeaderResolver.resolveScriptDeclarations(c);
        this.createFunctionsForDataClasses(c);
        this.importsResolver.processMembersImports(c);
        this.checkRedeclarationsInPackages(c);
        this.checkRedeclarationsInInnerClassNames(c);
    }

    private void resolveAnnotationConstructors(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveAnnotationConstructors"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)entry.getValue();
            if (!(classOrObject instanceof JetClass) || !DescriptorUtils.isAnnotationClass(classDescriptor)) continue;
            this.processPrimaryConstructor(c, classDescriptor, (JetClass)classOrObject);
        }
    }

    private void resolveConstructorHeaders(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveConstructorHeaders"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)entry.getValue();
            if (!(classOrObject instanceof JetClass) || DescriptorUtils.isAnnotationClass(classDescriptor)) continue;
            this.processPrimaryConstructor(c, classDescriptor, (JetClass)classOrObject);
        }
    }

    private void resolveAnnotationStubsOnClassesAndConstructors(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveAnnotationStubsOnClassesAndConstructors"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            JetModifierList modifierList = entry.getKey().getModifierList();
            if (modifierList == null) continue;
            MutableClassDescriptor descriptor = (MutableClassDescriptor)entry.getValue();
            descriptor.addAnnotations(this.annotationResolver.resolveAnnotationsWithoutArguments(descriptor.getScopeForClassHeaderResolution(), modifierList, this.trace));
        }
    }

    private void resolveFunctionAndPropertyHeaders(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        for (Map.Entry<JetFile, WritableScope> entry : c.getFileScopes().entrySet()) {
            JetFile file = entry.getKey();
            WritableScope fileScope = entry.getValue();
            PackageLikeBuilder packageBuilder = c.getPackageFragments().get(file).getBuilder();
            this.resolveFunctionAndPropertyHeaders(c, file.getDeclarations(), fileScope, fileScope, fileScope, packageBuilder);
        }
        for (Map.Entry<JetElement, Object> entry : c.getDeclaredClasses().entrySet()) {
            JetClassOrObject classOrObject = (JetClassOrObject)entry.getKey();
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)entry.getValue();
            this.resolveFunctionAndPropertyHeaders(c, classOrObject.getDeclarations(), classDescriptor.getScopeForMemberDeclarationResolution(), classDescriptor.getScopeForInitializerResolution(), classDescriptor.getScopeForMemberDeclarationResolution(), classDescriptor.getBuilder());
        }
    }

    private void resolveFunctionAndPropertyHeaders(final @NotNull TopDownAnalysisContext c, @NotNull List<JetDeclaration> declarations, final @NotNull JetScope scopeForFunctions, final @NotNull JetScope scopeForPropertyInitializers, final @NotNull JetScope scopeForPropertyAccessors, final @NotNull PackageLikeBuilder packageLike) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (scopeForFunctions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForFunctions", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (scopeForPropertyInitializers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForPropertyInitializers", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (scopeForPropertyAccessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForPropertyAccessors", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (packageLike == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageLike", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        for (JetDeclaration declaration : declarations) {
            declaration.accept(new JetVisitorVoid(){

                @Override
                public void visitNamedFunction(@NotNull JetNamedFunction function) {
                    if (function == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/DeclarationResolver$1", "visitNamedFunction"));
                    }
                    SimpleFunctionDescriptor functionDescriptor = DeclarationResolver.this.descriptorResolver.resolveFunctionDescriptor(packageLike.getOwnerForChildren(), scopeForFunctions, function, DeclarationResolver.this.trace, c.getOuterDataFlowInfo());
                    packageLike.addFunctionDescriptor(functionDescriptor);
                    c.getFunctions().put(function, functionDescriptor);
                    c.registerDeclaringScope(function, scopeForFunctions);
                }

                @Override
                public void visitProperty(@NotNull JetProperty property2) {
                    JetPropertyAccessor setter;
                    if (property2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/DeclarationResolver$1", "visitProperty"));
                    }
                    PropertyDescriptor propertyDescriptor = DeclarationResolver.this.descriptorResolver.resolvePropertyDescriptor(packageLike.getOwnerForChildren(), scopeForPropertyInitializers, property2, DeclarationResolver.this.trace, c.getOuterDataFlowInfo());
                    packageLike.addPropertyDescriptor(propertyDescriptor);
                    c.getProperties().put(property2, propertyDescriptor);
                    c.registerDeclaringScope(property2, scopeForPropertyInitializers);
                    JetPropertyAccessor getter = property2.getGetter();
                    if (getter != null) {
                        c.registerDeclaringScope(getter, scopeForPropertyAccessors);
                    }
                    if ((setter = property2.getSetter()) != null) {
                        c.registerDeclaringScope(setter, scopeForPropertyAccessors);
                    }
                }
            });
        }
    }

    private void createFunctionsForDataClasses(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createFunctionsForDataClasses"));
        }
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            JetClassOrObject klass = entry.getKey();
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)entry.getValue();
            if (!(klass instanceof JetClass) || !klass.hasPrimaryConstructor() || !KotlinBuiltIns.getInstance().isData(classDescriptor)) continue;
            ConstructorDescriptor constructor = DeclarationResolver.getConstructorOfDataClass(classDescriptor);
            this.createComponentFunctions(classDescriptor, constructor);
            this.createCopyFunction(classDescriptor, constructor);
        }
    }

    @NotNull
    public static ConstructorDescriptor getConstructorOfDataClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getConstructorOfDataClass"));
        }
        Collection<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
        assert (constructors.size() == 1) : "Data class must have only one constructor: " + classDescriptor.getConstructors();
        ConstructorDescriptor constructorDescriptor = constructors.iterator().next();
        if (constructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getConstructorOfDataClass"));
        }
        return constructorDescriptor;
    }

    private void createComponentFunctions(@NotNull MutableClassDescriptor classDescriptor, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createComponentFunctions"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createComponentFunctions"));
        }
        int parameterIndex = 0;
        for (ValueParameterDescriptor parameter : constructorDescriptor.getValueParameters()) {
            PropertyDescriptor property2;
            if (parameter.getType().isError() || (property2 = this.trace.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter)) == null) continue;
            SimpleFunctionDescriptor functionDescriptor = DescriptorResolver.createComponentFunctionDescriptor(++parameterIndex, property2, parameter, classDescriptor, this.trace);
            classDescriptor.getBuilder().addFunctionDescriptor(functionDescriptor);
        }
    }

    private void createCopyFunction(@NotNull MutableClassDescriptor classDescriptor, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createCopyFunction"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createCopyFunction"));
        }
        SimpleFunctionDescriptor functionDescriptor = DescriptorResolver.createCopyFunctionDescriptor(constructorDescriptor.getValueParameters(), classDescriptor, this.trace);
        classDescriptor.getBuilder().addFunctionDescriptor(functionDescriptor);
    }

    private void processPrimaryConstructor(@NotNull TopDownAnalysisContext c, @NotNull MutableClassDescriptor classDescriptor, @NotNull JetClass klass) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "processPrimaryConstructor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "processPrimaryConstructor"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "processPrimaryConstructor"));
        }
        JetScope memberScope = classDescriptor.getScopeForClassHeaderResolution();
        ConstructorDescriptorImpl constructorDescriptor = this.descriptorResolver.resolvePrimaryConstructorDescriptor(memberScope, classDescriptor, klass, this.trace);
        if (constructorDescriptor != null) {
            List<ValueParameterDescriptor> valueParameterDescriptors = constructorDescriptor.getValueParameters();
            List<JetParameter> primaryConstructorParameters = klass.getPrimaryConstructorParameters();
            assert (valueParameterDescriptors.size() == primaryConstructorParameters.size());
            ArrayList<ValueParameterDescriptor> notProperties = new ArrayList<ValueParameterDescriptor>();
            for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
                JetParameter parameter = primaryConstructorParameters.get(valueParameterDescriptor.getIndex());
                if (parameter.hasValOrVarNode()) {
                    PropertyDescriptor propertyDescriptor = this.descriptorResolver.resolvePrimaryConstructorParameterToAProperty(classDescriptor, valueParameterDescriptor, memberScope, parameter, this.trace);
                    classDescriptor.getBuilder().addPropertyDescriptor(propertyDescriptor);
                    c.getPrimaryConstructorParameterProperties().put(parameter, propertyDescriptor);
                    continue;
                }
                notProperties.add(valueParameterDescriptor);
            }
            if (classDescriptor.getKind() != ClassKind.TRAIT) {
                classDescriptor.setPrimaryConstructor(constructorDescriptor);
                classDescriptor.addConstructorParametersToInitializersScope(notProperties);
            }
        }
    }

    private void checkRedeclarationsInPackages(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "checkRedeclarationsInPackages"));
        }
        for (MutablePackageFragmentDescriptor packageFragment : Sets.newHashSet(c.getPackageFragments().values())) {
            PackageViewDescriptor packageView = packageFragment.getContainingDeclaration().getPackage(packageFragment.getFqName());
            JetScope packageViewScope = packageView.getMemberScope();
            Multimap<Name, DeclarationDescriptor> simpleNameDescriptors = packageFragment.getMemberScope().getDeclaredDescriptorsAccessibleBySimpleName();
            for (Name name : simpleNameDescriptors.keySet()) {
                Collection<DeclarationDescriptor> descriptors = Collections2.filter(simpleNameDescriptors.get(name), new Predicate<DeclarationDescriptor>(){

                    @Override
                    public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                        if (descriptor instanceof PropertyDescriptor) {
                            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                            return propertyDescriptor.getReceiverParameter() == null;
                        }
                        return true;
                    }
                });
                ContainerUtil.addIfNotNull(descriptors, packageViewScope.getPackage(name));
                if (descriptors.size() <= 1) continue;
                for (DeclarationDescriptor declarationDescriptor : descriptors) {
                    for (PsiElement declaration : this.getDeclarationsByDescriptor(declarationDescriptor)) {
                        assert (declaration != null) : "Null declaration for descriptor: " + declarationDescriptor + " " + (declarationDescriptor != null ? DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor) : "");
                        this.trace.report(Errors.REDECLARATION.on(declaration, declarationDescriptor.getName().asString()));
                    }
                }
            }
        }
    }

    @NotNull
    private Collection<PsiElement> getDeclarationsByDescriptor(@NotNull DeclarationDescriptor declarationDescriptor) {
        Collection<PsiElement> declarations;
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getDeclarationsByDescriptor"));
        }
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            final PackageViewDescriptor aPackage = (PackageViewDescriptor)declarationDescriptor;
            Collection<JetFile> files = this.trace.get(BindingContext.PACKAGE_TO_FILES, aPackage.getFqName());
            if (files == null) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getDeclarationsByDescriptor"));
                }
                return list;
            }
            declarations = Collections2.transform(files, new Function<JetFile, PsiElement>(){

                @Override
                public PsiElement apply(@Nullable JetFile file) {
                    assert (file != null) : "File is null for aPackage " + aPackage;
                    return file.getPackageDirective().getNameIdentifier();
                }
            });
        } else {
            declarations = Collections.singletonList(BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), declarationDescriptor));
        }
        List<PsiElement> list = declarations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getDeclarationsByDescriptor"));
        }
        return list;
    }

    public void checkRedeclarationsInInnerClassNames(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "checkRedeclarationsInInnerClassNames"));
        }
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getDeclaredClasses().values()) {
            Collection<DeclarationDescriptor> classObjDescriptors;
            if (classDescriptor.getKind() == ClassKind.CLASS_OBJECT) continue;
            Collection<DeclarationDescriptor> allDescriptors = classDescriptor.getScopeForMemberLookup().getOwnDeclaredDescriptors();
            ClassDescriptorWithResolutionScopes classObj = classDescriptor.getClassObjectDescriptor();
            if (classObj != null && !(classObjDescriptors = classObj.getScopeForMemberLookup().getOwnDeclaredDescriptors()).isEmpty()) {
                allDescriptors = Lists.newArrayList(allDescriptors);
                allDescriptors.addAll(classObjDescriptors);
            }
            HashMultimap<Name, DeclarationDescriptor> descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : allDescriptors) {
                if (!(desc instanceof ClassDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(desc.getName(), desc);
            }
            this.reportRedeclarations(descriptorMap);
        }
    }

    private void reportRedeclarations(@NotNull Multimap<Name, DeclarationDescriptor> descriptorMap) {
        if (descriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorMap", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "reportRedeclarations"));
        }
        HashSet<Pair<PsiElement, Name>> redeclarations = Sets.newHashSet();
        for (Name name : descriptorMap.keySet()) {
            Collection<DeclarationDescriptor> descriptors = descriptorMap.get(name);
            if (descriptors.size() <= 1) continue;
            for (DeclarationDescriptor descriptor : descriptors) {
                if (!(descriptor instanceof ClassDescriptor)) continue;
                for (DeclarationDescriptor descriptor2 : descriptors) {
                    if (descriptor == descriptor2) continue;
                    redeclarations.add(Pair.create(BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), (ClassDescriptor)descriptor), descriptor.getName()));
                    if (!(descriptor2 instanceof PropertyDescriptor)) continue;
                    redeclarations.add(Pair.create(BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), descriptor2), descriptor2.getName()));
                }
            }
        }
        for (Pair pair : redeclarations) {
            this.trace.report(Errors.REDECLARATION.on((PsiElement)pair.getFirst(), ((Name)pair.getSecond()).asString()));
        }
    }

    public void checkRedeclarationsInPackages(@NotNull KotlinCodeAnalyzer resolveSession, @NotNull Multimap<FqName, JetElement> topLevelFqNames) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "checkRedeclarationsInPackages"));
        }
        if (topLevelFqNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelFqNames", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "checkRedeclarationsInPackages"));
        }
        for (Map.Entry<FqName, Collection<JetElement>> entry : topLevelFqNames.asMap().entrySet()) {
            Set<DeclarationDescriptor> descriptors;
            FqName fqName = entry.getKey();
            Collection<JetElement> declarationsOrPackageDirectives = entry.getValue();
            if (fqName.isRoot() || (descriptors = DeclarationResolver.getTopLevelDescriptorsByFqName(resolveSession, fqName)).size() <= 1) continue;
            for (JetElement declarationOrPackageDirective : declarationsOrPackageDirectives) {
                JetElement reportAt = declarationOrPackageDirective instanceof JetNamedDeclaration ? declarationOrPackageDirective : ((JetPackageDirective)declarationOrPackageDirective).getNameIdentifier();
                this.trace.report(Errors.REDECLARATION.on(reportAt, fqName.shortName().asString()));
            }
        }
    }

    @NotNull
    private static Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(@NotNull KotlinCodeAnalyzer resolveSession, @NotNull FqName fqName) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getTopLevelDescriptorsByFqName"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getTopLevelDescriptorsByFqName"));
        }
        FqName parentFqName = fqName.parent();
        HashSet<DeclarationDescriptor> descriptors = new HashSet<DeclarationDescriptor>();
        LazyPackageDescriptor parentFragment = resolveSession.getPackageFragment(parentFqName);
        if (parentFragment != null) {
            descriptors.addAll(KotlinPackage.filter(parentFragment.getMemberScope().getProperties(fqName.shortName()), new Function1<VariableDescriptor, Boolean>(){

                @Override
                public Boolean invoke(VariableDescriptor descriptor) {
                    return descriptor.getReceiverParameter() == null;
                }
            }));
        }
        ContainerUtil.addIfNotNull(descriptors, resolveSession.getPackageFragment(fqName));
        descriptors.addAll(resolveSession.getTopLevelClassDescriptors(fqName));
        HashSet<DeclarationDescriptor> hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "getTopLevelDescriptorsByFqName"));
        }
        return hashSet;
    }
}

