/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import java.util.Collections;
import java.util.Set;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;

public abstract class AbstractTypeParameterDescriptor
extends DeclarationDescriptorNonRootImpl
implements TypeParameterDescriptor {
    private final Variance variance;
    private final boolean reified;
    private final int index;
    private final NotNullLazyValue<TypeConstructor> typeConstructor;
    private final NotNullLazyValue<JetType> defaultType;
    private final NotNullLazyValue<Set<JetType>> upperBounds;
    private final NotNullLazyValue<JetType> upperBoundsAsType;

    protected AbstractTypeParameterDescriptor(final @NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations, @NotNull Name name, @NotNull Variance variance, boolean isReified, int index) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variance", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "<init>"));
        }
        super(containingDeclaration, annotations, name);
        this.variance = variance;
        this.reified = isReified;
        this.index = index;
        this.typeConstructor = storageManager.createLazyValue(new Function0<TypeConstructor>(){

            @Override
            public TypeConstructor invoke() {
                return AbstractTypeParameterDescriptor.this.createTypeConstructor();
            }
        });
        this.defaultType = storageManager.createLazyValue(new Function0<JetType>(){

            @Override
            public JetType invoke() {
                return new JetTypeImpl(Annotations.EMPTY, AbstractTypeParameterDescriptor.this.getTypeConstructor(), false, Collections.emptyList(), new LazyScopeAdapter(storageManager.createLazyValue(new Function0<JetScope>(){

                    @Override
                    public JetScope invoke() {
                        return AbstractTypeParameterDescriptor.this.getUpperBoundsAsType().getMemberScope();
                    }
                })));
            }
        });
        this.upperBounds = storageManager.createLazyValue(new Function0<Set<JetType>>(){

            @Override
            public Set<JetType> invoke() {
                return AbstractTypeParameterDescriptor.this.resolveUpperBounds();
            }
        });
        this.upperBoundsAsType = storageManager.createLazyValue(new Function0<JetType>(){

            @Override
            public JetType invoke() {
                return AbstractTypeParameterDescriptor.this.computeUpperBoundsAsType();
            }
        });
    }

    @NotNull
    @ReadOnly
    protected abstract Set<JetType> resolveUpperBounds();

    @NotNull
    protected abstract TypeConstructor createTypeConstructor();

    @Override
    @NotNull
    public Variance getVariance() {
        Variance variance = this.variance;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "getVariance"));
        }
        return variance;
    }

    @Override
    public boolean isReified() {
        return this.reified;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        Set set = (Set)this.upperBounds.invoke();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "getUpperBounds"));
        }
        return set;
    }

    @Override
    @NotNull
    public JetType getUpperBoundsAsType() {
        JetType jetType = (JetType)this.upperBoundsAsType.invoke();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "getUpperBoundsAsType"));
        }
        return jetType;
    }

    @NotNull
    private JetType computeUpperBoundsAsType() {
        Set<JetType> upperBounds = this.getUpperBounds();
        assert (!upperBounds.isEmpty()) : "Upper bound list is empty in " + this.getName();
        JetType upperBoundsAsType = TypeUtils.intersect(JetTypeChecker.DEFAULT, upperBounds);
        JetType jetType = upperBoundsAsType != null ? upperBoundsAsType : KotlinBuiltIns.getInstance().getNothingType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "computeUpperBoundsAsType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor = (TypeConstructor)this.typeConstructor.invoke();
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "getTypeConstructor"));
        }
        return typeConstructor;
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        JetType jetType = (JetType)this.defaultType.invoke();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "getDefaultType"));
        }
        return jetType;
    }

    @Override
    public JetType getClassObjectType() {
        return null;
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        Set<JetType> set = Collections.singleton(KotlinBuiltIns.getInstance().getNothingType());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "getLowerBounds"));
        }
        return set;
    }

    @Override
    @Deprecated
    @NotNull
    public TypeParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/descriptors/impl/AbstractTypeParameterDescriptor", "substitute"));
        }
        throw new UnsupportedOperationException("Don't call substitute() on type parameters");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitTypeParameterDescriptor(this, data2);
    }
}

