/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;

public abstract class ProgressManager {
    private static final ProgressManager ourInstance = ServiceManager.getService(ProgressManager.class);
    protected static volatile boolean ourNeedToCheckCancel;
    protected static final ThreadLocal<ProgressIndicator> myThreadIndicator;

    public static ProgressManager getInstance() {
        return ourInstance;
    }

    public ProgressIndicator getProgressIndicator() {
        return myThreadIndicator.get();
    }

    public static void checkCanceled() throws ProcessCanceledException {
        if (ourNeedToCheckCancel) {
            ProgressManager.getInstance().doCheckCanceled();
            ourNeedToCheckCancel = false;
        }
    }

    protected abstract void doCheckCanceled() throws ProcessCanceledException;

    public abstract NonCancelableSection startNonCancelableSection();

    static {
        ProgressIndicatorProvider.ourInstance = new ProgressIndicatorProvider(){

            @Override
            public ProgressIndicator getProgressIndicator() {
                return ourInstance.getProgressIndicator();
            }

            @Override
            protected void doCheckCanceled() throws ProcessCanceledException {
                ourInstance.doCheckCanceled();
            }

            @Override
            public NonCancelableSection startNonCancelableSection() {
                return ourInstance.startNonCancelableSection();
            }
        };
        ourNeedToCheckCancel = false;
        myThreadIndicator = new ThreadLocal();
    }
}

