/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Multimaps {

    static abstract class AsMap<K, V>
    extends Maps.ImprovedAbstractMap<K, Collection<V>> {
        AsMap() {
        }

        abstract Multimap<K, V> multimap();

        abstract Iterator<Map.Entry<K, Collection<V>>> entryIterator();

        @Override
        protected Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            return new EntrySet();
        }

        void removeValuesForKey(Object key) {
            this.multimap().removeAll(key);
        }

        @Override
        public Collection<V> get(Object key) {
            return this.containsKey(key) ? this.multimap().get(key) : null;
        }

        @Override
        public Collection<V> remove(Object key) {
            return this.containsKey(key) ? this.multimap().removeAll(key) : null;
        }

        @Override
        public Set<K> keySet() {
            return this.multimap().keySet();
        }

        @Override
        public boolean isEmpty() {
            return this.multimap().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.multimap().containsKey(key);
        }

        @Override
        public void clear() {
            this.multimap().clear();
        }

        class EntrySet
        extends Maps.EntrySet<K, Collection<V>> {
            EntrySet() {
            }

            @Override
            Map<K, Collection<V>> map() {
                return AsMap.this;
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return AsMap.this.entryIterator();
            }

            @Override
            public boolean remove(Object o) {
                if (!this.contains(o)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                AsMap.this.removeValuesForKey(entry.getKey());
                return true;
            }
        }
    }

    static abstract class EntrySet<K, V>
    extends Entries<K, V>
    implements Set<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        @Override
        public boolean equals(Object obj) {
            return Sets.equalsImpl(this, obj);
        }
    }

    static abstract class Entries<K, V>
    extends AbstractCollection<Map.Entry<K, V>> {
        Entries() {
        }

        abstract Multimap<K, V> multimap();

        @Override
        public int size() {
            return this.multimap().size();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return this.multimap().containsEntry(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return this.multimap().remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public void clear() {
            this.multimap().clear();
        }
    }

    static class Values<K, V>
    extends AbstractCollection<V> {
        final Multimap<K, V> multimap;

        Values(Multimap<K, V> multimap) {
            this.multimap = multimap;
        }

        @Override
        public Iterator<V> iterator() {
            return Maps.valueIterator(this.multimap.entries().iterator());
        }

        @Override
        public int size() {
            return this.multimap.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.multimap.containsValue(o);
        }

        @Override
        public void clear() {
            this.multimap.clear();
        }
    }
}

