/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.facade;

import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.util.TextOutputImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.OutputFileCollection;
import org.jetbrains.jet.SimpleOutputFile;
import org.jetbrains.jet.SimpleOutputFileCollection;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.utils.fileUtils.FileUtilsPackage;
import org.jetbrains.js.compiler.JsSourceGenerationVisitor;
import org.jetbrains.js.compiler.sourcemap.SourceMap3Builder;
import org.jetbrains.js.compiler.sourcemap.SourceMapBuilder;
import org.jetbrains.k2js.analyze.AnalyzerFacadeForJS;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.facade.FacadeUtils;
import org.jetbrains.k2js.facade.MainCallParameters;
import org.jetbrains.k2js.facade.SourceMapBuilderConsumer;
import org.jetbrains.k2js.facade.exceptions.TranslationException;
import org.jetbrains.k2js.translate.general.Translation;

public final class K2JSTranslator {
    public static final String FLUSH_SYSTEM_OUT = "Kotlin.System.flush();\n";
    public static final String GET_SYSTEM_OUT = "Kotlin.System.output();\n";
    @NotNull
    private final Config config;

    public static OutputFileCollection translateWithMainCallParameters(@NotNull MainCallParameters mainCall, @NotNull List<JetFile> files, @NotNull File outputFile, @Nullable File outputPrefixFile, @Nullable File outputPostfixFile, @NotNull Config config) throws TranslationException, IOException {
        if (mainCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCall", "org/jetbrains/k2js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/k2js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/facade/K2JSTranslator", "translateWithMainCallParameters"));
        }
        K2JSTranslator translator = new K2JSTranslator(config);
        TextOutputImpl output = new TextOutputImpl();
        SourceMap3Builder sourceMapBuilder = config.isSourcemap() ? new SourceMap3Builder(outputFile, output, new SourceMapBuilderConsumer()) : null;
        String programCode = translator.generateProgramCode(files, mainCall, output, sourceMapBuilder);
        String prefix = FileUtilsPackage.readTextOrEmpty(outputPrefixFile);
        String postfix = FileUtilsPackage.readTextOrEmpty(outputPostfixFile);
        StringBuilder outBuilder = new StringBuilder(programCode.length() + prefix.length() + postfix.length());
        outBuilder.append(prefix).append(programCode).append(postfix);
        List<File> sourceFiles = ContainerUtil.map(files, new Function<JetFile, File>(){

            @Override
            public File fun(JetFile file) {
                VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
                if (virtualFile == null) {
                    return new File(file.getName());
                }
                return VfsUtilCore.virtualToIoFile(virtualFile);
            }
        });
        SimpleOutputFile jsFile = new SimpleOutputFile(sourceFiles, outputFile.getName(), outBuilder.toString());
        SmartList<SimpleOutputFile> outputFiles = new SmartList<SimpleOutputFile>(jsFile);
        if (sourceMapBuilder != null) {
            sourceMapBuilder.skipLinesAtBeginning(StringUtil.getLineBreakCount(prefix));
            SimpleOutputFile sourcemapFile = new SimpleOutputFile(sourceFiles, sourceMapBuilder.getOutFile().getName(), sourceMapBuilder.build());
            outputFiles.add(sourcemapFile);
        }
        return new SimpleOutputFileCollection(outputFiles);
    }

    public K2JSTranslator(@NotNull Config config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/k2js/facade/K2JSTranslator", "<init>"));
        }
        this.config = config;
    }

    @NotNull
    public String translateStringWithCallToMain(@NotNull String programText, @NotNull String argumentsString) throws TranslationException {
        if (programText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "programText", "org/jetbrains/k2js/facade/K2JSTranslator", "translateStringWithCallToMain"));
        }
        if (argumentsString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentsString", "org/jetbrains/k2js/facade/K2JSTranslator", "translateStringWithCallToMain"));
        }
        JetFile file = JetPsiFactory.createFile(this.getProject(), "test", programText);
        String programCode = this.generateProgramCode(file, MainCallParameters.mainWithArguments(FacadeUtils.parseString(argumentsString))) + "\n";
        String string = FLUSH_SYSTEM_OUT + programCode + GET_SYSTEM_OUT;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "translateStringWithCallToMain"));
        }
        return string;
    }

    @NotNull
    public String generateProgramCode(@NotNull JetFile file, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        String string = this.generateProgramCode(Collections.singletonList(file), mainCallParameters);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        return string;
    }

    @NotNull
    public String generateProgramCode(@NotNull List<JetFile> files, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        String string = this.generateProgramCode(files, mainCallParameters, new TextOutputImpl(), null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        return string;
    }

    @NotNull
    public String generateProgramCode(@NotNull List<JetFile> files, @NotNull MainCallParameters mainCallParameters, @NotNull TextOutputImpl output, @Nullable SourceMapBuilder sourceMapBuilder) throws TranslationException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        JsProgram program = this.generateProgram(files, mainCallParameters);
        JsSourceGenerationVisitor sourceGenerator = new JsSourceGenerationVisitor(output, sourceMapBuilder);
        program.accept(sourceGenerator);
        String string = output.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgramCode"));
        }
        return string;
    }

    @NotNull
    public JsProgram generateProgram(@NotNull List<JetFile> filesToTranslate, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (filesToTranslate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToTranslate", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgram"));
        }
        if (mainCallParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainCallParameters", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgram"));
        }
        BindingContext bindingContext = AnalyzerFacadeForJS.analyzeFilesAndCheckErrors(filesToTranslate, this.config);
        JsProgram jsProgram = Translation.generateAst(bindingContext, filesToTranslate, mainCallParameters, this.config);
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "generateProgram"));
        }
        return jsProgram;
    }

    @NotNull
    private Project getProject() {
        Project project = this.config.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/facade/K2JSTranslator", "getProject"));
        }
        return project;
    }
}

