/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.name;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.CharIterator;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.tailRecursive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.NamePackage;

@KotlinSyntheticClass(abiVersion=16, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class NamePackage-FqNamesUtil-f4b71e84 {
    public static final boolean isSubpackageOf(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="packageName") @NotNull FqName packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isSubpackageOf"));
        }
        return (Intrinsics.areEqual($receiver, packageName) ? 1 : (packageName.isRoot() ? 1 : (int)(NamePackage-FqNamesUtil-f4b71e84.isSubpackageOf($receiver.asString(), packageName.asString()) ? 1 : 0))) != 0;
    }

    public static final boolean isParent(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="child") @NotNull FqName child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isParent"));
        }
        return NamePackage-FqNamesUtil-f4b71e84.isSubpackageOf(child, $receiver);
    }

    public static final boolean isOneSegmentFQN(@JetValueParameter(name="$receiver") FqName $receiver) {
        return !$receiver.isRoot() ? $receiver.parent().isRoot() : false;
    }

    @NotNull
    public static final FqName withoutFirstSegment(@JetValueParameter(name="$receiver") FqName $receiver) {
        if (!$receiver.isRoot() ? $receiver.parent().isRoot() : true) {
            FqName fqName = FqName.ROOT;
            if (fqName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "withoutFirstSegment"));
            }
            return fqName;
        }
        String fqNameStr = $receiver.asString();
        FqName fqName = new FqName(KotlinPackage.substring(fqNameStr, KotlinPackage.indexOf(fqNameStr, '.') + 1, KotlinPackage.length(fqNameStr)));
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "withoutFirstSegment"));
        }
        return fqName;
    }

    public static final int numberOfSegments(@JetValueParameter(name="$receiver") FqName $receiver) {
        return $receiver.isRoot() ? 0 : 1 + NamePackage-FqNamesUtil-f4b71e84.numberOfSegments($receiver.parent());
    }

    @NotNull
    public static final FqName tail(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="headFQN") @NotNull FqName headFQN) {
        if (headFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headFQN", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "tail"));
        }
        FqName fqName = (!(!NamePackage-FqNamesUtil-f4b71e84.isSubpackageOf($receiver, headFQN)) ? headFQN.isRoot() : true) ? $receiver : (Intrinsics.areEqual($receiver, headFQN) ? FqName.ROOT : new FqName(KotlinPackage.substring($receiver.asString(), headFQN.asString().length() + 1)));
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "tail"));
        }
        return fqName;
    }

    @Nullable
    public static final FqName plusOneSegment(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="fullFQN") @NotNull FqName fullFQN) {
        if (fullFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullFQN", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "plusOneSegment"));
        }
        if (!(!NamePackage-FqNamesUtil-f4b71e84.isParent($receiver, fullFQN)) ? Intrinsics.areEqual(fullFQN, $receiver) : true) {
            return null;
        }
        Name name = KotlinPackage.getFirst(NamePackage-FqNamesUtil-f4b71e84.tail(fullFQN, $receiver).pathSegments());
        if (name == null) {
            Intrinsics.throwNpe();
        }
        return $receiver.child(name);
    }

    public static final boolean isImported(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="importPath") @NotNull ImportPath importPath) {
        if (importPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPath", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isImported"));
        }
        return importPath.hasAlias() ? false : ((importPath.isAllUnder() ? !$receiver.isRoot() : false) ? Intrinsics.areEqual(importPath.fqnPart(), $receiver.parent()) : Intrinsics.areEqual(importPath.fqnPart(), $receiver));
    }

    public static final boolean isImported(@JetValueParameter(name="$receiver") ImportPath $receiver, @JetValueParameter(name="alreadyImported") @NotNull ImportPath alreadyImported) {
        if (alreadyImported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alreadyImported", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isImported"));
        }
        return (!$receiver.isAllUnder() ? $receiver.hasAlias() : true) ? Intrinsics.areEqual($receiver, alreadyImported) : NamePackage-FqNamesUtil-f4b71e84.isImported($receiver.fqnPart(), alreadyImported);
    }

    public static final boolean isImported(@JetValueParameter(name="$receiver") ImportPath $receiver, @JetValueParameter(name="imports") @NotNull Iterable<? extends ImportPath> imports) {
        boolean bl;
        block2: {
            if (imports == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isImported"));
            }
            Iterable<? extends ImportPath> iterable = imports;
            for (ImportPath importPath : iterable) {
                ImportPath it = importPath;
                if (!Boolean.valueOf(NamePackage-FqNamesUtil-f4b71e84.isImported($receiver, it)).booleanValue()) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isValidJavaFqName(@JetValueParameter(name="qualifiedName", type="?") @Nullable String qualifiedName) {
        boolean bl = true;
        if (qualifiedName != null) {
            bl = false;
        }
        if (bl) {
            return false;
        }
        @KotlinSyntheticClass(abiVersion=16, kind=KotlinSyntheticClass.Kind.LOCAL_CLASS)
        public final class State
        extends Enum<State>
        implements KObject {
            public static final /* enum */ State BEGINNING;
            public static final /* enum */ State MIDDLE;
            public static final /* enum */ State AFTER_DOT;
            private static final /* synthetic */ State[] $VALUES;

            @NotNull
            protected State() {
                super($enum_name, $enum_ordinal);
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String string) {
                return Enum.valueOf(State.class, string);
            }

            static {
                State[] stateArray = new State[3];
                State[] stateArray2 = stateArray;
                stateArray[0] = BEGINNING = new State();
                stateArray[1] = MIDDLE = new State();
                stateArray[2] = AFTER_DOT = new State();
                $VALUES = stateArray;
            }
        }
        State state = State.BEGINNING;
        CharIterator charIterator = KotlinPackage.iterator(qualifiedName);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            State state2 = state;
            if (Intrinsics.areEqual(state2, State.BEGINNING) || Intrinsics.areEqual(state2, State.AFTER_DOT)) {
                if (!Character.isJavaIdentifierPart(c)) {
                    return false;
                }
                state = State.MIDDLE;
                continue;
            }
            if (!Intrinsics.areEqual(state2, State.MIDDLE)) continue;
            if (c == '.') {
                state = State.AFTER_DOT;
                continue;
            }
            if (!(!Character.isJavaIdentifierPart(c))) continue;
            return false;
        }
        return Intrinsics.areEqual(state, State.AFTER_DOT) ^ true;
    }

    @NotNull
    public static final Name getFirstSegment(@JetValueParameter(name="$receiver") FqName $receiver) {
        Name name = KotlinPackage.first($receiver.pathSegments());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "getFirstSegment"));
        }
        return name;
    }

    @tailRecursive
    @NotNull
    public static final void each(@JetValueParameter(name="$receiver") FqName $receiver, @JetValueParameter(name="operation") @NotNull Function1<? super FqName, ? extends Boolean> operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "each"));
        }
        while (true) {
            boolean bl = operation.invoke($receiver).booleanValue() ? !$receiver.isRoot() : false;
            if (!bl) break;
            $receiver = $receiver.parent();
        }
    }

    public static final boolean isSubpackageOf(@JetValueParameter(name="subpackageNameStr") @NotNull String subpackageNameStr, @JetValueParameter(name="packageNameStr") @NotNull String packageNameStr) {
        if (subpackageNameStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subpackageNameStr", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isSubpackageOf"));
        }
        if (packageNameStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNameStr", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "isSubpackageOf"));
        }
        return !Intrinsics.areEqual(subpackageNameStr, packageNameStr) ? (KotlinPackage.startsWith(subpackageNameStr, packageNameStr) ? subpackageNameStr.charAt(KotlinPackage.length(packageNameStr)) == '.' : false) : true;
    }

    @NotNull
    public static final String getFirstSegment(@JetValueParameter(name="fqn") @NotNull String fqn) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "getFirstSegment"));
        }
        int dotIndex = KotlinPackage.indexOf(fqn, '.');
        String string = dotIndex != -1 ? KotlinPackage.substring(fqn, 0, dotIndex) : fqn;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/name/NamePackage-FqNamesUtil-f4b71e84", "getFirstSegment"));
        }
        return string;
    }
}

