/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.lang.resolve.kotlin.DescriptorDeserializersStorage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class SignatureDeserializer {
    private static final char[] PRIMITIVE_TYPES = new char[]{'V', 'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D'};
    private final NameResolver nameResolver;

    public SignatureDeserializer(@NotNull NameResolver nameResolver) {
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "<init>"));
        }
        this.nameResolver = nameResolver;
    }

    @NotNull
    public String methodSignatureString(@NotNull JavaProtoBuf.JavaMethodSignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "methodSignatureString"));
        }
        Name name = this.nameResolver.getName(signature.getName());
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int length = signature.getParameterTypeCount();
        for (int i = 0; i < length; ++i) {
            this.typeDescriptor(signature.getParameterType(i), sb);
        }
        sb.append(')');
        this.typeDescriptor(signature.getReturnType(), sb);
        String string = name.asString() + sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "methodSignatureString"));
        }
        return string;
    }

    @NotNull
    public DescriptorDeserializersStorage.MemberSignature methodSignature(@NotNull JavaProtoBuf.JavaMethodSignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "methodSignature"));
        }
        DescriptorDeserializersStorage.MemberSignature memberSignature = DescriptorDeserializersStorage.MemberSignature.fromMethodNameAndDesc(this.methodSignatureString(signature));
        if (memberSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "methodSignature"));
        }
        return memberSignature;
    }

    @NotNull
    public String typeDescriptor(@NotNull JavaProtoBuf.JavaType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "typeDescriptor"));
        }
        String string = this.typeDescriptor(type, new StringBuilder()).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "typeDescriptor"));
        }
        return string;
    }

    @NotNull
    private StringBuilder typeDescriptor(@NotNull JavaProtoBuf.JavaType type, @NotNull StringBuilder sb) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "typeDescriptor"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "typeDescriptor"));
        }
        for (int i = 0; i < type.getArrayDimension(); ++i) {
            sb.append('[');
        }
        if (type.hasPrimitiveType()) {
            sb.append(PRIMITIVE_TYPES[type.getPrimitiveType().ordinal()]);
        } else {
            sb.append("L");
            sb.append(SignatureDeserializer.fqNameToInternalName(this.nameResolver.getFqName(type.getClassFqName())));
            sb.append(";");
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "typeDescriptor"));
        }
        return stringBuilder;
    }

    @NotNull
    private static String fqNameToInternalName(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "fqNameToInternalName"));
        }
        String string = fqName.asString().replace('.', '/');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/SignatureDeserializer", "fqNameToInternalName"));
        }
        return string;
    }
}

