/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeProvider;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeProviderImpl;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaTypeParameterImpl
extends JavaClassifierImpl<PsiTypeParameter>
implements JavaTypeParameter {
    public JavaTypeParameterImpl(@NotNull PsiTypeParameter psiTypeParameter) {
        if (psiTypeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTypeParameter", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeParameterImpl", "<init>"));
        }
        super(psiTypeParameter);
    }

    @Override
    public int getIndex() {
        return ((PsiTypeParameter)this.getPsi()).getIndex();
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = Name.identifier(((PsiTypeParameter)this.getPsi()).getName());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeParameterImpl", "getName"));
        }
        return name;
    }

    @Override
    @NotNull
    public Collection<JavaClassifierType> getUpperBounds() {
        Collection<JavaClassifierType> collection = JavaElementCollectionFromPsiArrayUtil.classifierTypes(((PsiTypeParameter)this.getPsi()).getExtendsList().getReferencedTypes());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeParameterImpl", "getUpperBounds"));
        }
        return collection;
    }

    @Override
    @Nullable
    public JavaTypeParameterListOwner getOwner() {
        PsiTypeParameterListOwner owner = ((PsiTypeParameter)this.getPsi()).getOwner();
        if (owner instanceof PsiMethod) {
            return new JavaMethodImpl((PsiMethod)owner);
        }
        if (owner instanceof PsiClass) {
            return new JavaClassImpl((PsiClass)owner);
        }
        if (owner != null) {
            throw new UnsupportedOperationException("Unsupported type parameter list owner: " + owner);
        }
        return null;
    }

    @Override
    @NotNull
    public JavaType getType() {
        JavaTypeImpl<?> javaTypeImpl = JavaTypeImpl.create(JavaPsiFacade.getInstance(((PsiTypeParameter)this.getPsi()).getProject()).getElementFactory().createType((PsiClass)this.getPsi()));
        if (javaTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeParameterImpl", "getType"));
        }
        return javaTypeImpl;
    }

    @Override
    @NotNull
    public JavaTypeProvider getTypeProvider() {
        JavaTypeProviderImpl javaTypeProviderImpl = new JavaTypeProviderImpl(((PsiTypeParameter)this.getPsi()).getManager());
        if (javaTypeProviderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeParameterImpl", "getTypeProvider"));
        }
        return javaTypeProviderImpl;
    }
}

