/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.resolve.Diagnostics;
import org.jetbrains.jet.lang.resolve.DiagnosticsElementsCache;

public class SimpleDiagnostics
implements Diagnostics {
    private final Collection<Diagnostic> diagnostics;
    private final DiagnosticsElementsCache elementsCache;

    public SimpleDiagnostics(@NotNull Collection<Diagnostic> diagnostics) {
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/jet/lang/resolve/SimpleDiagnostics", "<init>"));
        }
        this.elementsCache = new DiagnosticsElementsCache(this);
        this.diagnostics = diagnostics;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        Collection<Diagnostic> collection = this.diagnostics;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/SimpleDiagnostics", "all"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/jet/lang/resolve/SimpleDiagnostics", "forElement"));
        }
        Collection<Diagnostic> collection = this.elementsCache.getDiagnostics(psiElement);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/SimpleDiagnostics", "forElement"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        SimpleDiagnostics simpleDiagnostics = this;
        if (simpleDiagnostics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/SimpleDiagnostics", "noSuppression"));
        }
        return simpleDiagnostics;
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        Iterator<Diagnostic> iterator2 = this.all().iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/SimpleDiagnostics", "iterator"));
        }
        return iterator2;
    }

    @Override
    public boolean isEmpty() {
        return this.all().isEmpty();
    }
}

