/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;

public class JetPsiUnparsingUtils {
    private JetPsiUnparsingUtils() {
    }

    @NotNull
    public static String toIf(@Nullable JetExpression condition, @Nullable JetExpression thenExpression, @Nullable JetExpression elseExpression) {
        String string = JetPsiUnparsingUtils.toIf(JetPsiUtil.getText(condition), JetPsiUtil.getText(thenExpression), elseExpression != null ? elseExpression.getText() : null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "toIf"));
        }
        return string;
    }

    @NotNull
    public static String toIf(@NotNull String condition, @NotNull String thenExpression, @Nullable String elseExpression) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "toIf"));
        }
        if (thenExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenExpression", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "toIf"));
        }
        String string = "if " + JetPsiUnparsingUtils.parenthesizeTextIfNeeded(condition) + " " + thenExpression + (elseExpression != null ? " else " + elseExpression : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "toIf"));
        }
        return string;
    }

    @NotNull
    public static String toBinaryExpression(@Nullable JetExpression left, @NotNull String op, @Nullable JetElement right) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "toBinaryExpression"));
        }
        String string = JetPsiUnparsingUtils.toBinaryExpression(JetPsiUtil.getText(left), op, JetPsiUtil.getText(right));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "toBinaryExpression"));
        }
        return string;
    }

    @NotNull
    public static String toBinaryExpression(@NotNull String left, @NotNull String op, @NotNull String right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "toBinaryExpression"));
        }
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "toBinaryExpression"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "toBinaryExpression"));
        }
        String string = left + " " + op + " " + right;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "toBinaryExpression"));
        }
        return string;
    }

    @NotNull
    public static String parenthesizeIfNeeded(@Nullable JetExpression expression) {
        String text = JetPsiUtil.getText(expression);
        String string = expression instanceof JetParenthesizedExpression || expression instanceof JetConstantExpression || expression instanceof JetSimpleNameExpression || expression instanceof JetDotQualifiedExpression ? text : "(" + text + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "parenthesizeIfNeeded"));
        }
        return string;
    }

    @NotNull
    public static String parenthesizeTextIfNeeded(@NotNull String expressionText) {
        if (expressionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionText", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "parenthesizeTextIfNeeded"));
        }
        String string = expressionText.startsWith("(") && expressionText.endsWith(")") ? expressionText : "(" + expressionText + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUnparsingUtils", "parenthesizeTextIfNeeded"));
        }
        return string;
    }
}

