/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.cl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.CompoundEnumeration;

public class PluginClassLoader
extends UrlClassLoader {
    private final ClassLoader[] myParents;
    private final PluginId myPluginId;
    private final String myPluginVersion;
    private final List<String> myLibDirectories;

    public PluginClassLoader(@NotNull List<URL> urls, @NotNull ClassLoader[] parents, PluginId pluginId, String version, File pluginRoot) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/cl/PluginClassLoader", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/plugins/cl/PluginClassLoader", "<init>"));
        }
        super(PluginClassLoader.build().urls(urls).allowLock().useCache());
        this.myParents = parents;
        this.myPluginId = pluginId;
        this.myPluginVersion = version;
        this.myLibDirectories = ContainerUtil.newSmartList(new Object[0]);
        File libDir = new File(pluginRoot, "lib");
        if (libDir.exists()) {
            this.myLibDirectories.add(libDir.getAbsolutePath());
        }
    }

    public Class loadClass(@NotNull String name, boolean resolve2) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/cl/PluginClassLoader", "loadClass"));
        }
        Class c = this.tryLoadingClass(name, resolve2);
        if (c == null) {
            throw new ClassNotFoundException(name + " " + this);
        }
        return c;
    }

    @Nullable
    private Class tryLoadingClass(@NotNull String name, boolean resolve2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/cl/PluginClassLoader", "tryLoadingClass"));
        }
        Class c = this.loadClassInsideSelf(name);
        if (c == null) {
            c = this.loadClassFromParents(name);
        }
        if (c != null) {
            if (resolve2) {
                this.resolveClass(c);
            }
            return c;
        }
        PluginManagerCore.addPluginClass(name, this.myPluginId, false);
        return null;
    }

    @Nullable
    private Class loadClassFromParents(String name) {
        for (ClassLoader parent : this.myParents) {
            if (parent instanceof PluginClassLoader) {
                Class c = ((PluginClassLoader)parent).tryLoadingClass(name, false);
                if (c == null) continue;
                return c;
            }
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private synchronized Class loadClassInsideSelf(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/cl/PluginClassLoader", "loadClassInsideSelf"));
        }
        Class c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        try {
            c = this._findClass(name);
        }
        catch (IncompatibleClassChangeError e) {
            throw new PluginException(e, this.myPluginId);
        }
        catch (UnsupportedClassVersionError e) {
            throw new PluginException(e, this.myPluginId);
        }
        if (c != null) {
            PluginManagerCore.addPluginClass(c.getName(), this.myPluginId, true);
        }
        return c;
    }

    public boolean hasLoadedClass(String name) {
        Class<?> aClass = this.findLoadedClass(name);
        return aClass != null && aClass.getClassLoader() == this;
    }

    @Override
    public URL findResource(String name) {
        URL resource = this.findResourceImpl(name);
        if (resource != null) {
            return resource;
        }
        for (ClassLoader parent : this.myParents) {
            URL parentResource = PluginClassLoader.fetchResource(parent, name);
            if (parentResource == null) continue;
            return parentResource;
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        InputStream stream2 = super.getResourceAsStream(name);
        if (stream2 != null) {
            return stream2;
        }
        for (ClassLoader parent : this.myParents) {
            InputStream inputStream = parent.getResourceAsStream(name);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration[] resources = new Enumeration[this.myParents.length + 1];
        resources[0] = super.findResources(name);
        for (int idx = 0; idx < this.myParents.length; ++idx) {
            resources[idx + 1] = PluginClassLoader.fetchResources(this.myParents[idx], name);
        }
        return new CompoundEnumeration(resources);
    }

    @Override
    protected String findLibrary(String libName) {
        if (!this.myLibDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i = this.myLibDirectories.listIterator(this.myLibDirectories.size());
            while (i.hasPrevious()) {
                File libFile = new File(i.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    private static URL fetchResource(ClassLoader cl, String resourceName) {
        try {
            Method findResourceMethod = PluginClassLoader.getFindResourceMethod(cl.getClass(), "findResource");
            return (URL)findResourceMethod.invoke((Object)cl, resourceName);
        }
        catch (Exception e) {
            Logger.getInstance(PluginClassLoader.class).error(e);
            return null;
        }
    }

    private static Enumeration fetchResources(ClassLoader cl, String resourceName) {
        try {
            Method findResourceMethod = PluginClassLoader.getFindResourceMethod(cl.getClass(), "findResources");
            return findResourceMethod == null ? null : (Enumeration)findResourceMethod.invoke((Object)cl, resourceName);
        }
        catch (Exception e) {
            Logger.getInstance(PluginClassLoader.class).error(e);
            return null;
        }
    }

    private static Method getFindResourceMethod(Class<?> clClass, String methodName) {
        try {
            Method declaredMethod = clClass.getDeclaredMethod(methodName, String.class);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = clClass.getSuperclass();
            if (superclass == null || superclass.equals(Object.class)) {
                return null;
            }
            return PluginClassLoader.getFindResourceMethod(superclass, methodName);
        }
    }

    public String toString() {
        return "PluginClassLoader[" + this.myPluginId + ", " + this.myPluginVersion + "]";
    }
}

