/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.intellij.util.SmartList;
import java.util.List;
import jet.runtime.typeinfo.KotlinSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.declaration.PropertyTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.general.TranslatorVisitor;
import org.jetbrains.k2js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public class DeclarationBodyVisitor
extends TranslatorVisitor<Void> {
    @KotlinSignature(value="val result: MutableList<JsPropertyInitializer>")
    protected final List<JsPropertyInitializer> result;
    protected final List<JsPropertyInitializer> staticResult;
    protected final List<JsPropertyInitializer> enumEntryList;

    public DeclarationBodyVisitor(@NotNull List<JsPropertyInitializer> result, @NotNull List<JsPropertyInitializer> staticResult) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/k2js/translate/declaration/DeclarationBodyVisitor", "<init>"));
        }
        if (staticResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticResult", "org/jetbrains/k2js/translate/declaration/DeclarationBodyVisitor", "<init>"));
        }
        this.enumEntryList = new SmartList<JsPropertyInitializer>();
        this.result = result;
        this.staticResult = staticResult;
    }

    @NotNull
    public List<JsPropertyInitializer> getResult() {
        List<JsPropertyInitializer> list = this.result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/declaration/DeclarationBodyVisitor", "getResult"));
        }
        return list;
    }

    public List<JsPropertyInitializer> getEnumEntryList() {
        return this.enumEntryList;
    }

    @Override
    public Void visitClass(@NotNull JetClass expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/declaration/DeclarationBodyVisitor", "visitClass"));
        }
        return null;
    }

    @Override
    public Void visitEnumEntry(@NotNull JetEnumEntry enumEntry, TranslationContext data2) {
        JsExpression jsEnumEntryCreation;
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/k2js/translate/declaration/DeclarationBodyVisitor", "visitEnumEntry"));
        }
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(data2.bindingContext(), enumEntry);
        List<JetType> supertypes = JsDescriptorUtils.getSupertypesWithoutFakes(descriptor);
        if (enumEntry.getBody() != null || supertypes.size() > 1) {
            jsEnumEntryCreation = ClassTranslator.generateClassCreation(enumEntry, descriptor, data2);
        } else {
            assert (supertypes.size() == 1) : "Simple Enum entry must have one supertype";
            jsEnumEntryCreation = new ClassInitializerTranslator(enumEntry, data2).generateEnumEntryInstanceCreation(supertypes.get(0));
        }
        this.enumEntryList.add(new JsPropertyInitializer(data2.getNameForDescriptor(descriptor).makeRef(), jsEnumEntryCreation));
        return null;
    }

    @Override
    public Void visitClassObject(@NotNull JetClassObject classObject, TranslationContext context) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/k2js/translate/declaration/DeclarationBodyVisitor", "visitClassObject"));
        }
        JetObjectDeclaration declaration = classObject.getObjectDeclaration();
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(context.bindingContext(), declaration);
        JsInvocation value = ClassTranslator.generateClassCreation(declaration, descriptor, context);
        JsFunction fun = TranslationUtils.simpleReturnFunction(context.getScopeForDescriptor(descriptor), value);
        this.staticResult.add(InitializerUtils.createClassObjectInitializer(fun, context));
        return null;
    }

    @Override
    public Void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, TranslationContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/declaration/DeclarationBodyVisitor", "visitObjectDeclaration"));
        }
        return null;
    }

    @Override
    public Void visitNamedFunction(@NotNull JetNamedFunction expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/declaration/DeclarationBodyVisitor", "visitNamedFunction"));
        }
        FunctionDescriptor descriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression);
        if (descriptor.getModality() == Modality.ABSTRACT) {
            return null;
        }
        JsPropertyInitializer methodAsPropertyInitializer = Translation.functionTranslator(expression, context).translateAsMethod();
        this.result.add(methodAsPropertyInitializer);
        return null;
    }

    @Override
    public Void visitProperty(@NotNull JetProperty expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/declaration/DeclarationBodyVisitor", "visitProperty"));
        }
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context.bindingContext(), expression);
        PropertyTranslator.translateAccessors(propertyDescriptor, expression, this.result, context);
        return null;
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull JetClassInitializer expression, TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/declaration/DeclarationBodyVisitor", "visitAnonymousInitializer"));
        }
        return null;
    }
}

