/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public abstract class AbstractJetType
implements JetType {
    public final int hashCode() {
        int result = this.getConstructor().hashCode();
        result = 31 * result + ((Object)this.getArguments()).hashCode();
        result = 31 * result + (this.isNullable() ? 1 : 0);
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JetType)) {
            return false;
        }
        JetType type = (JetType)obj;
        return this.isNullable() == type.isNullable() && JetTypeChecker.INSTANCE.equalTypes(this, type);
    }

    public String toString() {
        List<TypeProjection> arguments = this.getArguments();
        return this.getConstructor() + (arguments.isEmpty() ? "" : "<" + AbstractJetType.argumentsToString(arguments) + ">") + (this.isNullable() ? "?" : "");
    }

    private static StringBuilder argumentsToString(List<TypeProjection> arguments) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<TypeProjection> iterator2 = arguments.iterator();
        while (iterator2.hasNext()) {
            TypeProjection argument = iterator2.next();
            stringBuilder.append(argument);
            if (!iterator2.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }
}

