/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SLRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileKotlinClass;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public final class KotlinBinaryClassCache {
    private final SLRUCache<VirtualFile, KotlinJvmBinaryClass> cache = new SLRUCache<VirtualFile, KotlinJvmBinaryClass>(2, 2){

        @Override
        @NotNull
        public KotlinJvmBinaryClass createValue(VirtualFile virtualFile) {
            VirtualFileKotlinClass virtualFileKotlinClass = new VirtualFileKotlinClass(new LockBasedStorageManager(), virtualFile);
            if (virtualFileKotlinClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/KotlinBinaryClassCache$1", "createValue"));
            }
            return virtualFileKotlinClass;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static KotlinJvmBinaryClass getKotlinBinaryClass(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/KotlinBinaryClassCache", "getKotlinBinaryClass"));
        }
        KotlinBinaryClassCache service = ServiceManager.getService(KotlinBinaryClassCache.class);
        SLRUCache<VirtualFile, KotlinJvmBinaryClass> sLRUCache = service.cache;
        // MONITORENTER : sLRUCache
        KotlinJvmBinaryClass kotlinJvmBinaryClass = service.cache.get(file);
        // MONITOREXIT : sLRUCache
        if (kotlinJvmBinaryClass != null) return kotlinJvmBinaryClass;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/KotlinBinaryClassCache", "getKotlinBinaryClass"));
    }
}

