/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinder;
import org.jetbrains.jet.lang.resolve.java.JavaPsiFacadeKotlinHacks;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaPackageImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.JetFileType;

public class JavaClassFinderImpl
implements JavaClassFinder {
    @NotNull
    private Project project;
    private GlobalSearchScope javaSearchScope;
    private JavaPsiFacadeKotlinHacks javaFacade;

    public void setProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl", "setProject"));
        }
        this.project = project;
    }

    @PostConstruct
    public void initialize() {
        this.javaSearchScope = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope(this.project)){

            @Override
            public boolean contains(VirtualFile file) {
                return this.myBaseScope.contains(file) && file.getFileType() != JetFileType.INSTANCE;
            }

            @Override
            public int compare(VirtualFile file1, VirtualFile file2) {
                int compare = super.compare(file1, file2);
                if (compare == 0) {
                    return Comparing.compare(file1.getPath(), file2.getPath());
                }
                return compare;
            }
        };
        this.javaFacade = new JavaPsiFacadeKotlinHacks(this.project);
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl", "findClass"));
        }
        PsiClass psiClass = this.javaFacade.findClass(fqName.asString(), this.javaSearchScope);
        if (psiClass == null) {
            return null;
        }
        JavaClassImpl javaClass = new JavaClassImpl(psiClass);
        if (!fqName.equals(javaClass.getFqName())) {
            throw new IllegalStateException("Requested " + fqName + ", got " + javaClass.getFqName());
        }
        if (javaClass.getOriginKind() == JavaClass.OriginKind.KOTLIN_LIGHT_CLASS) {
            throw new IllegalStateException("Kotlin light classes should not be found by JavaPsiFacade, resolving: " + fqName);
        }
        return javaClass;
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl", "findPackage"));
        }
        PsiPackage psiPackage = this.javaFacade.findPackage(fqName.asString());
        return psiPackage == null ? null : new JavaPackageImpl(psiPackage);
    }
}

