/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class ResolvedCallImpl<D extends CallableDescriptor>
implements ResolvedCallWithTrace<D> {
    public static final Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor> MAP_TO_CANDIDATE = new Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor>(){

        @Override
        public CallableDescriptor fun(ResolvedCallWithTrace<? extends CallableDescriptor> resolvedCall) {
            return resolvedCall.getCandidateDescriptor();
        }
    };
    public static final Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor> MAP_TO_RESULT = new Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor>(){

        @Override
        public CallableDescriptor fun(ResolvedCallWithTrace<? extends CallableDescriptor> resolvedCall) {
            return resolvedCall.getResultingDescriptor();
        }
    };
    private final D candidateDescriptor;
    private D resultingDescriptor;
    private final ReceiverValue thisObject;
    private final ReceiverValue receiverArgument;
    private final ExplicitReceiverKind explicitReceiverKind;
    private final boolean isSafeCall;
    private final Map<TypeParameterDescriptor, JetType> typeArguments;
    private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments;
    private final MutableDataFlowInfoForArguments dataFlowInfoForArguments;
    private final Set<ValueArgument> unmappedArguments;
    private boolean someArgumentHasNoType;
    private DelegatingBindingTrace trace;
    private TracingStrategy tracing;
    private ResolutionStatus status;
    private boolean hasUnknownTypeParameters;
    private ConstraintSystem constraintSystem;
    private Boolean hasInferredReturnType;
    private boolean completed;

    @NotNull
    public static <D extends CallableDescriptor> ResolvedCallImpl<D> create(@NotNull ResolutionCandidate<D> candidate, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "create"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "create"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "create"));
        }
        if (dataFlowInfoForArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfoForArguments", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "create"));
        }
        ResolvedCallImpl<D> resolvedCallImpl = new ResolvedCallImpl<D>(candidate, trace, tracing, dataFlowInfoForArguments);
        if (resolvedCallImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "create"));
        }
        return resolvedCallImpl;
    }

    private ResolvedCallImpl(@NotNull ResolutionCandidate<D> candidate, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing, @NotNull MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "<init>"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "<init>"));
        }
        if (dataFlowInfoForArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfoForArguments", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "<init>"));
        }
        this.typeArguments = Maps.newLinkedHashMap();
        this.valueArguments = Maps.newLinkedHashMap();
        this.unmappedArguments = Sets.newLinkedHashSet();
        this.someArgumentHasNoType = false;
        this.status = ResolutionStatus.UNKNOWN_STATUS;
        this.hasUnknownTypeParameters = false;
        this.constraintSystem = null;
        this.hasInferredReturnType = null;
        this.completed = false;
        this.candidateDescriptor = candidate.getDescriptor();
        this.thisObject = candidate.getThisObject();
        this.receiverArgument = candidate.getReceiverArgument();
        this.explicitReceiverKind = candidate.getExplicitReceiverKind();
        this.isSafeCall = candidate.isSafeCall();
        this.trace = trace;
        this.tracing = tracing;
        this.dataFlowInfoForArguments = dataFlowInfoForArguments;
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        ResolutionStatus resolutionStatus = this.status;
        if (resolutionStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getStatus"));
        }
        return resolutionStatus;
    }

    public void addStatus(@NotNull ResolutionStatus status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "addStatus"));
        }
        this.status = this.status.combine(status);
    }

    public void setStatusToSuccess() {
        assert (this.status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE || this.status == ResolutionStatus.UNKNOWN_STATUS);
        this.status = ResolutionStatus.SUCCESS;
    }

    @Override
    public boolean hasIncompleteTypeParameters() {
        return this.hasUnknownTypeParameters;
    }

    public void setHasUnknownTypeParameters(boolean hasUnknownTypeParameters) {
        this.hasUnknownTypeParameters = hasUnknownTypeParameters;
    }

    @Override
    @NotNull
    public DelegatingBindingTrace getTrace() {
        this.assertNotCompleted("Trace");
        DelegatingBindingTrace delegatingBindingTrace = this.trace;
        if (delegatingBindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getTrace"));
        }
        return delegatingBindingTrace;
    }

    @NotNull
    public TracingStrategy getTracing() {
        this.assertNotCompleted("TracingStrategy");
        TracingStrategy tracingStrategy = this.tracing;
        if (tracingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getTracing"));
        }
        return tracingStrategy;
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        D d = this.candidateDescriptor;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getCandidateDescriptor"));
        }
        return d;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        D d = this.resultingDescriptor == null ? this.candidateDescriptor : this.resultingDescriptor;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getResultingDescriptor"));
        }
        return d;
    }

    public void setResultingSubstitutor(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "setResultingSubstitutor"));
        }
        this.resultingDescriptor = this.candidateDescriptor.substitute(substitutor);
        assert (this.resultingDescriptor != null) : this.candidateDescriptor;
        for (TypeParameterDescriptor typeParameter : this.candidateDescriptor.getTypeParameters()) {
            TypeProjection typeArgumentProjection = substitutor.getSubstitution().get(typeParameter.getTypeConstructor());
            if (typeArgumentProjection == null) continue;
            this.typeArguments.put(typeParameter, typeArgumentProjection.getType());
        }
        HashMap<ValueParameterDescriptor, ValueParameterDescriptor> parameterMap = Maps.newHashMap();
        for (ValueParameterDescriptor valueParameterDescriptor : this.resultingDescriptor.getValueParameters()) {
            parameterMap.put(valueParameterDescriptor.getOriginal(), valueParameterDescriptor);
        }
        LinkedHashMap<ValueParameterDescriptor, ResolvedValueArgument> originalValueArguments = Maps.newLinkedHashMap(this.valueArguments);
        this.valueArguments.clear();
        for (Map.Entry entry : originalValueArguments.entrySet()) {
            ValueParameterDescriptor substitutedVersion = (ValueParameterDescriptor)parameterMap.get(((ValueParameterDescriptor)entry.getKey()).getOriginal());
            assert (substitutedVersion != null) : (ValueParameterDescriptor)entry.getKey();
            this.valueArguments.put(substitutedVersion, (ResolvedValueArgument)entry.getValue());
        }
    }

    public void setConstraintSystem(@NotNull ConstraintSystem constraintSystem) {
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "setConstraintSystem"));
        }
        this.constraintSystem = constraintSystem;
    }

    @Nullable
    public ConstraintSystem getConstraintSystem() {
        this.assertNotCompleted("ConstraintSystem");
        return this.constraintSystem;
    }

    public void recordValueArgument(@NotNull ValueParameterDescriptor valueParameter, @NotNull ResolvedValueArgument valueArgument) {
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "recordValueArgument"));
        }
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "recordValueArgument"));
        }
        assert (!this.valueArguments.containsKey(valueParameter)) : valueParameter + " -> " + valueArgument;
        this.valueArguments.put(valueParameter, valueArgument);
    }

    public void setUnmappedArguments(@NotNull Collection<? extends ValueArgument> unmappedArguments) {
        if (unmappedArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unmappedArguments", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "setUnmappedArguments"));
        }
        this.unmappedArguments.addAll(unmappedArguments);
    }

    @NotNull
    public Set<ValueArgument> getUnmappedArguments() {
        Set<ValueArgument> set = this.unmappedArguments;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getUnmappedArguments"));
        }
        return set;
    }

    @Override
    @NotNull
    public ReceiverValue getReceiverArgument() {
        ReceiverValue receiverValue = this.receiverArgument;
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getReceiverArgument"));
        }
        return receiverValue;
    }

    @Override
    @NotNull
    public ReceiverValue getThisObject() {
        ReceiverValue receiverValue = this.thisObject;
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getThisObject"));
        }
        return receiverValue;
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        ExplicitReceiverKind explicitReceiverKind = this.explicitReceiverKind;
        if (explicitReceiverKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getExplicitReceiverKind"));
        }
        return explicitReceiverKind;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = this.valueArguments;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getValueArguments"));
        }
        return map;
    }

    @Override
    @NotNull
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        ArrayList<ResolvedValueArgument> arguments = new ArrayList<ResolvedValueArgument>(this.candidateDescriptor.getValueParameters().size());
        for (int i = 0; i < this.candidateDescriptor.getValueParameters().size(); ++i) {
            arguments.add(null);
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : this.valueArguments.entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument value = entry.getValue();
            ResolvedValueArgument oldValue = arguments.set(parameterDescriptor.getIndex(), value);
            if (oldValue == null) continue;
            throw new IllegalStateException("Argument set twice for " + parameterDescriptor + "\n" + "old value: " + oldValue + "\n" + "new value: " + value);
        }
        for (int i = 0; i < arguments.size(); ++i) {
            Object o = arguments.get(i);
            if (o != null) continue;
            throw new IllegalStateException("No argument for " + this.getCandidateDescriptor().getValueParameters().get(i));
        }
        ArrayList<ResolvedValueArgument> arrayList = arguments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getValueArgumentsByIndex"));
        }
        return arrayList;
    }

    public void argumentHasNoType() {
        this.someArgumentHasNoType = true;
    }

    @Override
    public boolean isDirty() {
        return this.someArgumentHasNoType;
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, JetType> getTypeArguments() {
        Map<TypeParameterDescriptor, JetType> map = this.typeArguments;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getTypeArguments"));
        }
        return map;
    }

    @Override
    public boolean isSafeCall() {
        return this.isSafeCall;
    }

    public void setInitialDataFlowInfo(@NotNull DataFlowInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "setInitialDataFlowInfo"));
        }
        this.dataFlowInfoForArguments.setInitialDataFlowInfo(info);
    }

    @Override
    @NotNull
    public MutableDataFlowInfoForArguments getDataFlowInfoForArguments() {
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = this.dataFlowInfoForArguments;
        if (mutableDataFlowInfoForArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getDataFlowInfoForArguments"));
        }
        return mutableDataFlowInfoForArguments;
    }

    @Override
    @NotNull
    public ResolvedCallImpl<D> getCallToCompleteTypeArgumentInference() {
        ResolvedCallImpl resolvedCallImpl = this;
        if (resolvedCallImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/ResolvedCallImpl", "getCallToCompleteTypeArgumentInference"));
        }
        return resolvedCallImpl;
    }

    public boolean hasInferredReturnType() {
        if (!this.completed) {
            this.hasInferredReturnType = this.constraintSystem == null || CallResolverUtil.hasInferredReturnType(this.candidateDescriptor, this.constraintSystem);
        }
        assert (this.hasInferredReturnType != null) : "The property 'hasInferredReturnType' was not set when the call was completed.";
        return this.hasInferredReturnType;
    }

    @Override
    public void markCallAsCompleted() {
        if (!this.completed) {
            this.hasInferredReturnType();
        }
        this.trace = null;
        this.constraintSystem = null;
        this.tracing = null;
        this.completed = true;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    private void assertNotCompleted(String elementName) {
        assert (!this.completed) : elementName + " is erased after resolution completion.";
    }
}

