/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeBounds;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class TypeBoundsImpl
implements TypeBounds {
    private final TypeParameterDescriptor typeVariable;
    private final Variance varianceOfPosition;
    private final Set<TypeBounds.Bound> bounds;
    private Collection<JetType> resultValues;

    public TypeBoundsImpl(@NotNull TypeParameterDescriptor typeVariable, @NotNull Variance varianceOfPosition) {
        if (typeVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeVariable", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "<init>"));
        }
        if (varianceOfPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varianceOfPosition", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "<init>"));
        }
        this.bounds = Sets.newLinkedHashSet();
        this.typeVariable = typeVariable;
        this.varianceOfPosition = varianceOfPosition;
    }

    @Override
    @NotNull
    public Variance getVarianceOfPosition() {
        Variance variance = this.varianceOfPosition;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "getVarianceOfPosition"));
        }
        return variance;
    }

    public void addBound(@NotNull TypeBounds.BoundKind kind, @NotNull JetType type, @NotNull ConstraintPosition position) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "addBound"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "addBound"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "addBound"));
        }
        this.resultValues = null;
        this.bounds.add(new TypeBounds.Bound(type, kind, position));
    }

    @Override
    public boolean isEmpty() {
        return this.getValues().isEmpty();
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getTypeVariable() {
        TypeParameterDescriptor typeParameterDescriptor = this.typeVariable;
        if (typeParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "getTypeVariable"));
        }
        return typeParameterDescriptor;
    }

    @Override
    @NotNull
    public Collection<TypeBounds.Bound> getBounds() {
        Set<TypeBounds.Bound> set = this.bounds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "getBounds"));
        }
        return set;
    }

    @NotNull
    private static Set<JetType> filterBounds(@NotNull Collection<TypeBounds.Bound> bounds, @NotNull TypeBounds.BoundKind kind) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "filterBounds"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "filterBounds"));
        }
        Set<JetType> set = TypeBoundsImpl.filterBounds(bounds, kind, null);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "filterBounds"));
        }
        return set;
    }

    @NotNull
    private static Set<JetType> filterBounds(@NotNull Collection<TypeBounds.Bound> bounds, @NotNull TypeBounds.BoundKind kind, @Nullable Collection<JetType> errorValues) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "filterBounds"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "filterBounds"));
        }
        LinkedHashSet<JetType> result = Sets.newLinkedHashSet();
        for (TypeBounds.Bound bound : bounds) {
            if (bound.kind != kind) continue;
            if (!ErrorUtils.containsErrorType(bound.type)) {
                result.add(bound.type);
                continue;
            }
            if (errorValues == null) continue;
            errorValues.add(bound.type);
        }
        LinkedHashSet<JetType> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "filterBounds"));
        }
        return linkedHashSet;
    }

    TypeBoundsImpl copy() {
        TypeBoundsImpl typeBounds = new TypeBoundsImpl(this.typeVariable, this.varianceOfPosition);
        typeBounds.bounds.addAll(this.bounds);
        typeBounds.resultValues = this.resultValues;
        return typeBounds;
    }

    @NotNull
    public TypeBoundsImpl filter(final @NotNull Condition<ConstraintPosition> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "filter"));
        }
        TypeBoundsImpl result = new TypeBoundsImpl(this.typeVariable, this.varianceOfPosition);
        result.bounds.addAll(ContainerUtil.filter(this.bounds, new Condition<TypeBounds.Bound>(){

            @Override
            public boolean value(TypeBounds.Bound bound) {
                return condition.value(bound.position);
            }
        }));
        TypeBoundsImpl typeBoundsImpl = result;
        if (typeBoundsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "filter"));
        }
        return typeBoundsImpl;
    }

    @Override
    @Nullable
    public JetType getValue() {
        Collection<JetType> values = this.getValues();
        if (values.size() == 1) {
            return values.iterator().next();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<JetType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<JetType> collection = this.resultValues;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "getValues"));
        }
        return collection;
    }

    @NotNull
    private Collection<JetType> computeValues() {
        JetType superTypeOfAllLowerBounds;
        JetType exactBound;
        LinkedHashSet<JetType> values = Sets.newLinkedHashSet();
        if (this.bounds.isEmpty()) {
            List<JetType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "computeValues"));
            }
            return list;
        }
        boolean hasStrongBound = ContainerUtil.exists(this.bounds, new Condition<TypeBounds.Bound>(){

            @Override
            public boolean value(TypeBounds.Bound bound) {
                return bound.position.isStrong();
            }
        });
        if (!hasStrongBound) {
            List<JetType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "computeValues"));
            }
            return list;
        }
        Set<JetType> exactBounds = TypeBoundsImpl.filterBounds(this.bounds, TypeBounds.BoundKind.EXACT_BOUND, values);
        if (exactBounds.size() == 1 && this.tryPossibleAnswer(exactBound = exactBounds.iterator().next())) {
            Set<JetType> set = Collections.singleton(exactBound);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "computeValues"));
            }
            return set;
        }
        values.addAll(exactBounds);
        Pair<Collection<JetType>, Collection<JetType>> pair = TypeUtils.filterNumberTypes(TypeBoundsImpl.filterBounds(this.bounds, TypeBounds.BoundKind.LOWER_BOUND, values));
        Collection<JetType> generalLowerBounds = pair.getFirst();
        Collection<JetType> numberLowerBounds = pair.getSecond();
        JetType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes(generalLowerBounds);
        if (this.tryPossibleAnswer(superTypeOfLowerBounds)) {
            Set<JetType> set = Collections.singleton(superTypeOfLowerBounds);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "computeValues"));
            }
            return set;
        }
        ContainerUtil.addIfNotNull(superTypeOfLowerBounds, values);
        JetType superTypeOfNumberLowerBounds = TypeUtils.commonSupertypeForNumberTypes(numberLowerBounds);
        if (this.tryPossibleAnswer(superTypeOfNumberLowerBounds)) {
            Set<JetType> set = Collections.singleton(superTypeOfNumberLowerBounds);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "computeValues"));
            }
            return set;
        }
        ContainerUtil.addIfNotNull(superTypeOfNumberLowerBounds, values);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.tryPossibleAnswer(superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes(Lists.newArrayList(superTypeOfLowerBounds, superTypeOfNumberLowerBounds)))) {
            Set<JetType> set = Collections.singleton(superTypeOfAllLowerBounds);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "computeValues"));
            }
            return set;
        }
        Set<JetType> upperBounds = TypeBoundsImpl.filterBounds(this.bounds, TypeBounds.BoundKind.UPPER_BOUND, values);
        JetType intersectionOfUpperBounds = TypeUtils.intersect(JetTypeChecker.INSTANCE, upperBounds);
        if (!upperBounds.isEmpty() && intersectionOfUpperBounds != null && this.tryPossibleAnswer(intersectionOfUpperBounds)) {
            Set<JetType> set = Collections.singleton(intersectionOfUpperBounds);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "computeValues"));
            }
            return set;
        }
        values.addAll(TypeBoundsImpl.filterBounds(this.bounds, TypeBounds.BoundKind.UPPER_BOUND));
        LinkedHashSet<JetType> linkedHashSet = values;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBoundsImpl", "computeValues"));
        }
        return linkedHashSet;
    }

    private boolean tryPossibleAnswer(@Nullable JetType possibleAnswer) {
        if (possibleAnswer == null) {
            return false;
        }
        if (!possibleAnswer.getConstructor().isDenotable()) {
            return false;
        }
        for (TypeBounds.Bound bound : this.bounds) {
            switch (bound.kind) {
                case LOWER_BOUND: {
                    if (JetTypeChecker.INSTANCE.isSubtypeOf(bound.type, possibleAnswer)) break;
                    return false;
                }
                case UPPER_BOUND: {
                    if (JetTypeChecker.INSTANCE.isSubtypeOf(possibleAnswer, bound.type)) break;
                    return false;
                }
                case EXACT_BOUND: {
                    if (JetTypeChecker.INSTANCE.equalTypes(bound.type, possibleAnswer)) break;
                    return false;
                }
            }
        }
        return true;
    }
}

