/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitorWithResult;

public class ConditionalJumpInstruction
extends AbstractJumpInstruction {
    private final boolean onTrue;
    private Instruction nextOnTrue;
    private Instruction nextOnFalse;

    public ConditionalJumpInstruction(boolean onTrue, Label targetLabel) {
        super(targetLabel);
        this.onTrue = onTrue;
    }

    public boolean onTrue() {
        return this.onTrue;
    }

    public Instruction getNextOnTrue() {
        return this.nextOnTrue;
    }

    public void setNextOnTrue(Instruction nextOnTrue) {
        this.nextOnTrue = this.outgoingEdgeTo(nextOnTrue);
    }

    public Instruction getNextOnFalse() {
        return this.nextOnFalse;
    }

    public void setNextOnFalse(Instruction nextOnFalse) {
        this.nextOnFalse = this.outgoingEdgeTo(nextOnFalse);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        List<Instruction> list = Arrays.asList(this.getNextOnFalse(), this.getNextOnTrue());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/ConditionalJumpInstruction", "getNextInstructions"));
        }
        return list;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/ConditionalJumpInstruction", "accept"));
        }
        visitor.visitConditionalJump(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/ConditionalJumpInstruction", "accept"));
        }
        return visitor.visitConditionalJump(this);
    }

    public String toString() {
        String instr = this.onTrue ? "jt" : "jf";
        return instr + "(" + this.getTargetLabel().getName() + ")";
    }

    @Override
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel) {
        if (newLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLabel", "org/jetbrains/jet/lang/cfg/pseudocode/ConditionalJumpInstruction", "createCopy"));
        }
        return new ConditionalJumpInstruction(this.onTrue, newLabel);
    }
}

