/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Function0;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedTypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.AbstractJetType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.LazyType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;

public class TypeDeserializer {
    private final NameResolver nameResolver;
    private final DescriptorFinder descriptorFinder;
    private final TypeDeserializer parent;
    private final TIntObjectHashMap<TypeParameterDescriptor> typeParameterDescriptors;
    private final MemoizedFunctionToNullable<Integer, ClassDescriptor> classDescriptors;
    private final String debugName;
    private final StorageManager storageManager;

    public TypeDeserializer(@NotNull StorageManager storageManager, @NotNull TypeDeserializer parent, @NotNull String debugName, @NotNull TypeParameterResolver typeParameterResolver) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "<init>"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "<init>"));
        }
        if (typeParameterResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterResolver", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "<init>"));
        }
        this(storageManager, parent, parent.nameResolver, parent.descriptorFinder, debugName, typeParameterResolver);
    }

    public TypeDeserializer(@NotNull StorageManager storageManager, @Nullable TypeDeserializer parent, @NotNull NameResolver nameResolver, @NotNull DescriptorFinder descriptorFinder, @NotNull String debugName, @NotNull TypeParameterResolver typeParameterResolver) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "<init>"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "<init>"));
        }
        if (descriptorFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorFinder", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "<init>"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "<init>"));
        }
        if (typeParameterResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterResolver", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "<init>"));
        }
        this.typeParameterDescriptors = new TIntObjectHashMap();
        this.storageManager = storageManager;
        this.parent = parent;
        this.nameResolver = nameResolver;
        this.descriptorFinder = descriptorFinder;
        this.debugName = debugName + (parent == null ? "" : ". Child of " + parent.debugName);
        for (DeserializedTypeParameterDescriptor typeParameterDescriptor : typeParameterResolver.getTypeParameters(this)) {
            this.typeParameterDescriptors.put(typeParameterDescriptor.getProtoId(), typeParameterDescriptor);
        }
        this.classDescriptors = storageManager.createMemoizedFunctionWithNullableValues(new Function1<Integer, ClassDescriptor>(){

            @Override
            public ClassDescriptor invoke(Integer fqNameIndex) {
                return TypeDeserializer.this.computeClassDescriptor(fqNameIndex);
            }
        });
    }

    @Nullable
    public JetType typeOrNull(@Nullable ProtoBuf.Type proto) {
        if (proto == null) {
            return null;
        }
        return this.type(proto);
    }

    @NotNull
    public JetType type(@NotNull ProtoBuf.Type proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "type"));
        }
        DeserializedType deserializedType = new DeserializedType(proto);
        if (deserializedType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "type"));
        }
        return deserializedType;
    }

    private TypeConstructor typeConstructor(ProtoBuf.Type proto) {
        ProtoBuf.Type.Constructor constructorProto = proto.getConstructor();
        int id = constructorProto.getId();
        TypeConstructor typeConstructor = this.typeConstructor(constructorProto);
        if (typeConstructor == null) {
            String message = constructorProto.getKind() == ProtoBuf.Type.Constructor.Kind.CLASS ? this.nameResolver.getClassId(id).asSingleFqName().asString() : "Unknown type parameter " + id;
            typeConstructor = ErrorUtils.createErrorType(message).getConstructor();
        }
        return typeConstructor;
    }

    @Nullable
    private TypeConstructor typeConstructor(@NotNull ProtoBuf.Type.Constructor proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "typeConstructor"));
        }
        switch (proto.getKind()) {
            case CLASS: {
                ClassDescriptor classDescriptor = (ClassDescriptor)this.classDescriptors.invoke(proto.getId());
                if (classDescriptor == null) {
                    return null;
                }
                return classDescriptor.getTypeConstructor();
            }
            case TYPE_PARAMETER: {
                return this.typeParameterTypeConstructor(proto);
            }
        }
        throw new IllegalStateException("Unknown kind " + proto.getKind());
    }

    @Nullable
    private TypeConstructor typeParameterTypeConstructor(@NotNull ProtoBuf.Type.Constructor proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "typeParameterTypeConstructor"));
        }
        TypeParameterDescriptor descriptor = this.typeParameterDescriptors.get(proto.getId());
        if (descriptor != null) {
            return descriptor.getTypeConstructor();
        }
        if (this.parent != null) {
            return this.parent.typeParameterTypeConstructor(proto);
        }
        return null;
    }

    @Nullable
    private ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId classId = this.nameResolver.getClassId(fqNameIndex);
        return this.descriptorFinder.findClass(classId);
    }

    private List<TypeProjection> typeArguments(List<ProtoBuf.Type.Argument> protos) {
        ArrayList<TypeProjection> result = new ArrayList<TypeProjection>(protos.size());
        for (ProtoBuf.Type.Argument proto : protos) {
            result.add(this.typeProjection(proto));
        }
        return result;
    }

    private TypeProjection typeProjection(ProtoBuf.Type.Argument proto) {
        return new TypeProjectionImpl(TypeDeserializer.variance(proto.getProjection()), this.type(proto.getType()));
    }

    private static Variance variance(ProtoBuf.Type.Argument.Projection proto) {
        switch (proto) {
            case IN: {
                return Variance.IN_VARIANCE;
            }
            case OUT: {
                return Variance.OUT_VARIANCE;
            }
            case INV: {
                return Variance.INVARIANT;
            }
        }
        throw new IllegalStateException("Unknown projection: " + proto);
    }

    @NotNull
    private static JetScope getTypeMemberScope(@NotNull TypeConstructor constructor, @NotNull List<TypeProjection> typeArguments) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "getTypeMemberScope"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "getTypeMemberScope"));
        }
        ClassifierDescriptor descriptor = constructor.getDeclarationDescriptor();
        if (descriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)descriptor;
            JetScope jetScope = typeParameterDescriptor.getDefaultType().getMemberScope();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "getTypeMemberScope"));
            }
            return jetScope;
        }
        JetScope jetScope = ((ClassDescriptor)descriptor).getMemberScope(typeArguments);
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer", "getTypeMemberScope"));
        }
        return jetScope;
    }

    public String toString() {
        return this.debugName;
    }

    private class DeserializedType
    extends AbstractJetType
    implements LazyType {
        private final ProtoBuf.Type typeProto;
        private final NotNullLazyValue<TypeConstructor> constructor;
        private final List<TypeProjection> arguments;
        private final NotNullLazyValue<JetScope> memberScope;

        public DeserializedType(@NotNull ProtoBuf.Type proto) {
            if (proto == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer$DeserializedType", "<init>"));
            }
            this.typeProto = proto;
            this.arguments = TypeDeserializer.this.typeArguments(proto.getArgumentList());
            this.constructor = TypeDeserializer.this.storageManager.createLazyValue(new Function0<TypeConstructor>(){

                @Override
                public TypeConstructor invoke() {
                    return TypeDeserializer.this.typeConstructor(DeserializedType.this.typeProto);
                }
            });
            this.memberScope = TypeDeserializer.this.storageManager.createLazyValue(new Function0<JetScope>(){

                @Override
                public JetScope invoke() {
                    return DeserializedType.this.computeMemberScope();
                }
            });
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            TypeConstructor typeConstructor = (TypeConstructor)this.constructor.invoke();
            if (typeConstructor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer$DeserializedType", "getConstructor"));
            }
            return typeConstructor;
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            List<TypeProjection> list = this.arguments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer$DeserializedType", "getArguments"));
            }
            return list;
        }

        @Override
        public boolean isNullable() {
            return this.typeProto.getNullable();
        }

        @NotNull
        private JetScope computeMemberScope() {
            if (this.isError()) {
                JetScope jetScope = ErrorUtils.createErrorScope(this.getConstructor().toString());
                if (jetScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer$DeserializedType", "computeMemberScope"));
                }
                return jetScope;
            }
            JetScope jetScope = TypeDeserializer.getTypeMemberScope(this.getConstructor(), this.getArguments());
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer$DeserializedType", "computeMemberScope"));
            }
            return jetScope;
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            JetScope jetScope = (JetScope)this.memberScope.invoke();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer$DeserializedType", "getMemberScope"));
            }
            return jetScope;
        }

        @Override
        public boolean isError() {
            ClassifierDescriptor descriptor = this.getConstructor().getDeclarationDescriptor();
            return descriptor != null && ErrorUtils.isError(descriptor);
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations = Annotations.EMPTY;
            if (annotations == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer$DeserializedType", "getAnnotations"));
            }
            return annotations;
        }
    }

    public static interface TypeParameterResolver {
        public static final TypeParameterResolver NONE = new TypeParameterResolver(){

            @Override
            @NotNull
            public List<DeserializedTypeParameterDescriptor> getTypeParameters(@NotNull TypeDeserializer typeDeserializer) {
                if (typeDeserializer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDeserializer", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer$TypeParameterResolver$1", "getTypeParameters"));
                }
                List<DeserializedTypeParameterDescriptor> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/TypeDeserializer$TypeParameterResolver$1", "getTypeParameters"));
                }
                return list;
            }
        };

        @NotNull
        public List<DeserializedTypeParameterDescriptor> getTypeParameters(@NotNull TypeDeserializer var1);
    }
}

