/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.ParentCodegenAwareImpl;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.TraitImplBodyCodegen;
import org.jetbrains.jet.codegen.context.ClassContext;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.inline.InlineCodegenUtil;
import org.jetbrains.jet.codegen.inline.NameGenerator;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.types.ErrorUtils;

public class MemberCodegen
extends ParentCodegenAwareImpl {
    protected final FieldOwnerContext context;
    private final ClassBuilder builder;
    private NameGenerator inlineNameGenerator;

    public MemberCodegen(@NotNull GenerationState state, @Nullable MemberCodegen parentCodegen, @NotNull FieldOwnerContext context, @Nullable ClassBuilder builder) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/MemberCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/MemberCodegen", "<init>"));
        }
        super(state, parentCodegen);
        this.context = context;
        this.builder = builder;
    }

    public void genFunctionOrProperty(@NotNull FieldOwnerContext context, @NotNull JetTypeParameterListOwner functionOrProperty, @NotNull ClassBuilder classBuilder) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/MemberCodegen", "genFunctionOrProperty"));
        }
        if (functionOrProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionOrProperty", "org/jetbrains/jet/codegen/MemberCodegen", "genFunctionOrProperty"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/jet/codegen/MemberCodegen", "genFunctionOrProperty"));
        }
        FunctionCodegen functionCodegen = new FunctionCodegen(context, classBuilder, this.state, this);
        if (functionOrProperty instanceof JetNamedFunction) {
            try {
                functionCodegen.gen((JetNamedFunction)functionOrProperty);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate function " + functionOrProperty.getName(), e, functionOrProperty);
            }
        } else if (functionOrProperty instanceof JetProperty) {
            try {
                new PropertyCodegen(context, classBuilder, functionCodegen, this).gen((JetProperty)functionOrProperty);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate property " + functionOrProperty.getName(), e, functionOrProperty);
            }
        } else {
            throw new IllegalArgumentException("Unknown parameter: " + functionOrProperty);
        }
    }

    public static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull JetClassOrObject aClass, @NotNull GenerationState state, @Nullable MemberCodegen parentCodegen) {
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/jet/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/jet/codegen/MemberCodegen", "genClassOrObject"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/MemberCodegen", "genClassOrObject"));
        }
        ClassDescriptor descriptor = state.getBindingContext().get(BindingContext.CLASS, aClass);
        if (descriptor == null || ErrorUtils.isError(descriptor)) {
            MemberCodegen.badDescriptor(descriptor, state.getClassBuilderMode());
            return;
        }
        if (descriptor.getName().equals(SpecialNames.NO_NAME_PROVIDED)) {
            MemberCodegen.badDescriptor(descriptor, state.getClassBuilderMode());
        }
        ClassBuilder classBuilder = state.getFactory().forClassImplementation(descriptor, aClass.getContainingFile());
        ClassContext classContext = parentContext.intoClass(descriptor, OwnerKind.IMPLEMENTATION, state);
        new ImplementationBodyCodegen(aClass, classContext, classBuilder, state, parentCodegen).generate();
        classBuilder.done();
        if (aClass instanceof JetClass && ((JetClass)aClass).isTrait()) {
            ClassBuilder traitBuilder = state.getFactory().forTraitImplementation(descriptor, state, aClass.getContainingFile());
            new TraitImplBodyCodegen(aClass, parentContext.intoClass(descriptor, OwnerKind.TRAIT_IMPL, state), traitBuilder, state, parentCodegen).generate();
            traitBuilder.done();
        }
    }

    private static void badDescriptor(ClassDescriptor descriptor, ClassBuilderMode mode) {
        if (mode != ClassBuilderMode.LIGHT_CLASSES) {
            throw new IllegalStateException("Generating bad descriptor in ClassBuilderMode = " + (Object)((Object)mode) + ": " + descriptor);
        }
    }

    public void genClassOrObject(CodegenContext parentContext, JetClassOrObject aClass) {
        MemberCodegen.genClassOrObject(parentContext, aClass, this.state, this);
    }

    @NotNull
    public ClassBuilder getBuilder() {
        ClassBuilder classBuilder = this.builder;
        if (classBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/MemberCodegen", "getBuilder"));
        }
        return classBuilder;
    }

    public NameGenerator getInlineNameGenerator() {
        if (this.inlineNameGenerator == null) {
            String prefix = InlineCodegenUtil.getInlineName(this.context, this.typeMapper);
            this.inlineNameGenerator = new NameGenerator(prefix);
        }
        return this.inlineNameGenerator;
    }
}

