/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiImplUtil");
    private static final Set<PsiAnnotation.TargetType> DEFAULT_TARGETS = Collections.unmodifiableSet(ContainerUtil.newHashSet(PsiAnnotation.TargetType.PACKAGE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.LOCAL_VARIABLE));
    private static final PsiAnnotation.TargetType[] PACKAGE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE};
    private static final PsiAnnotation.TargetType[] TYPE_USE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] ANNOTATION_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] TYPE_PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] CONSTRUCTOR_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.CONSTRUCTOR, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] METHOD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] FIELD_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] PARAMETER_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
    private static final PsiAnnotation.TargetType[] LOCAL_VARIABLE_TARGETS = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.LOCAL_VARIABLE, PsiAnnotation.TargetType.TYPE_USE};

    private PsiImplUtil() {
    }

    @NotNull
    public static PsiMethod[] getConstructors(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "getConstructors"));
        }
        SmartList<PsiMethod> constructorsList = new SmartList<PsiMethod>();
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (!method.isConstructor()) continue;
            constructorsList.add(method);
        }
        PsiMethod[] psiMethodArray = constructorsList.toArray(new PsiMethod[constructorsList.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getConstructors"));
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiAnnotationMemberValue findDeclaredAttributeValue(@NotNull PsiAnnotation annotation, @NonNls String attributeName) {
        PsiNameValuePair[] attributes;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "findDeclaredAttributeValue"));
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
            String name = attribute.getName();
            if (!Comparing.equal(name, attributeName) && (attributeName != null || !"value".equals(name))) continue;
            return attribute.getValue();
        }
        return null;
    }

    @Nullable
    public static PsiAnnotationMemberValue findAttributeValue(@NotNull PsiAnnotation annotation, @Nullable @NonNls String attributeName) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "findAttributeValue"));
        }
        PsiAnnotationMemberValue value = PsiImplUtil.findDeclaredAttributeValue(annotation, attributeName);
        if (value != null) {
            return value;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        if ((referenceElement = annotation.getNameReferenceElement()) != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = ((PsiClass)resolved).getMethods()) {
                if (!PsiUtil.isAnnotationMethod(method) || !Comparing.equal(method.getName(), attributeName)) continue;
                return ((PsiAnnotationMethod)method).getDefaultValue();
            }
        }
        return null;
    }

    @NotNull
    public static PsiTypeParameter[] getTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "getTypeParameters"));
        }
        PsiTypeParameterList typeParameterList = owner.getTypeParameterList();
        if (typeParameterList != null) {
            PsiTypeParameter[] psiTypeParameterArray = typeParameterList.getTypeParameters();
            if (psiTypeParameterArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTypeParameters"));
            }
            return psiTypeParameterArray;
        }
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTypeParameters"));
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    @NotNull
    public static PsiJavaCodeReferenceElement[] namesToPackageReferences(@NotNull PsiManager manager, @NotNull String[] names) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "namesToPackageReferences"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "namesToPackageReferences"));
        }
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                refs[i] = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createPackageReferenceElement(name);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }
        if (refs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "namesToPackageReferences"));
        }
        return refs;
    }

    public static int getParameterIndex(@NotNull PsiParameter parameter, @NotNull PsiParameterList parameterList) {
        int i;
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "getParameterIndex"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "getParameterIndex"));
        }
        PsiElement parameterParent = parameter.getParent();
        assert (parameterParent == parameterList) : parameterList + "; " + parameterParent;
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            PsiParameter paramInList = parameters[i2];
            if (!parameter.equals(paramInList)) continue;
            return i2;
        }
        String name = parameter.getName();
        PsiParameter suspect = null;
        for (i = parameters.length - 1; i >= 0; --i) {
            PsiParameter paramInList = parameters[i];
            if (!Comparing.equal(name, paramInList.getName())) continue;
            suspect = paramInList;
            break;
        }
        String message = parameter + ":" + parameter.getClass() + " not found among parameters: " + Arrays.asList(parameters) + "." + " parameterList' parent: " + parameterList.getParent() + ";" + " parameter.isValid()=" + parameter.isValid() + ";" + " parameterList.isValid()= " + parameterList.isValid() + ";" + " parameterList stub: " + (parameterList instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)parameterList)).getStub() : "---") + "; " + " parameter stub: " + (parameter instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)parameter)).getStub() : "---") + ";" + " suspect: " + suspect + " (index=" + i + "); " + (suspect == null ? null : suspect.getClass()) + " suspect stub: " + (suspect instanceof StubBasedPsiElement ? ((StubBasedPsiElement)((Object)suspect)).getStub() : (suspect == null ? "-null-" : "---" + suspect.getClass())) + ";" + " parameter.equals(suspect) = " + parameter.equals(suspect) + "; " + " parameter.getNode() == suspect.getNode():  " + (parameter.getNode() == (suspect == null ? null : suspect.getNode())) + "; " + ".";
        LOG.error(message);
        return i;
    }

    public static int getTypeParameterIndex(@NotNull PsiTypeParameter typeParameter, @NotNull PsiTypeParameterList typeParameterList) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "getTypeParameterIndex"));
        }
        if (typeParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "getTypeParameterIndex"));
        }
        PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameter.equals(typeParameters[i])) continue;
            return i;
        }
        LOG.assertTrue(false);
        return -1;
    }

    @NotNull
    public static Object[] getReferenceVariantsByFilter(@NotNull PsiJavaCodeReferenceElement reference, @NotNull ElementFilter filter) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "getReferenceVariantsByFilter"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "getReferenceVariantsByFilter"));
        }
        FilterScopeProcessor processor = new FilterScopeProcessor(filter);
        PsiScopesUtil.resolveAndWalk(processor, reference, null, true);
        Object[] objectArray = processor.getResults().toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getReferenceVariantsByFilter"));
        }
        return objectArray;
    }

    public static boolean processDeclarationsInMethod(@NotNull PsiMethod method, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInMethod"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInMethod"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInMethod"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInMethod"));
        }
        boolean fromBody = lastParent instanceof PsiCodeBlock;
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        PsiParameterList parameterList = method.getParameterList();
        return PsiImplUtil.processDeclarationsInMethodLike(method, processor, state, place, fromBody, typeParameterList, parameterList);
    }

    public static boolean processDeclarationsInLambda(@NotNull PsiLambdaExpression lambda, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (lambda == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInLambda"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInLambda"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInLambda"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInLambda"));
        }
        boolean fromBody = lastParent != null && lastParent == lambda.getBody();
        PsiParameterList parameterList = lambda.getParameterList();
        return PsiImplUtil.processDeclarationsInMethodLike(lambda, processor, state, place, fromBody, null, parameterList);
    }

    private static boolean processDeclarationsInMethodLike(@NotNull PsiElement element, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, boolean fromBody, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiParameterList parameterList) {
        ElementClassHint hint;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInMethodLike"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInMethodLike"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInMethodLike"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInMethodLike"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInMethodLike"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, element);
        if (typeParameterList != null && ((hint = processor.getHint(ElementClassHint.KEY)) == null || hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && !typeParameterList.processDeclarations(processor, state, null, place)) {
            return false;
        }
        if (fromBody) {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = parameterList.getParameters()) {
                if (processor.execute(parameter, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInResourceList(@NotNull PsiResourceList resourceList, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent) {
        if (resourceList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInResourceList"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInResourceList"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/PsiImplUtil", "processDeclarationsInResourceList"));
        }
        ElementClassHint hint = processor.getHint(ElementClassHint.KEY);
        if (hint != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        List<PsiResourceVariable> resources = resourceList.getResourceVariables();
        int lastIdx = lastParent instanceof PsiResourceVariable ? resources.indexOf(lastParent) : resources.size();
        for (int i = 0; i < lastIdx; ++i) {
            if (processor.execute(resources.get(i), state)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "hasTypeParameters"));
        }
        PsiTypeParameterList typeParameterList = owner.getTypeParameterList();
        return typeParameterList != null && typeParameterList.getTypeParameters().length != 0;
    }

    @NotNull
    public static PsiType[] typesByReferenceParameterList(@NotNull PsiReferenceParameterList parameterList) {
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "typesByReferenceParameterList"));
        }
        PsiTypeElement[] typeElements = parameterList.getTypeParameterElements();
        PsiType[] psiTypeArray = PsiImplUtil.typesByTypeElements(typeElements);
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "typesByReferenceParameterList"));
        }
        return psiTypeArray;
    }

    @NotNull
    public static PsiType[] typesByTypeElements(@NotNull PsiTypeElement[] typeElements) {
        if (typeElements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "typesByTypeElements"));
        }
        PsiType[] types = PsiType.createArray(typeElements.length);
        for (int i = 0; i < types.length; ++i) {
            types[i] = typeElements[i].getType();
        }
        if (types.length == 1 && types[0] instanceof PsiDiamondType) {
            PsiType[] psiTypeArray = ((PsiDiamondType)types[0]).resolveInferredTypes().getTypes();
            if (psiTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "typesByTypeElements"));
            }
            return psiTypeArray;
        }
        if (types == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "typesByTypeElements"));
        }
        return types;
    }

    public static PsiType getType(@NotNull PsiClassObjectAccessExpression classAccessExpression) {
        PsiTypeParameter[] typeParameters;
        if (classAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "getType"));
        }
        GlobalSearchScope resolveScope = classAccessExpression.getResolveScope();
        PsiManager manager = classAccessExpression.getManager();
        PsiClass classClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Class", resolveScope);
        if (classClass == null) {
            return new PsiClassReferenceType(new LightClassReference(manager, "Class", "java.lang.Class", resolveScope), null);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher(classAccessExpression)) {
            return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(classClass);
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiType operandType = classAccessExpression.getOperand().getType();
        if (operandType instanceof PsiPrimitiveType && !PsiType.NULL.equals(operandType)) {
            operandType = PsiType.VOID.equals(operandType) ? JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Void", classAccessExpression.getResolveScope()) : ((PsiPrimitiveType)operandType).getBoxedType(classAccessExpression);
        }
        if ((typeParameters = classClass.getTypeParameters()).length == 1) {
            substitutor = substitutor.put(typeParameters[0], operandType);
        }
        return new PsiImmediateClassType(classClass, substitutor);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiAnnotationOwner annotationOwner, @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "findAnnotation"));
        }
        if (annotationOwner == null) {
            return null;
        }
        PsiAnnotation[] annotations = annotationOwner.getAnnotations();
        if (annotations.length == 0) {
            return null;
        }
        String shortName = StringUtil.getShortName(qualifiedName);
        for (PsiAnnotation annotation : annotations) {
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (referenceElement == null || !shortName.equals(referenceElement.getReferenceName()) || !qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation.TargetType findApplicableTarget(@NotNull PsiAnnotation annotation, PsiAnnotation.TargetType ... types) {
        PsiElement annotationType;
        PsiJavaCodeReferenceElement ref;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "findApplicableTarget"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "findApplicableTarget"));
        }
        if (types.length != 0 && (ref = annotation.getNameReferenceElement()) != null && (annotationType = ref.resolve()) instanceof PsiClass) {
            return PsiImplUtil.findApplicableTarget((PsiClass)annotationType, types);
        }
        return PsiAnnotation.TargetType.UNKNOWN;
    }

    @Nullable
    public static PsiAnnotation.TargetType findApplicableTarget(@NotNull PsiClass annotationType, PsiAnnotation.TargetType ... types) {
        Set<PsiAnnotation.TargetType> targets;
        if (annotationType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "findApplicableTarget"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "findApplicableTarget"));
        }
        if (types.length != 0 && (targets = PsiImplUtil.getAnnotationTargets(annotationType)) != null) {
            for (PsiAnnotation.TargetType type : types) {
                if (type == PsiAnnotation.TargetType.UNKNOWN || !targets.contains((Object)type)) continue;
                return type;
            }
            return null;
        }
        return PsiAnnotation.TargetType.UNKNOWN;
    }

    @Nullable
    public static Set<PsiAnnotation.TargetType> getAnnotationTargets(@NotNull PsiClass annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "getAnnotationTargets"));
        }
        if (!annotationType.isAnnotationType()) {
            return null;
        }
        PsiModifierList modifierList = annotationType.getModifierList();
        if (modifierList == null) {
            return null;
        }
        PsiAnnotation target = modifierList.findAnnotation("java.lang.annotation.Target");
        if (target == null) {
            return DEFAULT_TARGETS;
        }
        PsiAnnotationMemberValue value = target.findAttributeValue(null);
        if (value instanceof PsiReference) {
            PsiAnnotation.TargetType targetType = PsiImplUtil.translateTargetRef((PsiReference)((Object)value));
            if (targetType != null) {
                return Collections.singleton(targetType);
            }
        } else if (value instanceof PsiArrayInitializerMemberValue) {
            HashSet<PsiAnnotation.TargetType> targets = ContainerUtil.newHashSet();
            for (PsiAnnotationMemberValue initializer : ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                PsiAnnotation.TargetType targetType;
                if (!(initializer instanceof PsiReference) || (targetType = PsiImplUtil.translateTargetRef((PsiReference)((Object)initializer))) == null) continue;
                targets.add(targetType);
            }
            return targets;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation.TargetType translateTargetRef(PsiReference reference) {
        PsiElement field = reference.resolve();
        if (field instanceof PsiEnumConstant) {
            String name = ((PsiEnumConstant)field).getName();
            try {
                return PsiAnnotation.TargetType.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unknown target: " + name);
            }
        }
        return null;
    }

    @NotNull
    public static PsiAnnotation.TargetType[] getTargetsForLocation(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
            }
            return PsiAnnotation.TargetType.EMPTY_ARRAY;
        }
        if (owner instanceof PsiType || owner instanceof PsiTypeElement) {
            if (TYPE_USE_TARGETS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
            }
            return TYPE_USE_TARGETS;
        }
        if (owner instanceof PsiTypeParameter) {
            if (TYPE_PARAMETER_TARGETS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
            }
            return TYPE_PARAMETER_TARGETS;
        }
        if (owner instanceof PsiModifierList) {
            PsiElement element = ((PsiModifierList)owner).getParent();
            if (element instanceof PsiPackageStatement) {
                if (PACKAGE_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
                }
                return PACKAGE_TARGETS;
            }
            if (element instanceof PsiClass) {
                if (((PsiClass)element).isAnnotationType()) {
                    if (ANNOTATION_TARGETS == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
                    }
                    return ANNOTATION_TARGETS;
                }
                if (TYPE_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
                }
                return TYPE_TARGETS;
            }
            if (element instanceof PsiMethod) {
                if (((PsiMethod)element).isConstructor()) {
                    if (CONSTRUCTOR_TARGETS == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
                    }
                    return CONSTRUCTOR_TARGETS;
                }
                if (METHOD_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
                }
                return METHOD_TARGETS;
            }
            if (element instanceof PsiField) {
                if (FIELD_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
                }
                return FIELD_TARGETS;
            }
            if (element instanceof PsiParameter) {
                if (PARAMETER_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
                }
                return PARAMETER_TARGETS;
            }
            if (element instanceof PsiLocalVariable) {
                if (LOCAL_VARIABLE_TARGETS == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
                }
                return LOCAL_VARIABLE_TARGETS;
            }
        }
        if (PsiAnnotation.TargetType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getTargetsForLocation"));
        }
        return PsiAnnotation.TargetType.EMPTY_ARRAY;
    }

    @Nullable
    public static ASTNode findDocComment(@NotNull CompositeElement element) {
        TreeElement node;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "findDocComment"));
        }
        for (node = element.getFirstChildNode(); node != null && PsiImplUtil.isWhitespaceOrComment(node) && !(node.getPsi() instanceof PsiDocComment); node = node.getTreeNext()) {
        }
        if (node != null && node.getElementType() == JavaDocElementType.DOC_COMMENT) {
            return node;
        }
        return null;
    }

    public static PsiType normalizeWildcardTypeByPosition(@NotNull PsiType type, @NotNull PsiExpression expression) {
        PsiExpression toplevel;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "normalizeWildcardTypeByPosition"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "normalizeWildcardTypeByPosition"));
        }
        LOG.assertTrue(expression.isValid());
        LOG.assertTrue(type.isValid());
        for (toplevel = expression; toplevel.getParent() instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)toplevel.getParent()).getArrayExpression() == toplevel; toplevel = (PsiExpression)toplevel.getParent()) {
        }
        if (toplevel instanceof PsiArrayAccessExpression && !PsiUtil.isAccessedForWriting(toplevel)) {
            return PsiUtil.captureToplevelWildcards(type, expression);
        }
        PsiElement parent = toplevel.getParent();
        if (parent instanceof PsiExpressionList && PsiUtil.isLanguageLevel8OrHigher(parent) && parent.getParent() instanceof PsiCallExpression) {
            return PsiUtil.captureToplevelWildcards(type, expression);
        }
        PsiType normalized = PsiImplUtil.doNormalizeWildcardByPosition(type, expression, toplevel);
        LOG.assertTrue(normalized.isValid(), type);
        if (normalized instanceof PsiClassType && !PsiUtil.isAccessedForWriting(toplevel)) {
            return PsiUtil.captureToplevelWildcards(normalized, expression);
        }
        return normalized;
    }

    private static PsiType doNormalizeWildcardByPosition(PsiType type, @NotNull PsiExpression expression, PsiExpression toplevel) {
        PsiType componentType;
        PsiType normalizedComponentType;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "doNormalizeWildcardByPosition"));
        }
        if (type instanceof PsiCapturedWildcardType) {
            return PsiImplUtil.doNormalizeWildcardByPosition(((PsiCapturedWildcardType)type).getWildcard(), expression, toplevel);
        }
        if (type instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            if (PsiUtil.isAccessedForWriting(toplevel)) {
                return wildcardType.isSuper() ? wildcardType.getBound() : PsiCapturedWildcardType.create(wildcardType, expression);
            }
            if (wildcardType.isExtends()) {
                return wildcardType.getBound();
            }
            return PsiType.getJavaLangObject(expression.getManager(), expression.getResolveScope());
        }
        if (type instanceof PsiArrayType && (normalizedComponentType = PsiImplUtil.doNormalizeWildcardByPosition(componentType = ((PsiArrayType)type).getComponentType(), expression, toplevel)) != componentType) {
            return normalizedComponentType.createArrayType();
        }
        return type;
    }

    @NotNull
    public static SearchScope getMemberUseScope(@NotNull PsiMember member) {
        PsiPackage aPackage;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "getMemberUseScope"));
        }
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getElementUseScope(member);
        PsiFile file = member.getContainingFile();
        if (PsiImplUtil.isInServerPage(file)) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getMemberUseScope"));
            }
            return globalSearchScope;
        }
        PsiClass aClass = member.getContainingClass();
        if (aClass instanceof PsiAnonymousClass) {
            PsiMethodCallExpression methodCallExpr = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMethodCallExpression.class);
            LocalSearchScope localSearchScope = new LocalSearchScope(methodCallExpr != null ? methodCallExpr : aClass);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getMemberUseScope"));
            }
            return localSearchScope;
        }
        if (member.hasModifierProperty("public")) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getMemberUseScope"));
            }
            return globalSearchScope;
        }
        if (member.hasModifierProperty("protected")) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getMemberUseScope"));
            }
            return globalSearchScope;
        }
        if (member.hasModifierProperty("private")) {
            PsiClass topClass = PsiUtil.getTopLevelClass(member);
            SearchScope searchScope = topClass != null ? new LocalSearchScope(topClass) : (file != null ? new LocalSearchScope(file) : maximalUseScope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getMemberUseScope"));
            }
            return searchScope;
        }
        if (file instanceof PsiJavaFile && (aPackage = JavaPsiFacade.getInstance(member.getProject()).findPackage(((PsiJavaFile)file).getPackageName())) != null) {
            SearchScope scope = PackageScope.packageScope(aPackage, false);
            SearchScope searchScope = scope = ((SearchScope)scope).intersectWith(maximalUseScope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getMemberUseScope"));
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = maximalUseScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiImplUtil", "getMemberUseScope"));
        }
        return globalSearchScope;
    }

    public static boolean isInServerPage(@Nullable PsiElement element) {
        return PsiImplUtil.getServerPageFile(element) != null;
    }

    @Nullable
    public static ServerPageFile getServerPageFile(PsiElement element) {
        PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile(element);
        return psiFile instanceof ServerPageFile ? (ServerPageFile)psiFile : null;
    }

    public static PsiElement setName(@NotNull PsiElement element, @NotNull String name) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "setName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "setName"));
        }
        PsiManager manager = element.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        PsiIdentifier newNameIdentifier = factory.createIdentifier(name);
        return element.replace(newNameIdentifier);
    }

    public static boolean isDeprecatedByAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "isDeprecatedByAnnotation"));
        }
        PsiModifierList modifierList = owner.getModifierList();
        return modifierList != null && modifierList.findAnnotation("java.lang.Deprecated") != null;
    }

    public static boolean isDeprecatedByDocTag(@NotNull PsiDocCommentOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "isDeprecatedByDocTag"));
        }
        PsiDocComment docComment = owner.getDocComment();
        return docComment != null && docComment.findTagByName("deprecated") != null;
    }

    @Nullable
    public static PsiAnnotationMemberValue setDeclaredAttributeValue(@NotNull PsiAnnotation psiAnnotation, @Nullable String attributeName, @Nullable PsiAnnotationMemberValue value, @NotNull PairFunction<Project, String, PsiAnnotation> annotationCreator) {
        if (psiAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "setDeclaredAttributeValue"));
        }
        if (annotationCreator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/PsiImplUtil", "setDeclaredAttributeValue"));
        }
        PsiAnnotationMemberValue existing = psiAnnotation.findDeclaredAttributeValue(attributeName);
        if (value == null) {
            if (existing == null) {
                return null;
            }
            existing.getParent().delete();
        } else if (existing != null) {
            ((PsiNameValuePair)existing.getParent()).setValue(value);
        } else {
            PsiNameValuePair[] attributes = psiAnnotation.getParameterList().getAttributes();
            if (attributes.length == 1 && attributes[0].getName() == null) {
                attributes[0].replace(PsiImplUtil.createNameValuePair(attributes[0].getValue(), "value=", annotationCreator));
            }
            boolean allowNoName = attributes.length == 0 && ("value".equals(attributeName) || null == attributeName);
            String namePrefix = allowNoName ? "" : attributeName + "=";
            psiAnnotation.getParameterList().addBefore(PsiImplUtil.createNameValuePair(value, namePrefix, annotationCreator), null);
        }
        return psiAnnotation.findDeclaredAttributeValue(attributeName);
    }

    private static PsiNameValuePair createNameValuePair(@NotNull PsiAnnotationMemberValue value, @NotNull String namePrefix, @NotNull PairFunction<Project, String, PsiAnnotation> annotationCreator) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "createNameValuePair"));
        }
        if (namePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiImplUtil", "createNameValuePair"));
        }
        if (annotationCreator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/PsiImplUtil", "createNameValuePair"));
        }
        return annotationCreator.fun(value.getProject(), "@A(" + namePrefix + value.getText() + ")").getParameterList().getAttributes()[0];
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(ASTNode node) {
        return PsiImplUtil.skipWhitespaceCommentsAndTokens(node, TokenSet.EMPTY);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(ASTNode node, TokenSet alsoSkip) {
        ASTNode element = node;
        while (true) {
            if (element == null) {
                return null;
            }
            if (!PsiImplUtil.isWhitespaceOrComment(element) && !alsoSkip.contains(element.getElementType())) break;
            element = element.getTreeNext();
        }
        return element;
    }

    public static boolean isWhitespaceOrComment(ASTNode element) {
        return element.getPsi() instanceof PsiWhiteSpace || element.getPsi() instanceof PsiComment;
    }

    @Nullable
    public static ASTNode skipWhitespaceAndCommentsBack(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (!PsiImplUtil.isWhitespaceOrComment(node)) {
            return node;
        }
        ASTNode parent = node.getTreeParent();
        ASTNode prev = node;
        while (prev instanceof CompositeElement) {
            if (!PsiImplUtil.isWhitespaceOrComment(prev)) {
                return prev;
            }
            prev = prev.getTreePrev();
        }
        if (prev == null) {
            return null;
        }
        ASTNode lastRelevant = null;
        for (ASTNode firstChildNode = parent.getFirstChildNode(); firstChildNode != prev; firstChildNode = firstChildNode.getTreeNext()) {
            if (PsiImplUtil.isWhitespaceOrComment(firstChildNode)) continue;
            lastRelevant = firstChildNode;
        }
        return lastRelevant;
    }

    @Nullable
    public static ASTNode findStatementChild(CompositePsiElement statement) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = statement.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!(element.getPsi() instanceof PsiStatement)) continue;
            return element;
        }
        return null;
    }

    public static PsiStatement[] getChildStatements(CompositeElement psiCodeBlock) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = 0;
        for (ASTNode child1 = psiCodeBlock.getFirstChildNode(); child1 != null; child1 = child1.getTreeNext()) {
            if (!(child1.getPsi() instanceof PsiStatement)) continue;
            ++count;
        }
        PsiStatement[] result = PsiStatement.ARRAY_FACTORY.create(count);
        if (count == 0) {
            return result;
        }
        int idx = 0;
        for (ASTNode child = psiCodeBlock.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            PsiStatement element = (PsiStatement)child.getPsi();
            LOG.assertTrue(element != null, child);
            result[idx++] = element;
        }
        return result;
    }

    public static boolean isVarArgs(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "isVarArgs"));
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        return parameters.length > 0 && parameters[parameters.length - 1].isVarArgs();
    }

    public static PsiElement handleMirror(PsiElement element) {
        return element instanceof PsiMirrorElement ? ((PsiMirrorElement)element).getPrototype() : element;
    }

    @Nullable
    public static PsiModifierList findNeighbourModifierList(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement grandParent;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "findNeighbourModifierList"));
        }
        PsiElement parent = PsiTreeUtil.skipParentsOfType(ref, PsiJavaCodeReferenceElement.class);
        if (parent instanceof PsiTypeElement && (grandParent = parent.getParent()) instanceof PsiModifierListOwner) {
            return ((PsiModifierListOwner)grandParent).getModifierList();
        }
        return null;
    }

    @Nullable
    public static List<PsiAnnotation> getTypeUseAnnotations(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiImplUtil", "getTypeUseAnnotations"));
        }
        SmartList<PsiAnnotation> result = null;
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            if (PsiImplUtil.findApplicableTarget(annotation, PsiAnnotation.TargetType.TYPE_USE) != PsiAnnotation.TargetType.TYPE_USE) continue;
            if (result == null) {
                result = new SmartList<PsiAnnotation>();
            }
            result.add(annotation);
        }
        return result;
    }

    public static boolean isLeafElementOfType(@Nullable PsiElement element, IElementType type) {
        return element instanceof LeafElement && ((LeafElement)((Object)element)).getElementType() == type;
    }

    public static boolean isLeafElementOfType(PsiElement element, TokenSet tokenSet) {
        return element instanceof LeafElement && tokenSet.contains(((LeafElement)((Object)element)).getElementType());
    }
}

