/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildNumber
implements Comparable<BuildNumber> {
    private static final int TOP_BASELINE_VERSION = BuildNumber.fromFile().getBaselineVersion();
    private final String myProductCode;
    private final int myBaselineVersion;
    private final int myBuildNumber;

    public BuildNumber(String productCode, int baselineVersion, int buildNumber) {
        this.myProductCode = productCode;
        this.myBaselineVersion = baselineVersion;
        this.myBuildNumber = buildNumber;
    }

    public String asString() {
        return this.asString(true);
    }

    private String asString(boolean includeProductCode) {
        StringBuilder builder = new StringBuilder();
        if (includeProductCode && !StringUtil.isEmpty(this.myProductCode)) {
            builder.append(this.myProductCode).append('-');
        }
        builder.append(this.myBaselineVersion).append('.');
        if (this.myBuildNumber != Integer.MAX_VALUE) {
            builder.append(this.myBuildNumber);
        } else {
            builder.append("SNAPSHOT");
        }
        return builder.toString();
    }

    public static BuildNumber fromString(String version) {
        return BuildNumber.fromString(version, null);
    }

    public static BuildNumber fromString(String version, @Nullable String name) {
        int buildNumber;
        int baselineVersion;
        String productCode;
        if (version == null) {
            return null;
        }
        if ("__BUILD_NUMBER__".equals(version)) {
            String productCode2 = name != null ? name : "";
            return new BuildNumber(productCode2, TOP_BASELINE_VERSION, Integer.MAX_VALUE);
        }
        String code = version;
        int productSeparator = code.indexOf(45);
        if (productSeparator > 0) {
            productCode = code.substring(0, productSeparator);
            code = code.substring(productSeparator + 1);
        } else {
            productCode = "";
        }
        int baselineVersionSeparator = code.indexOf(46);
        if (baselineVersionSeparator > 0) {
            try {
                String baselineVersionString = code.substring(0, baselineVersionSeparator);
                if (baselineVersionString.trim().isEmpty()) {
                    return null;
                }
                baselineVersion = Integer.parseInt(baselineVersionString);
                code = code.substring(baselineVersionSeparator + 1);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid version number: " + version + "; plugin name: " + name);
            }
            buildNumber = BuildNumber.parseBuildNumber(version, code, name);
        } else {
            buildNumber = BuildNumber.parseBuildNumber(version, code, name);
            if (buildNumber <= 2000) {
                return new BuildNumber(productCode, buildNumber, 0);
            }
            baselineVersion = BuildNumber.getBaseLineForHistoricBuilds(buildNumber);
        }
        return new BuildNumber(productCode, baselineVersion, buildNumber);
    }

    private static int parseBuildNumber(String version, String code, String name) {
        if ("SNAPSHOT".equals(code) || "*".equals(code) || "__BUILD_NUMBER__".equals(code)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid version number: " + version + "; plugin name: " + name);
        }
    }

    private static BuildNumber fromFile() {
        try {
            String homePath = PathManager.getHomePath();
            File buildTxtFile = FileUtil.findFirstThatExist(homePath + "/build.txt", homePath + "/community/build.txt");
            if (buildTxtFile != null) {
                String text = FileUtil.loadFile(buildTxtFile).trim();
                return BuildNumber.fromString(text);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return BuildNumber.fallback();
    }

    public static BuildNumber fallback() {
        return BuildNumber.fromString("999.SNAPSHOT");
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public int compareTo(@NotNull BuildNumber o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/BuildNumber", "compareTo"));
        }
        if (this.myBaselineVersion == o.myBaselineVersion) {
            return this.myBuildNumber - o.myBuildNumber;
        }
        return this.myBaselineVersion - o.myBaselineVersion;
    }

    public int getBaselineVersion() {
        return this.myBaselineVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildNumber that = (BuildNumber)o;
        if (this.myBaselineVersion != that.myBaselineVersion) {
            return false;
        }
        if (this.myBuildNumber != that.myBuildNumber) {
            return false;
        }
        return this.myProductCode.equals(that.myProductCode);
    }

    public int hashCode() {
        int result = this.myProductCode.hashCode();
        result = 31 * result + this.myBaselineVersion;
        result = 31 * result + this.myBuildNumber;
        return result;
    }

    private static int getBaseLineForHistoricBuilds(int bn) {
        if (bn == Integer.MAX_VALUE) {
            return TOP_BASELINE_VERSION;
        }
        if (bn >= 10000) {
            return 88;
        }
        if (bn >= 9500) {
            return 85;
        }
        if (bn >= 9100) {
            return 81;
        }
        if (bn >= 8000) {
            return 80;
        }
        if (bn >= 7500) {
            return 75;
        }
        if (bn >= 7200) {
            return 72;
        }
        if (bn >= 6900) {
            return 69;
        }
        if (bn >= 6500) {
            return 65;
        }
        if (bn >= 6000) {
            return 60;
        }
        if (bn >= 5000) {
            return 55;
        }
        if (bn >= 4000) {
            return 50;
        }
        return 40;
    }

    public boolean isSnapshot() {
        return this.myBuildNumber == Integer.MAX_VALUE;
    }
}

