/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.SortingException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingOrder {
    public static final LoadingOrder ANY = new LoadingOrder();
    public static final LoadingOrder FIRST = new LoadingOrder("FIRST");
    public static final LoadingOrder LAST = new LoadingOrder("LAST");
    @NonNls
    private final String myName;
    private final boolean myFirst;
    private final boolean myLast;
    private final Set<String> myBefore;
    private final Set<String> myAfter;

    private LoadingOrder() {
        this.myBefore = new HashSet<String>(2);
        this.myAfter = new HashSet<String>(2);
        this.myName = "ANY";
        this.myFirst = false;
        this.myLast = false;
    }

    private LoadingOrder(@NonNls @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/extensions/LoadingOrder", "<init>"));
        }
        this.myBefore = new HashSet<String>(2);
        this.myAfter = new HashSet<String>(2);
        this.myName = text;
        boolean last = false;
        boolean first = false;
        for (String string : StringUtil.split(text, ",")) {
            String trimmed = string.trim();
            if (trimmed.equalsIgnoreCase("FIRST")) {
                first = true;
                continue;
            }
            if (trimmed.equalsIgnoreCase("LAST")) {
                last = true;
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "BEFORE ")) {
                this.myBefore.add(trimmed.substring("BEFORE ".length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "BEFORE:")) {
                this.myBefore.add(trimmed.substring("BEFORE:".length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "AFTER ")) {
                this.myAfter.add(trimmed.substring("AFTER ".length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, "AFTER:")) {
                this.myAfter.add(trimmed.substring("AFTER:".length()).trim());
                continue;
            }
            throw new AssertionError((Object)("Invalid specification: " + trimmed + "; should be one of FIRST, LAST, BEFORE <id> or AFTER <id>"));
        }
        this.myFirst = first;
        this.myLast = last;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadingOrder)) {
            return false;
        }
        LoadingOrder that = (LoadingOrder)o;
        if (this.myFirst != that.myFirst) {
            return false;
        }
        if (this.myLast != that.myLast) {
            return false;
        }
        if (!((Object)this.myAfter).equals(that.myAfter)) {
            return false;
        }
        return ((Object)this.myBefore).equals(that.myBefore);
    }

    public int hashCode() {
        int result = this.myFirst ? 1 : 0;
        result = 31 * result + (this.myLast ? 1 : 0);
        result = 31 * result + ((Object)this.myBefore).hashCode();
        result = 31 * result + ((Object)this.myAfter).hashCode();
        return result;
    }

    public static void sort(final @NotNull List<? extends Orderable> orderable) {
        if (orderable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/extensions/LoadingOrder", "sort"));
        }
        final HashMap<String, Orderable> map = ContainerUtil.newHashMap();
        final HashMap<Orderable, LoadingOrder> cachedMap = ContainerUtil.newHashMap();
        final HashSet first = ContainerUtil.newHashSet(1);
        final HashSet hasBefore = ContainerUtil.newHashSet(orderable.size());
        for (Orderable orderable2 : orderable) {
            String id = orderable2.getOrderId();
            if (StringUtil.isNotEmpty(id)) {
                map.put(id, orderable2);
            }
            LoadingOrder order = orderable2.getOrder();
            cachedMap.put(orderable2, order);
            if (order.myFirst) {
                first.add(orderable2);
            }
            if (order.myBefore.size() == 0) continue;
            hasBefore.add(orderable2);
        }
        GraphGenerator.SemiGraph<Orderable> graph = new GraphGenerator.SemiGraph<Orderable>(){

            @Override
            public Collection<Orderable> getNodes() {
                ArrayList<Orderable> list = ContainerUtil.newArrayList(orderable);
                Collections.reverse(list);
                return list;
            }

            @Override
            public Iterator<Orderable> getIn(Orderable n) {
                LoadingOrder hisOrder;
                LoadingOrder order = (LoadingOrder)cachedMap.get(n);
                LinkedHashSet<Orderable> predecessors = new LinkedHashSet<Orderable>();
                for (String id : order.myAfter) {
                    Orderable o = (Orderable)map.get(id);
                    if (o == null) continue;
                    predecessors.add(o);
                }
                String id = n.getOrderId();
                if (StringUtil.isNotEmpty(id)) {
                    for (Orderable o : hasBefore) {
                        hisOrder = (LoadingOrder)cachedMap.get(o);
                        if (!hisOrder.myBefore.contains(id)) continue;
                        predecessors.add(o);
                    }
                }
                if (order.myLast) {
                    for (Orderable o : orderable) {
                        hisOrder = (LoadingOrder)cachedMap.get(o);
                        if (hisOrder.myLast) continue;
                        predecessors.add(o);
                    }
                }
                if (!order.myFirst) {
                    predecessors.addAll(first);
                }
                return predecessors.iterator();
            }
        };
        DFSTBuilder<Orderable> dFSTBuilder = new DFSTBuilder<Orderable>(new GraphGenerator<Orderable>(new CachingSemiGraph<Orderable>(graph)));
        if (!dFSTBuilder.isAcyclic()) {
            Pair<Orderable, Orderable> p = dFSTBuilder.getCircularDependency();
            throw new SortingException("Could not satisfy sorting requirements", ((Orderable)p.first).getDescribingElement(), ((Orderable)p.second).getDescribingElement());
        }
        Collections.sort(orderable, dFSTBuilder.comparator());
    }

    public static LoadingOrder readOrder(@NonNls String orderAttr) {
        return orderAttr != null ? new LoadingOrder(orderAttr) : ANY;
    }

    public static interface Orderable {
        @Nullable
        public String getOrderId();

        public LoadingOrder getOrder();

        public Element getDescribingElement();
    }
}

