/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.HelpSetPath;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginBean;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginHelpSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.plugins.PluginDescriptor");
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    private String myName;
    private PluginId myId;
    private final NullableLazyValue<String> myDescription;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myVendorLogoPath;
    private String myCategory;
    private String url;
    private File myPath;
    private PluginId[] myDependencies;
    private PluginId[] myOptionalDependencies;
    private Map<PluginId, String> myOptionalConfigs;
    private Map<PluginId, IdeaPluginDescriptorImpl> myOptionalDescriptors;
    @Nullable
    private List<Element> myActionsElements;
    private ComponentConfig[] myAppComponents;
    private ComponentConfig[] myProjectComponents;
    private ComponentConfig[] myModuleComponents;
    private boolean myDeleted;
    private ClassLoader myLoader;
    private HelpSetPath[] myHelpSets;
    @Nullable
    private MultiMap<String, Element> myExtensions;
    @Nullable
    private MultiMap<String, Element> myExtensionsPoints;
    private String myDescriptionChildText;
    private boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    private boolean myEnabled;
    private String mySinceBuild;
    private String myUntilBuild;
    private List<String> myModules;
    private static final StringInterner ourInterner = new StringInterner();

    public IdeaPluginDescriptorImpl(@NotNull File pluginPath) {
        if (pluginPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "<init>"));
        }
        this.myDescription = new NullableLazyValue<String>(){

            @Override
            protected String compute() {
                return IdeaPluginDescriptorImpl.this.computeDescription();
            }
        };
        this.myDependencies = PluginId.EMPTY_ARRAY;
        this.myOptionalDependencies = PluginId.EMPTY_ARRAY;
        this.myAppComponents = null;
        this.myProjectComponents = null;
        this.myModuleComponents = null;
        this.myDeleted = false;
        this.myEnabled = true;
        this.myModules = null;
        this.myPath = pluginPath;
    }

    IdeaPluginDescriptorImpl() {
        this.myDescription = new /* invalid duplicate definition of identical inner class */;
        this.myDependencies = PluginId.EMPTY_ARRAY;
        this.myOptionalDependencies = PluginId.EMPTY_ARRAY;
        this.myAppComponents = null;
        this.myProjectComponents = null;
        this.myModuleComponents = null;
        this.myDeleted = false;
        this.myEnabled = true;
        this.myModules = null;
    }

    public void setPath(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "setPath"));
        }
        this.myPath = path;
    }

    @Override
    public File getPath() {
        return this.myPath;
    }

    public static void internJDOMElement(@NotNull Element rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "internJDOMElement"));
        }
        JDOMUtil.internElement(rootElement, ourInterner);
    }

    public void readExternal(@NotNull Document document, @NotNull URL url) throws InvalidDataException, FileNotFoundException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        document = JDOMXIncluder.resolve(document, url.toExternalForm());
        Element rootElement = document.getRootElement();
        IdeaPluginDescriptorImpl.internJDOMElement(rootElement);
        this.readExternal(document.getRootElement());
    }

    public void readExternal(@NotNull URL url) throws InvalidDataException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        try {
            Document document = JDOMUtil.loadDocument(url);
            this.readExternal(document, url);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
        catch (JDOMException e) {
            throw new InvalidDataException(e);
        }
    }

    private void readExternal(@NotNull Element element) {
        List<Element> extensionPoints;
        List<Element> extensions;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "readExternal"));
        }
        PluginBean pluginBean = XmlSerializer.deserialize(element, PluginBean.class);
        this.url = pluginBean.url;
        this.myName = pluginBean.name;
        String idString = pluginBean.id;
        if (idString == null || idString.isEmpty()) {
            idString = this.myName;
        }
        this.myId = PluginId.getId(idString);
        String internalVersionString = pluginBean.formatVersion;
        if (internalVersionString != null) {
            try {
                Integer.parseInt(internalVersionString);
            }
            catch (NumberFormatException e) {
                LOG.error(new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", e, this.myId));
            }
        }
        this.myUseIdeaClassLoader = pluginBean.useIdeaClassLoader;
        if (pluginBean.ideaVersion != null) {
            this.mySinceBuild = pluginBean.ideaVersion.sinceBuild;
            this.myUntilBuild = pluginBean.ideaVersion.untilBuild;
        }
        this.myResourceBundleBaseName = pluginBean.resourceBundle;
        this.myDescriptionChildText = pluginBean.description;
        this.myChangeNotes = pluginBean.changeNotes;
        this.myVersion = pluginBean.pluginVersion;
        this.myCategory = pluginBean.category;
        if (pluginBean.vendor != null) {
            this.myVendor = pluginBean.vendor.name;
            this.myVendorEmail = pluginBean.vendor.email;
            this.myVendorUrl = pluginBean.vendor.url;
            this.myVendorLogoPath = pluginBean.vendor.logo;
        }
        LinkedHashSet<PluginId> dependentPlugins = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> optionalDependentPlugins = new LinkedHashSet<PluginId>();
        this.myOptionalConfigs = new HashMap<PluginId, String>();
        if (pluginBean.dependencies != null) {
            for (PluginDependency dependency : pluginBean.dependencies) {
                String text = dependency.pluginId;
                if (text == null || text.isEmpty()) continue;
                PluginId id = PluginId.getId(text);
                dependentPlugins.add(id);
                if (!dependency.optional) continue;
                optionalDependentPlugins.add(id);
                if (dependency.configFile == null || dependency.configFile.isEmpty()) continue;
                this.myOptionalConfigs.put(id, dependency.configFile);
            }
        }
        this.myDependencies = dependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : dependentPlugins.toArray(new PluginId[dependentPlugins.size()]);
        this.myOptionalDependencies = optionalDependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : optionalDependentPlugins.toArray(new PluginId[optionalDependentPlugins.size()]);
        ArrayList<HelpSetPath> hsPaths = new ArrayList<HelpSetPath>();
        if (pluginBean.helpSets != null) {
            for (PluginHelpSet pluginHelpSet : pluginBean.helpSets) {
                HelpSetPath hsPath = new HelpSetPath(pluginHelpSet.file, pluginHelpSet.path);
                hsPaths.add(hsPath);
            }
        }
        this.myHelpSets = hsPaths.isEmpty() ? HelpSetPath.EMPTY : hsPaths.toArray(new HelpSetPath[hsPaths.size()]);
        this.myAppComponents = pluginBean.applicationComponents;
        this.myProjectComponents = pluginBean.projectComponents;
        this.myModuleComponents = pluginBean.moduleComponents;
        if (this.myAppComponents == null) {
            this.myAppComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myProjectComponents == null) {
            this.myProjectComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myModuleComponents == null) {
            this.myModuleComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if ((extensions = IdeaPluginDescriptorImpl.copyElements(pluginBean.extensions)) != null) {
            this.myExtensions = new MultiMap();
            for (Element extension : extensions) {
                this.myExtensions.putValue(ExtensionsAreaImpl.extractEPName(extension), extension);
            }
        }
        if ((extensionPoints = IdeaPluginDescriptorImpl.copyElements(pluginBean.extensionPoints)) != null) {
            this.myExtensionsPoints = new MultiMap();
            for (Element extensionPoint : extensionPoints) {
                this.myExtensionsPoints.putValue(extensionPoint.getAttributeValue("area"), extensionPoint);
            }
        }
        this.myActionsElements = IdeaPluginDescriptorImpl.copyElements(pluginBean.actions);
        if (pluginBean.modules != null && !pluginBean.modules.isEmpty()) {
            this.myModules = pluginBean.modules;
        }
    }

    @Nullable
    private static List<Element> copyElements(Element[] elements) {
        if (elements != null) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element extensionsRoot : elements) {
                Iterator<Element> i$ = extensionsRoot.getChildren().iterator();
                while (i$.hasNext()) {
                    Element o;
                    Element element = o = i$.next();
                    IdeaPluginDescriptorImpl.internJDOMElement(element);
                    result.add(element);
                }
            }
            return result;
        }
        return null;
    }

    private static String createDescriptionKey(PluginId id) {
        return "plugin." + id + ".description";
    }

    void registerExtensionPoints(ExtensionsArea area) {
        if (this.myExtensionsPoints != null) {
            for (Element element : this.myExtensionsPoints.get(area.getAreaClass())) {
                area.registerExtensionPoint(this, element);
            }
        }
    }

    void registerExtensions(ExtensionsArea area, String epName) {
        if (this.myExtensions != null) {
            for (Element element : this.myExtensions.get(epName)) {
                area.registerExtension(this, element);
            }
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public PluginId[] getDependentPluginIds() {
        if (this.myDependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getDependentPluginIds"));
        }
        return this.myDependencies;
    }

    @Override
    @NotNull
    public PluginId[] getOptionalDependentPluginIds() {
        if (this.myOptionalDependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getOptionalDependentPluginIds"));
        }
        return this.myOptionalDependencies;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public String getCategory() {
        return this.myCategory;
    }

    @NotNull
    public List<File> getClassPath() {
        if (this.myPath.isDirectory()) {
            File[] files;
            ArrayList<File> result = new ArrayList<File>();
            File classesDir = new File(this.myPath, "classes");
            if (classesDir.exists()) {
                result.add(classesDir);
            }
            if ((files = new File(this.myPath, "lib").listFiles()) != null && files.length > 0) {
                for (File f : files) {
                    if (f.isFile()) {
                        String name = f.getName();
                        if (!StringUtil.endsWithIgnoreCase(name, ".jar") && !StringUtil.endsWithIgnoreCase(name, ".zip")) continue;
                        result.add(f);
                        continue;
                    }
                    result.add(f);
                }
            }
            ArrayList<File> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getClassPath"));
            }
            return arrayList;
        }
        List<File> list = Collections.singletonList(this.myPath);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/IdeaPluginDescriptorImpl", "getClassPath"));
        }
        return list;
    }

    @NonNls
    public String toString() {
        return "PluginDescriptor[name='" + this.myName + "', classpath='" + this.myPath + "']";
    }

    public void setLoader(ClassLoader loader) {
        this.myLoader = loader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeaPluginDescriptorImpl)) {
            return false;
        }
        IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)o;
        return this.myName == null ? pluginDescriptor.myName == null : this.myName.equals(pluginDescriptor.myName);
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    @Override
    public PluginId getPluginId() {
        return this.myId;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    @Override
    public boolean getUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    public boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    public void setUseCoreClassLoader(boolean useCoreClassLoader) {
        this.myUseCoreClassLoader = useCoreClassLoader;
    }

    private String computeDescription() {
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = AbstractBundle.getResourceBundle(this.myResourceBundleBaseName, this.getPluginClassLoader());
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        if (bundle == null) {
            return this.myDescriptionChildText;
        }
        return CommonBundle.messageOrDefault(bundle, IdeaPluginDescriptorImpl.createDescriptionKey(this.myId), this.myDescriptionChildText == null ? "" : this.myDescriptionChildText, new Object[0]);
    }

    public void insertDependency(IdeaPluginDescriptor d) {
        PluginId[] deps = new PluginId[this.getDependentPluginIds().length + 1];
        deps[0] = d.getPluginId();
        System.arraycopy(this.myDependencies, 0, deps, 1, deps.length - 1);
        this.myDependencies = deps;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    @Override
    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    Map<PluginId, String> getOptionalConfigs() {
        return this.myOptionalConfigs;
    }

    Map<PluginId, IdeaPluginDescriptorImpl> getOptionalDescriptors() {
        return this.myOptionalDescriptors;
    }

    void setOptionalDescriptors(Map<PluginId, IdeaPluginDescriptorImpl> optionalDescriptors) {
        this.myOptionalDescriptors = optionalDescriptors;
    }

    void mergeOptionalConfig(IdeaPluginDescriptorImpl descriptor) {
        if (this.myExtensions == null) {
            this.myExtensions = descriptor.myExtensions;
        } else if (descriptor.myExtensions != null) {
            this.myExtensions.putAllValues(descriptor.myExtensions);
        }
        if (this.myExtensionsPoints == null) {
            this.myExtensionsPoints = descriptor.myExtensionsPoints;
        } else if (descriptor.myExtensionsPoints != null) {
            this.myExtensionsPoints.putAllValues(descriptor.myExtensionsPoints);
        }
        if (this.myActionsElements == null) {
            this.myActionsElements = descriptor.myActionsElements;
        } else if (descriptor.myActionsElements != null) {
            this.myActionsElements.addAll(descriptor.myActionsElements);
        }
        this.myAppComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myAppComponents, descriptor.myAppComponents);
        this.myProjectComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myProjectComponents, descriptor.myProjectComponents);
        this.myModuleComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myModuleComponents, descriptor.myModuleComponents);
    }

    private static ComponentConfig[] mergeComponents(ComponentConfig[] first, ComponentConfig[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return ArrayUtil.mergeArrays(first, second);
    }

    @Override
    public boolean isBundled() {
        String path;
        try {
            path = this.getPath().getCanonicalPath();
        }
        catch (IOException e) {
            path = this.getPath().getAbsolutePath();
        }
        if (ApplicationManager.getApplication().isInternal() && path.startsWith(PathManager.getHomePath() + File.separator + "out" + File.separator + "classes")) {
            return true;
        }
        return path.startsWith(PathManager.getPreInstalledPluginsPath());
    }

    @Nullable
    public List<String> getModules() {
        return this.myModules;
    }
}

