/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsVars;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.backend.common.CodegenUtil;
import org.jetbrains.jet.backend.common.DataClassMethodGenerator;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

class JsDataClassGenerator
extends DataClassMethodGenerator {
    private final TranslationContext context;
    private final List<? super JsPropertyInitializer> output;

    JsDataClassGenerator(JetClassOrObject klass, TranslationContext context, List<? super JsPropertyInitializer> output) {
        super(klass, context.bindingContext());
        this.context = context;
        this.output = output;
    }

    @Override
    public void generateComponentFunction(@NotNull FunctionDescriptor function, @NotNull ValueParameterDescriptor parameter) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/k2js/translate/declaration/JsDataClassGenerator", "generateComponentFunction"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/k2js/translate/declaration/JsDataClassGenerator", "generateComponentFunction"));
        }
        JsFunction functionObject = this.generateJsMethod(function);
        JsExpression returnExpression = JsDataClassGenerator.propertyAccessor(JsLiteral.THIS, this.context.getNameForDescriptor(parameter).toString());
        functionObject.getBody().getStatements().add(new JsReturn(returnExpression));
    }

    @Override
    public void generateCopyFunction(@NotNull FunctionDescriptor function, @NotNull List<JetParameter> constructorParameters) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/k2js/translate/declaration/JsDataClassGenerator", "generateCopyFunction"));
        }
        if (constructorParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorParameters", "org/jetbrains/k2js/translate/declaration/JsDataClassGenerator", "generateCopyFunction"));
        }
        JsFunction functionObj = this.generateJsMethod(function);
        JsScope funScope = functionObj.getScope();
        assert (function.getValueParameters().size() == constructorParameters.size());
        ArrayList<JsExpression> constructorArguments = new ArrayList<JsExpression>(constructorParameters.size());
        for (int i = 0; i < constructorParameters.size(); ++i) {
            JsExpressionImpl argumentValue;
            JetParameter constructorParam = constructorParameters.get(i);
            JsName paramName = funScope.declareName(constructorParam.getName());
            functionObj.getParameters().add(new JsParameter(paramName));
            JsNameRef parameterValue = new JsNameRef(paramName);
            if (constructorParam.getValOrVarNode() == null) {
                assert (!function.getValueParameters().get(i).hasDefaultValue());
                argumentValue = parameterValue;
            } else {
                JsBinaryOperation defaultCondition = JsAstUtils.equality(new JsNameRef(paramName), this.context.namer().getUndefinedExpression());
                argumentValue = new JsConditional(defaultCondition, JsDataClassGenerator.propertyAccessor(JsLiteral.THIS, constructorParam.getName()), parameterValue);
            }
            constructorArguments.add(argumentValue);
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)function.getContainingDeclaration();
        ConstructorDescriptor constructor = classDescriptor.getConstructors().iterator().next();
        JsNameRef constructorRef = this.context.getQualifiedReference(constructor);
        JsNew returnExpression = new JsNew(constructorRef, constructorArguments);
        functionObj.getBody().getStatements().add(new JsReturn(returnExpression));
    }

    @Override
    public void generateToStringMethod(@NotNull List<PropertyDescriptor> classProperties) {
        if (classProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProperties", "org/jetbrains/k2js/translate/declaration/JsDataClassGenerator", "generateToStringMethod"));
        }
        assert (!classProperties.isEmpty());
        FunctionDescriptor prototypeFun = CodegenUtil.getAnyToStringMethod();
        JsFunction functionObj = this.generateJsMethod(prototypeFun);
        JsProgram jsProgram = this.context.program();
        JsBinaryOperation result2 = null;
        for (int i = 0; i < classProperties.size(); ++i) {
            String name = classProperties.get(i).getName().toString();
            JsStringLiteral literal = jsProgram.getStringLiteral((i == 0 ? this.getClassDescriptor().getName() + "(" : ", ") + name + "=");
            JsInvocation expr = new JsInvocation((JsExpression)new JsNameRef("toString", (JsExpression)Namer.KOTLIN_OBJECT_REF), JsDataClassGenerator.propertyAccessor(JsLiteral.THIS, name));
            JsBinaryOperation component = JsAstUtils.sum(literal, expr);
            result2 = result2 == null ? component : JsAstUtils.sum(result2, component);
        }
        assert (result2 != null);
        result2 = JsAstUtils.sum(result2, jsProgram.getStringLiteral(")"));
        functionObj.getBody().getStatements().add(new JsReturn(result2));
    }

    @Override
    public void generateHashCodeMethod(@NotNull List<PropertyDescriptor> classProperties) {
        if (classProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProperties", "org/jetbrains/k2js/translate/declaration/JsDataClassGenerator", "generateHashCodeMethod"));
        }
        FunctionDescriptor prototypeFun = CodegenUtil.getAnyHashCodeMethod();
        JsFunction functionObj = this.generateJsMethod(prototypeFun);
        JsProgram jsProgram = this.context.program();
        List<JsStatement> statements = functionObj.getBody().getStatements();
        JsName varName = functionObj.getScope().declareName("result");
        int typeHash = this.context.getQualifiedReference(this.getClassDescriptor()).toString().hashCode();
        statements.add(new JsVars(new JsVars.JsVar(varName, jsProgram.getNumberLiteral(typeHash))));
        for (PropertyDescriptor prop : classProperties) {
            JsInvocation component = new JsInvocation((JsExpression)new JsNameRef("hashCode", (JsExpression)Namer.KOTLIN_OBJECT_REF), JsDataClassGenerator.propertyAccessor(JsLiteral.THIS, prop.getName().toString()));
            JsBinaryOperation newHashValue = JsAstUtils.sum(JsAstUtils.mul(new JsNameRef(varName), jsProgram.getNumberLiteral(31)), component);
            JsExpression assignment = JsAstUtils.assignment(new JsNameRef(varName), new JsBinaryOperation(JsBinaryOperator.BIT_OR, newHashValue, jsProgram.getNumberLiteral(0)));
            statements.add(assignment.makeStmt());
        }
        statements.add(new JsReturn(new JsNameRef(varName)));
    }

    @Override
    public void generateEqualsMethod(@NotNull List<PropertyDescriptor> classProperties) {
        if (classProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProperties", "org/jetbrains/k2js/translate/declaration/JsDataClassGenerator", "generateEqualsMethod"));
        }
        assert (!classProperties.isEmpty());
        FunctionDescriptor prototypeFun = CodegenUtil.getAnyEqualsMethod();
        JsFunction functionObj = this.generateJsMethod(prototypeFun);
        JsScope funScope = functionObj.getScope();
        JsName paramName = funScope.declareName("other");
        functionObj.getParameters().add(new JsParameter(paramName));
        JsBinaryOperation referenceEqual = JsAstUtils.equality(JsLiteral.THIS, new JsNameRef(paramName));
        JsBinaryOperation isNotNull = JsAstUtils.inequality(new JsNameRef(paramName), JsLiteral.NULL);
        JsBinaryOperation prototypeEqual = JsAstUtils.equality(new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), (JsExpression)JsLiteral.THIS), new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), (JsExpression)new JsNameRef(paramName)));
        JsExpressionImpl fieldChain = null;
        for (PropertyDescriptor prop : classProperties) {
            String name = prop.getName().toString();
            JsInvocation next = new JsInvocation((JsExpression)new JsNameRef("equals", (JsExpression)Namer.KOTLIN_OBJECT_REF), JsDataClassGenerator.propertyAccessor(JsLiteral.THIS, name), JsDataClassGenerator.propertyAccessor(new JsNameRef(paramName), name));
            if (fieldChain == null) {
                fieldChain = next;
                continue;
            }
            fieldChain = JsAstUtils.and(fieldChain, next);
        }
        assert (fieldChain != null);
        JsBinaryOperation returnExpression = JsAstUtils.or(referenceEqual, JsAstUtils.and(isNotNull, JsAstUtils.and(prototypeEqual, fieldChain)));
        functionObj.getBody().getStatements().add(new JsReturn(returnExpression));
    }

    private static JsExpression propertyAccessor(JsExpression object2, String propertyName) {
        return new JsNameRef(propertyName, object2);
    }

    private JsFunction generateJsMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/k2js/translate/declaration/JsDataClassGenerator", "generateJsMethod"));
        }
        JsName functionName = this.context.getNameForDescriptor(functionDescriptor);
        JsScope enclosingScope = this.context.scope();
        JsFunction functionObject = JsAstUtils.createFunctionWithEmptyBody(enclosingScope);
        JsPropertyInitializer initializer = new JsPropertyInitializer(functionName.makeRef(), functionObject);
        this.output.add(initializer);
        return functionObject;
    }
}

