/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalyzer;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class ClosureExpressionsTypingVisitor
extends ExpressionTypingVisitor {
    protected ClosureExpressionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @Override
    public JetTypeInfo visitObjectLiteralExpression(final @NotNull JetObjectLiteralExpression expression, final ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "visitObjectLiteralExpression"));
        }
        DelegatingBindingTrace delegatingBindingTrace = context.trace.get(BindingContext.TRACE_DELTAS_CACHE, expression.getObjectDeclaration());
        if (delegatingBindingTrace != null) {
            delegatingBindingTrace.addAllMyDataTo(context.trace);
            JetType type = context.trace.get(BindingContext.EXPRESSION_TYPE, expression);
            return DataFlowUtils.checkType(type, expression, context, context.dataFlowInfo);
        }
        final JetType[] result2 = new JetType[1];
        final TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve object literal expression", expression);
        ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor> handler = new ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<PsiElement, ClassDescriptor> slice, PsiElement declaration, final ClassDescriptor descriptor) {
                if (slice == BindingContext.CLASS && declaration == expression.getObjectDeclaration()) {
                    DeferredType defaultType = DeferredType.createRecursionIntolerant(ClosureExpressionsTypingVisitor.this.components.globalContext.getStorageManager(), context.trace, new Function0<JetType>(){

                        @Override
                        public JetType invoke() {
                            return descriptor.getDefaultType();
                        }
                    });
                    result2[0] = defaultType;
                    if (!context.trace.get(BindingContext.PROCESSED, expression).booleanValue()) {
                        temporaryTrace.record(BindingContext.EXPRESSION_TYPE, expression, defaultType);
                        temporaryTrace.record(BindingContext.PROCESSED, expression);
                    }
                }
            }
        };
        ObservableBindingTrace traceAdapter = new ObservableBindingTrace(temporaryTrace);
        traceAdapter.addHandler(BindingContext.CLASS, handler);
        TopDownAnalyzer.processClassOrObject(this.components.globalContext, null, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceBindingTrace(traceAdapter)).replaceContextDependency(ContextDependency.INDEPENDENT), context.scope.getContainingDeclaration(), expression.getObjectDeclaration());
        DelegatingBindingTrace cloneDelta = new DelegatingBindingTrace(new BindingTraceContext().getBindingContext(), "cached delta trace for object literal expression resolve", expression);
        temporaryTrace.addAllMyDataTo(cloneDelta);
        context.trace.record(BindingContext.TRACE_DELTAS_CACHE, expression.getObjectDeclaration(), cloneDelta);
        temporaryTrace.commit();
        return DataFlowUtils.checkType(result2[0], expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "visitFunctionLiteralExpression"));
        }
        JetBlockExpression bodyExpression = expression.getFunctionLiteral().getBodyExpression();
        if (bodyExpression == null) {
            return null;
        }
        JetType expectedType = context.expectedType;
        boolean functionTypeExpected = !TypeUtils.noExpectedType(expectedType) && KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(expectedType);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionDescriptor(expression, context, functionTypeExpected);
        JetType safeReturnType = this.computeReturnType(expression, context, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        JetType receiver = DescriptorUtils.getReceiverParameterType(functionDescriptor.getReceiverParameter());
        List<JetType> valueParametersTypes = DescriptorUtils.getValueParametersTypes(functionDescriptor.getValueParameters());
        JetType resultType = KotlinBuiltIns.getInstance().getFunctionType(Annotations.EMPTY, receiver, valueParametersTypes, safeReturnType);
        if (!TypeUtils.noExpectedType(expectedType) && KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(expectedType)) {
            return JetTypeInfo.create(resultType, context.dataFlowInfo);
        }
        return DataFlowUtils.checkType(resultType, expression, context, context.dataFlowInfo);
    }

    @NotNull
    private AnonymousFunctionDescriptor createFunctionDescriptor(@NotNull JetFunctionLiteralExpression expression, @NotNull ExpressionTypingContext context, boolean functionTypeExpected) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createFunctionDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createFunctionDescriptor"));
        }
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        JetTypeReference receiverTypeRef = functionLiteral.getReceiverTypeRef();
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(context.scope.getContainingDeclaration(), Annotations.EMPTY, CallableMemberDescriptor.Kind.DECLARATION);
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(context, functionLiteral, functionDescriptor, functionTypeExpected);
        JetType effectiveReceiverType = receiverTypeRef == null ? (functionTypeExpected ? KotlinBuiltIns.getInstance().getReceiverType(context.expectedType) : null) : this.components.expressionTypingServices.getTypeResolver().resolveType(context.scope, receiverTypeRef, context.trace, true);
        functionDescriptor.initialize(effectiveReceiverType, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Collections.emptyList(), (List)valueParameterDescriptors, (JetType)null, Modality.FINAL, Visibilities.LOCAL);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context.trace, functionLiteral, functionDescriptor);
        AnonymousFunctionDescriptor anonymousFunctionDescriptor = functionDescriptor;
        if (anonymousFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createFunctionDescriptor"));
        }
        return anonymousFunctionDescriptor;
    }

    @NotNull
    private List<ValueParameterDescriptor> createValueParameterDescriptors(@NotNull ExpressionTypingContext context, @NotNull JetFunctionLiteral functionLiteral, @NotNull FunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        boolean hasDeclaredValueParameters;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptors"));
        }
        if (functionLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteral", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptors"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptors"));
        }
        ArrayList<ValueParameterDescriptor> valueParameterDescriptors = Lists.newArrayList();
        List<JetParameter> declaredValueParameters = functionLiteral.getValueParameters();
        List<ValueParameterDescriptor> expectedValueParameters = functionTypeExpected ? KotlinBuiltIns.getInstance().getValueParameters(functionDescriptor, context.expectedType) : null;
        JetParameterList valueParameterList = functionLiteral.getValueParameterList();
        boolean bl = hasDeclaredValueParameters = valueParameterList != null;
        if (functionTypeExpected && !hasDeclaredValueParameters && expectedValueParameters.size() == 1) {
            ValueParameterDescriptor valueParameterDescriptor = expectedValueParameters.get(0);
            ValueParameterDescriptorImpl it = new ValueParameterDescriptorImpl(functionDescriptor, null, 0, Annotations.EMPTY, Name.identifier("it"), valueParameterDescriptor.getType(), valueParameterDescriptor.hasDefaultValue(), valueParameterDescriptor.getVarargElementType());
            valueParameterDescriptors.add(it);
            context.trace.record(BindingContext.AUTO_CREATED_IT, it);
        } else {
            if (expectedValueParameters != null && declaredValueParameters.size() != expectedValueParameters.size()) {
                List<JetType> expectedParameterTypes = DescriptorUtils.getValueParametersTypes(expectedValueParameters);
                context.trace.report(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.on(functionLiteral, expectedParameterTypes.size(), expectedParameterTypes));
            }
            for (int i = 0; i < declaredValueParameters.size(); ++i) {
                ValueParameterDescriptor valueParameterDescriptor = this.createValueParameterDescriptor(context, functionDescriptor, declaredValueParameters, expectedValueParameters, i);
                valueParameterDescriptors.add(valueParameterDescriptor);
            }
        }
        ArrayList<ValueParameterDescriptor> arrayList = valueParameterDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    private ValueParameterDescriptor createValueParameterDescriptor(@NotNull ExpressionTypingContext context, @NotNull FunctionDescriptorImpl functionDescriptor, @NotNull List<JetParameter> declaredValueParameters, @Nullable List<ValueParameterDescriptor> expectedValueParameters, int index) {
        JetType type;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptor"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptor"));
        }
        if (declaredValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaredValueParameters", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptor"));
        }
        JetParameter declaredParameter = declaredValueParameters.get(index);
        JetTypeReference typeReference = declaredParameter.getTypeReference();
        JetType expectedType = expectedValueParameters != null && index < expectedValueParameters.size() ? expectedValueParameters.get(index).getType() : null;
        if (typeReference != null) {
            type = this.components.expressionTypingServices.getTypeResolver().resolveType(context.scope, typeReference, context.trace, true);
            if (expectedType != null && !JetTypeChecker.INSTANCE.isSubtypeOf(expectedType, type)) {
                context.trace.report(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.on(declaredParameter, expectedType));
            }
        } else {
            if (expectedType == null || expectedType == TypeUtils.DONT_CARE || ErrorUtils.isUninferredParameter(expectedType)) {
                context.trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on(declaredParameter));
            }
            type = expectedType != null ? expectedType : TypeUtils.CANT_INFER_LAMBDA_PARAM_TYPE;
        }
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = this.components.expressionTypingServices.getDescriptorResolver().resolveValueParameterDescriptorWithAnnotationArguments(context.scope, functionDescriptor, declaredParameter, index, type, context.trace);
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "createValueParameterDescriptor"));
        }
        return valueParameterDescriptorImpl;
    }

    @NotNull
    private JetType computeReturnType(@NotNull JetFunctionLiteralExpression expression, @NotNull ExpressionTypingContext context, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeReturnType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeReturnType"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeReturnType"));
        }
        JetType expectedReturnType = functionTypeExpected ? KotlinBuiltIns.getInstance().getReturnTypeFromFunctionType(context.expectedType) : null;
        JetType returnType = this.computeUnsafeReturnType(expression, context, functionDescriptor, expectedReturnType);
        if (!expression.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected && KotlinBuiltIns.getInstance().isUnit(expectedReturnType)) {
            JetType jetType = KotlinBuiltIns.getInstance().getUnitType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeReturnType"));
            }
            return jetType;
        }
        JetType jetType = returnType == null ? TypeUtils.CANT_INFER_LAMBDA_PARAM_TYPE : returnType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeReturnType"));
        }
        return jetType;
    }

    @Nullable
    private JetType computeUnsafeReturnType(@NotNull JetFunctionLiteralExpression expression, @NotNull ExpressionTypingContext context, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, @Nullable JetType expectedReturnType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeUnsafeReturnType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeUnsafeReturnType"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "computeUnsafeReturnType"));
        }
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        JetBlockExpression bodyExpression = functionLiteral.getBodyExpression();
        assert (bodyExpression != null);
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace);
        JetTypeReference returnTypeRef = functionLiteral.getReturnTypeRef();
        JetType declaredReturnType = null;
        if (returnTypeRef != null) {
            declaredReturnType = this.components.expressionTypingServices.getTypeResolver().resolveType(context.scope, returnTypeRef, context.trace, true);
            functionDescriptor.setReturnType(declaredReturnType);
            if (expectedReturnType != null && !JetTypeChecker.INSTANCE.isSubtypeOf(declaredReturnType, expectedReturnType)) {
                context.trace.report(Errors.EXPECTED_RETURN_TYPE_MISMATCH.on(returnTypeRef, expectedReturnType));
            }
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(functionInnerScope)).replaceExpectedType(declaredReturnType != null ? declaredReturnType : (expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE));
        JetType typeOfBodyExpression = this.components.expressionTypingServices.getBlockReturnedType(bodyExpression, CoercionStrategy.COERCION_TO_UNIT, newContext).getType();
        ArrayList<JetType> returnedExpressionTypes = Lists.newArrayList(ClosureExpressionsTypingVisitor.getTypesOfLocallyReturnedExpressions(functionLiteral, context.trace, ClosureExpressionsTypingVisitor.collectReturns(bodyExpression)));
        ContainerUtil.addIfNotNull(returnedExpressionTypes, typeOfBodyExpression);
        if (declaredReturnType != null) {
            return declaredReturnType;
        }
        if (returnedExpressionTypes.isEmpty()) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    private static List<JetType> getTypesOfLocallyReturnedExpressions(final JetFunctionLiteral functionLiteral, final BindingTrace trace, Collection<JetReturnExpression> returnExpressions) {
        return ContainerUtil.mapNotNull(returnExpressions, new Function<JetReturnExpression, JetType>(){

            @Override
            public JetType fun(JetReturnExpression returnExpression) {
                JetSimpleNameExpression label = returnExpression.getTargetLabel();
                if (label == null) {
                    return null;
                }
                PsiElement labelTarget = trace.get(BindingContext.LABEL_TARGET, label);
                if (labelTarget != functionLiteral) {
                    return null;
                }
                JetExpression returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null) {
                    return KotlinBuiltIns.getInstance().getUnitType();
                }
                JetType returnedType = trace.get(BindingContext.EXPRESSION_TYPE, returnedExpression);
                assert (returnedType != null) : "No type for returned expression: " + returnedExpression + ",\n" + "the type should have been computed by getBlockReturnedType() above";
                return returnedType;
            }
        });
    }

    public static Collection<JetReturnExpression> collectReturns(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor", "collectReturns"));
        }
        ArrayList<JetReturnExpression> result2 = Lists.newArrayList();
        expression.accept(new JetTreeVisitor<Collection<JetReturnExpression>>(){

            @Override
            public Void visitReturnExpression(@NotNull JetReturnExpression expression, Collection<JetReturnExpression> data2) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ClosureExpressionsTypingVisitor$3", "visitReturnExpression"));
                }
                data2.add(expression);
                return null;
            }
        }, result2);
        return result2;
    }
}

