/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.error;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class ErrorClassDescriptor
extends ClassDescriptorImpl {
    public ErrorClassDescriptor(@Nullable String name) {
        super(ErrorUtils.getErrorModule(), Name.special(name == null ? "<ERROR CLASS>" : "<ERROR CLASS: " + name + ">"), Modality.OPEN, Collections.<JetType>emptyList());
        ConstructorDescriptorImpl errorConstructor = ConstructorDescriptorImpl.create(this, Annotations.EMPTY, true);
        errorConstructor.initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), Visibilities.INTERNAL, false);
        errorConstructor.setReturnType(ErrorUtils.createErrorType("<ERROR RETURN TYPE>"));
        this.initialize(ErrorUtils.createErrorScope(this.getName().asString()), Collections.singleton(errorConstructor), errorConstructor);
    }

    @Override
    @NotNull
    public ClassDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/types/error/ErrorClassDescriptor", "substitute"));
        }
        ErrorClassDescriptor errorClassDescriptor = this;
        if (errorClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/error/ErrorClassDescriptor", "substitute"));
        }
        return errorClassDescriptor;
    }

    @Override
    public String toString() {
        return this.getName().asString();
    }

    @Override
    @NotNull
    public JetScope getMemberScope(@NotNull List<? extends TypeProjection> typeArguments) {
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/jet/lang/types/error/ErrorClassDescriptor", "getMemberScope"));
        }
        JetScope jetScope = ErrorUtils.createErrorScope("Error scope for class " + this.getName() + " with arguments: " + typeArguments);
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/error/ErrorClassDescriptor", "getMemberScope"));
        }
        return jetScope;
    }
}

