/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.KotlinPackage;
import kotlin.Unit;
import org.jetbrains.annotations.Mutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.resolve.TypeHierarchyResolver;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.LazyEntity;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.ScopeProvider;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassInfoUtil;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.data.SyntheticClassObjectInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyAnnotationsContext;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyTypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.ClassObjectMixinScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.LazyResolveStorageManager;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.NullableLazyValue;

public class LazyClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptorWithResolutionScopes,
LazyEntity {
    private static final Predicate<JetType> VALID_SUPERTYPE = new Predicate<JetType>(){

        @Override
        public boolean apply(JetType type) {
            assert (!type.isError()) : "Error types must be filtered out in DescriptorResolver";
            return TypeUtils.getClassDescriptor(type) != null;
        }
    };
    private final ResolveSession resolveSession;
    private final JetClassLikeInfo originalClassInfo;
    private final ClassMemberDeclarationProvider declarationProvider;
    private final LazyClassTypeConstructor typeConstructor;
    private final Modality modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final Annotations annotations;
    private final NullableLazyValue<ClassDescriptorWithResolutionScopes> classObjectDescriptor;
    private final MemoizedFunctionToNotNull<JetClassObject, ClassDescriptorWithResolutionScopes> extraClassObjectDescriptors;
    private final LazyClassMemberScope unsubstitutedMemberScope;
    private final NotNullLazyValue<JetScope> scopeForClassHeaderResolution;
    private final NotNullLazyValue<JetScope> scopeForMemberDeclarationResolution;
    private final NotNullLazyValue<JetScope> scopeForPropertyInitializerResolution;
    private final NullableLazyValue<Void> forceResolveAllContents;

    public LazyClassDescriptor(final @NotNull ResolveSession resolveSession, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull JetClassLikeInfo classLikeInfo) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (classLikeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLikeInfo", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        super(resolveSession.getStorageManager(), containingDeclaration, name);
        this.resolveSession = resolveSession;
        if (classLikeInfo.getCorrespondingClassOrObject() != null) {
            this.resolveSession.getTrace().record(BindingContext.CLASS, classLikeInfo.getCorrespondingClassOrObject(), this);
        }
        this.resolveSession.getTrace().record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, DescriptorUtils.getFqName(this), this);
        this.originalClassInfo = classLikeInfo;
        this.declarationProvider = resolveSession.getDeclarationProviderFactory().getClassMemberDeclarationProvider(classLikeInfo);
        this.unsubstitutedMemberScope = this.createMemberScope(resolveSession, this.declarationProvider);
        this.typeConstructor = new LazyClassTypeConstructor();
        this.kind = classLikeInfo.getClassKind();
        JetModifierList modifierList = classLikeInfo.getModifierList();
        if (this.kind.isSingleton()) {
            this.modality = Modality.FINAL;
        } else {
            Modality defaultModality = this.kind == ClassKind.TRAIT ? Modality.ABSTRACT : Modality.FINAL;
            this.modality = ModifiersChecker.resolveModalityFromModifiers(modifierList, defaultModality);
        }
        this.visibility = DescriptorUtils.isSyntheticClassObject(this) ? DescriptorUtils.getSyntheticClassObjectVisibility() : ModifiersChecker.resolveVisibilityFromModifiers(modifierList, ModifiersChecker.getDefaultClassVisibility(this));
        this.isInner = ModifiersChecker.isInnerClass(modifierList);
        LazyResolveStorageManager storageManager = resolveSession.getStorageManager();
        this.annotations = modifierList != null ? new LazyAnnotations(new LazyAnnotationsContext(resolveSession.getAnnotationResolver(), resolveSession.getStorageManager(), resolveSession.getTrace()){

            @Override
            @NotNull
            public JetScope getScope() {
                JetClassLikeInfo ownerInfo = LazyClassDescriptor.this.declarationProvider.getOwnerInfo();
                JetScope jetScope = resolveSession.getScopeProvider().getResolutionScopeForDeclaration(ownerInfo.getScopeAnchor());
                if (jetScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor$2", "getScope"));
                }
                return jetScope;
            }
        }, modifierList.getAnnotationEntries()) : Annotations.EMPTY;
        this.classObjectDescriptor = storageManager.createNullableLazyValue(new Function0<ClassDescriptorWithResolutionScopes>(){

            @Override
            public ClassDescriptorWithResolutionScopes invoke() {
                return LazyClassDescriptor.this.computeClassObjectDescriptor(LazyClassDescriptor.this.declarationProvider.getOwnerInfo().getClassObject());
            }
        });
        this.extraClassObjectDescriptors = storageManager.createMemoizedFunction(new Function1<JetClassObject, ClassDescriptorWithResolutionScopes>(){

            @Override
            public ClassDescriptorWithResolutionScopes invoke(JetClassObject classObject) {
                return LazyClassDescriptor.this.computeClassObjectDescriptor(classObject);
            }
        });
        this.scopeForClassHeaderResolution = storageManager.createLazyValue(new Function0<JetScope>(){

            @Override
            public JetScope invoke() {
                return LazyClassDescriptor.this.computeScopeForClassHeaderResolution();
            }
        });
        this.scopeForMemberDeclarationResolution = storageManager.createLazyValue(new Function0<JetScope>(){

            @Override
            public JetScope invoke() {
                return LazyClassDescriptor.this.computeScopeForMemberDeclarationResolution();
            }
        });
        this.scopeForPropertyInitializerResolution = storageManager.createLazyValue(new Function0<JetScope>(){

            @Override
            public JetScope invoke() {
                return LazyClassDescriptor.this.computeScopeForPropertyInitializerResolution();
            }
        });
        this.forceResolveAllContents = storageManager.createRecursionTolerantNullableLazyValue(new Function0<Void>(){

            @Override
            public Void invoke() {
                LazyClassDescriptor.this.doForceResolveAllContents();
                return null;
            }
        }, null);
    }

    @NotNull
    protected LazyClassMemberScope createMemberScope(@NotNull ResolveSession resolveSession, @NotNull ClassMemberDeclarationProvider declarationProvider) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProvider", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        LazyClassMemberScope lazyClassMemberScope = new LazyClassMemberScope(resolveSession, declarationProvider, this, resolveSession.getTrace());
        if (lazyClassMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        return lazyClassMemberScope;
    }

    @Override
    @NotNull
    public JetScope getScopeForMemberLookup() {
        LazyClassMemberScope lazyClassMemberScope = this.unsubstitutedMemberScope;
        if (lazyClassMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForMemberLookup"));
        }
        return lazyClassMemberScope;
    }

    @Override
    @NotNull
    public JetScope getScopeForClassHeaderResolution() {
        JetScope jetScope = (JetScope)this.scopeForClassHeaderResolution.invoke();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForClassHeaderResolution"));
        }
        return jetScope;
    }

    @NotNull
    private JetScope computeScopeForClassHeaderResolution() {
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, this, RedeclarationHandler.DO_NOTHING, "Scope with type parameters for " + this.getName());
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            scope.addClassifierDescriptor(typeParameterDescriptor);
        }
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        PsiElement scopeAnchor = this.declarationProvider.getOwnerInfo().getScopeAnchor();
        ChainedScope chainedScope = new ChainedScope(this, "ScopeForClassHeaderResolution: " + this.getName(), scope, this.getScopeProvider().getResolutionScopeForDeclaration(scopeAnchor));
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "computeScopeForClassHeaderResolution"));
        }
        return chainedScope;
    }

    @Override
    @NotNull
    public JetScope getScopeForMemberDeclarationResolution() {
        JetScope jetScope = (JetScope)this.scopeForMemberDeclarationResolution.invoke();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForMemberDeclarationResolution"));
        }
        return jetScope;
    }

    @NotNull
    private JetScope computeScopeForMemberDeclarationResolution() {
        WritableScopeImpl thisScope = new WritableScopeImpl(JetScope.EMPTY, this, RedeclarationHandler.DO_NOTHING, "Scope with 'this' for " + this.getName());
        thisScope.addLabeledDeclaration(this);
        thisScope.changeLockLevel(WritableScope.LockLevel.READING);
        ClassDescriptorWithResolutionScopes classObject = this.getClassObjectDescriptor();
        JetScope classObjectAdapterScope = classObject != null ? new ClassObjectMixinScope(classObject) : JetScope.EMPTY;
        ChainedScope chainedScope = new ChainedScope(this, "ScopeForMemberDeclarationResolution: " + this.getName(), thisScope, this.getScopeForMemberLookup(), this.getScopeForClassHeaderResolution(), classObjectAdapterScope);
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "computeScopeForMemberDeclarationResolution"));
        }
        return chainedScope;
    }

    @Override
    @NotNull
    public JetScope getScopeForInitializerResolution() {
        JetScope jetScope = (JetScope)this.scopeForPropertyInitializerResolution.invoke();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForInitializerResolution"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public Collection<CallableMemberDescriptor> getDeclaredCallableMembers() {
        List<DeclarationDescriptor> list = KotlinPackage.filter(this.unsubstitutedMemberScope.getAllDescriptors(), new Function1<DeclarationDescriptor, Boolean>(){

            @Override
            public Boolean invoke(DeclarationDescriptor descriptor) {
                return descriptor instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getDeclaredCallableMembers"));
        }
        return list;
    }

    @NotNull
    private JetScope computeScopeForPropertyInitializerResolution() {
        ConstructorDescriptor primaryConstructor = this.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor == null) {
            JetScope jetScope = this.getScopeForMemberDeclarationResolution();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "computeScopeForPropertyInitializerResolution"));
            }
            return jetScope;
        }
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, primaryConstructor, RedeclarationHandler.DO_NOTHING, "Scope with constructor parameters in " + this.getName());
        for (int i = 0; i < this.originalClassInfo.getPrimaryConstructorParameters().size(); ++i) {
            JetParameter jetParameter = this.originalClassInfo.getPrimaryConstructorParameters().get(i);
            if (jetParameter.getValOrVarNode() != null) continue;
            scope.addVariableDescriptor(primaryConstructor.getValueParameters().get(i));
        }
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        ChainedScope chainedScope = new ChainedScope(primaryConstructor, "ScopeForPropertyInitializerResolution: " + this.getName(), scope, this.getScopeForMemberDeclarationResolution());
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "computeScopeForPropertyInitializerResolution"));
        }
        return chainedScope;
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Set<ConstructorDescriptor> set = this.unsubstitutedMemberScope.getConstructors();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getConstructors"));
        }
        return set;
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.unsubstitutedMemberScope.getPrimaryConstructor();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        LazyClassTypeConstructor lazyClassTypeConstructor = this.typeConstructor;
        if (lazyClassTypeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getTypeConstructor"));
        }
        return lazyClassTypeConstructor;
    }

    @Override
    public ClassDescriptorWithResolutionScopes getClassObjectDescriptor() {
        return (ClassDescriptorWithResolutionScopes)this.classObjectDescriptor.invoke();
    }

    @NotNull
    @ReadOnly
    public List<ClassDescriptor> getDescriptorsForExtraClassObjects() {
        List<ClassDescriptor> list = KotlinPackage.map(KotlinPackage.filter(this.declarationProvider.getOwnerInfo().getClassObjects(), new Function1<JetClassObject, Boolean>(){

            @Override
            public Boolean invoke(JetClassObject classObject) {
                return classObject != LazyClassDescriptor.this.declarationProvider.getOwnerInfo().getClassObject();
            }
        }), new Function1<JetClassObject, ClassDescriptor>(){

            @Override
            public ClassDescriptor invoke(JetClassObject classObject) {
                return (ClassDescriptor)LazyClassDescriptor.this.extraClassObjectDescriptors.invoke(classObject);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getDescriptorsForExtraClassObjects"));
        }
        return list;
    }

    @Nullable
    private ClassDescriptorWithResolutionScopes computeClassObjectDescriptor(@Nullable JetClassObject classObject) {
        JetClassLikeInfo classObjectInfo = this.getClassObjectInfo(classObject);
        if (classObjectInfo != null) {
            return new LazyClassDescriptor(this.resolveSession, this, SpecialNames.getClassObjectName(this.getName()), classObjectInfo);
        }
        return null;
    }

    @Nullable
    private JetClassLikeInfo getClassObjectInfo(@Nullable JetClassObject classObject) {
        if (classObject != null) {
            if (this.getKind() != ClassKind.CLASS && this.getKind() != ClassKind.TRAIT && this.getKind() != ClassKind.ANNOTATION_CLASS || this.isInner()) {
                this.resolveSession.getTrace().report(Errors.CLASS_OBJECT_NOT_ALLOWED.on(classObject));
            }
            JetObjectDeclaration objectDeclaration = classObject.getObjectDeclaration();
            return JetClassInfoUtil.createClassLikeInfo(objectDeclaration);
        }
        if (this.getKind() == ClassKind.OBJECT || this.getKind() == ClassKind.ENUM_ENTRY || this.getKind() == ClassKind.ENUM_CLASS) {
            return new SyntheticClassObjectInfo(this.originalClassInfo, this);
        }
        return null;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations = this.annotations;
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getAnnotations"));
        }
        return annotations;
    }

    public String toString() {
        return "lazy class " + this.getName().toString();
    }

    @Override
    public void forceResolveAllContents() {
        this.forceResolveAllContents.invoke();
    }

    private void doForceResolveAllContents() {
        this.resolveMemberHeaders();
        ClassDescriptorWithResolutionScopes classObjectDescriptor = this.getClassObjectDescriptor();
        if (classObjectDescriptor != null) {
            ForceResolveUtil.forceResolveAllContents(classObjectDescriptor);
        }
        ForceResolveUtil.forceResolveAllContents(this.getConstructors());
        ForceResolveUtil.forceResolveAllContents(this.getDescriptorsForExtraClassObjects());
        ForceResolveUtil.forceResolveAllContents(this.getScopeForMemberLookup());
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
    }

    public void resolveMemberHeaders() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        this.getClassObjectDescriptor();
        this.getDescriptorsForExtraClassObjects();
        this.getClassObjectType();
        this.getConstructors();
        this.getContainingDeclaration();
        this.getThisAsReceiverParameter();
        this.getKind();
        this.getModality();
        this.getName();
        this.getOriginal();
        this.getScopeForClassHeaderResolution();
        this.getScopeForMemberDeclarationResolution();
        this.getScopeForMemberLookup().getAllDescriptors();
        this.getScopeForInitializerResolution();
        this.getUnsubstitutedInnerClassesScope();
        this.getTypeConstructor().getSupertypes();
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            typeParameterDescriptor.getUpperBounds();
            typeParameterDescriptor.getLowerBounds();
        }
        this.getUnsubstitutedPrimaryConstructor();
        this.getVisibility();
    }

    @NotNull
    private ScopeProvider getScopeProvider() {
        ScopeProvider scopeProvider = this.resolveSession.getScopeProvider();
        if (scopeProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeProvider"));
        }
        return scopeProvider;
    }

    private class LazyClassTypeConstructor
    implements LazyEntity,
    TypeConstructor {
        private final NotNullLazyValue<Supertypes> supertypes;
        private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;
        private final NullableLazyValue<Void> forceResolveAllContents;

        private LazyClassTypeConstructor() {
            this.supertypes = LazyClassDescriptor.this.resolveSession.getStorageManager().createLazyValueWithPostCompute(new Function0<Supertypes>(){

                @Override
                public Supertypes invoke() {
                    LazyClassDescriptor descriptor;
                    if (KotlinBuiltIns.getInstance().isSpecialClassWithNoSupertypes(LazyClassDescriptor.this)) {
                        return new Supertypes((Collection)Collections.emptyList());
                    }
                    JetClassLikeInfo info = LazyClassDescriptor.this.declarationProvider.getOwnerInfo();
                    if (info instanceof SyntheticClassObjectInfo && (descriptor = ((SyntheticClassObjectInfo)info).getClassDescriptor()).getKind().isSingleton()) {
                        return new Supertypes(Collections.singleton(descriptor.getDefaultType()));
                    }
                    JetClassOrObject classOrObject = info.getCorrespondingClassOrObject();
                    if (classOrObject == null) {
                        return new Supertypes(Collections.singleton(KotlinBuiltIns.getInstance().getAnyType()));
                    }
                    List<JetType> allSupertypes = LazyClassDescriptor.this.resolveSession.getDescriptorResolver().resolveSupertypes(LazyClassDescriptor.this.getScopeForClassHeaderResolution(), LazyClassDescriptor.this, classOrObject, LazyClassDescriptor.this.resolveSession.getTrace());
                    return new Supertypes(Lists.newArrayList(Collections2.filter(allSupertypes, VALID_SUPERTYPE)));
                }
            }, new Function1<Boolean, Supertypes>(){

                @Override
                public Supertypes invoke(Boolean firstTime) {
                    return new Supertypes((Collection)Collections.emptyList());
                }
            }, new Function1<Supertypes, Unit>(){

                @Override
                public Unit invoke(@NotNull Supertypes supertypes) {
                    if (supertypes == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor$3", "invoke"));
                    }
                    LazyClassTypeConstructor.this.findAndDisconnectLoopsInTypeHierarchy(supertypes);
                    return Unit.VALUE;
                }
            });
            this.parameters = LazyClassDescriptor.this.resolveSession.getStorageManager().createLazyValue(new Function0<List<TypeParameterDescriptor>>(){

                @Override
                public List<TypeParameterDescriptor> invoke() {
                    JetClassLikeInfo classInfo = LazyClassDescriptor.this.declarationProvider.getOwnerInfo();
                    List<JetTypeParameter> typeParameters = classInfo.getTypeParameters();
                    ArrayList<TypeParameterDescriptor> parameters = new ArrayList<TypeParameterDescriptor>(typeParameters.size());
                    for (int i = 0; i < typeParameters.size(); ++i) {
                        parameters.add(new LazyTypeParameterDescriptor(LazyClassDescriptor.this.resolveSession, LazyClassDescriptor.this, typeParameters.get(i), i));
                    }
                    return parameters;
                }
            });
            this.forceResolveAllContents = LazyClassDescriptor.this.resolveSession.getStorageManager().createRecursionTolerantNullableLazyValue(new Function0<Void>(){

                @Override
                public Void invoke() {
                    LazyClassTypeConstructor.this.doForceResolveAllContents();
                    return null;
                }
            }, null);
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List list = (List)this.parameters.invoke();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getParameters"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            Collection<JetType> collection = ((Supertypes)this.supertypes.invoke()).trueSupertypes;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getSupertypes"));
            }
            return collection;
        }

        private void findAndDisconnectLoopsInTypeHierarchy(Supertypes supertypes) {
            Iterator<JetType> iterator2 = supertypes.trueSupertypes.iterator();
            while (iterator2.hasNext()) {
                JetType supertype = iterator2.next();
                if (!this.isReachable(supertype.getConstructor(), this, new HashSet<TypeConstructor>())) continue;
                iterator2.remove();
                supertypes.cyclicSupertypes.add(supertype);
                ClassifierDescriptor supertypeDescriptor = supertype.getConstructor().getDeclarationDescriptor();
                if (!(supertypeDescriptor instanceof ClassDescriptor)) continue;
                ClassDescriptor superclass = (ClassDescriptor)supertypeDescriptor;
                TypeHierarchyResolver.reportCyclicInheritanceHierarchyError(LazyClassDescriptor.this.resolveSession.getTrace(), LazyClassDescriptor.this, superclass);
            }
        }

        private boolean isReachable(TypeConstructor from, TypeConstructor to, Set<TypeConstructor> visited) {
            if (!visited.add(from)) {
                return false;
            }
            for (JetType supertype : this.getNeighbors(from)) {
                TypeConstructor supertypeConstructor = supertype.getConstructor();
                if (supertypeConstructor == to) {
                    return true;
                }
                if (!this.isReachable(supertypeConstructor, to, visited)) continue;
                return true;
            }
            return false;
        }

        private Collection<JetType> getNeighbors(TypeConstructor from) {
            DeclarationDescriptor container;
            ArrayList<JetType> neighbours = new ArrayList<JetType>(from instanceof LazyClassTypeConstructor ? ((Supertypes)((LazyClassTypeConstructor)from).supertypes.invoke()).getAllSupertypes() : from.getSupertypes());
            ClassifierDescriptor fromDescriptor = from.getDeclarationDescriptor();
            if (fromDescriptor != null && (container = fromDescriptor.getContainingDeclaration()) instanceof ClassDescriptor) {
                neighbours.add(((ClassDescriptor)container).getDefaultType());
            }
            return neighbours;
        }

        @Override
        public boolean isFinal() {
            return !LazyClassDescriptor.this.getModality().isOverridable();
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        public ClassifierDescriptor getDeclarationDescriptor() {
            return LazyClassDescriptor.this;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations = Annotations.EMPTY;
            if (annotations == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getAnnotations"));
            }
            return annotations;
        }

        public String toString() {
            return LazyClassDescriptor.this.getName().toString();
        }

        @Override
        public void forceResolveAllContents() {
            this.forceResolveAllContents.invoke();
        }

        private void doForceResolveAllContents() {
            ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
            ForceResolveUtil.forceResolveAllContents(this.getSupertypes());
            ForceResolveUtil.forceResolveAllContents(this.getParameters());
        }
    }

    private static class Supertypes {
        @Mutable
        public final Collection<JetType> trueSupertypes;
        @Mutable
        public final Collection<JetType> cyclicSupertypes;

        private Supertypes(@Mutable @NotNull Collection<JetType> trueSupertypes) {
            if (trueSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueSupertypes", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "<init>"));
            }
            this(trueSupertypes, new ArrayList<JetType>(0));
        }

        private Supertypes(@Mutable @NotNull Collection<JetType> trueSupertypes, @Mutable @NotNull Collection<JetType> cyclicSupertypes) {
            if (trueSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueSupertypes", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "<init>"));
            }
            if (cyclicSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cyclicSupertypes", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "<init>"));
            }
            this.trueSupertypes = trueSupertypes;
            this.cyclicSupertypes = cyclicSupertypes;
        }

        @NotNull
        public Collection<JetType> getAllSupertypes() {
            List<JetType> list = KotlinPackage.plus(this.trueSupertypes, this.cyclicSupertypes);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "getAllSupertypes"));
            }
            return list;
        }
    }
}

