/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.Deserializers;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.ConstantsPackage;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.BaseDescriptorDeserializer;
import org.jetbrains.jet.lang.resolve.kotlin.DescriptorDeserializersStorage;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.DependencyClassByQualifiedNameResolver;
import org.jetbrains.jet.lang.types.error.ErrorClassDescriptor;

public class AnnotationDescriptorDeserializer
extends BaseDescriptorDeserializer
implements AnnotationDeserializer {
    @Override
    public void setStorage(@NotNull DescriptorDeserializersStorage storage) {
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "setStorage"));
        }
        this.storage = storage;
    }

    @Override
    public void setClassResolver(@NotNull DependencyClassByQualifiedNameResolver classResolver) {
        if (classResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "setClassResolver"));
        }
        this.classResolver = classResolver;
    }

    @Override
    public void setKotlinClassFinder(@NotNull KotlinClassFinder kotlinClassFinder) {
        if (kotlinClassFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClassFinder", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "setKotlinClassFinder"));
        }
        this.kotlinClassFinder = kotlinClassFinder;
    }

    @Override
    public void setErrorReporter(@NotNull ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "setErrorReporter"));
        }
        this.errorReporter = errorReporter;
    }

    @Override
    @NotNull
    public Annotations loadClassAnnotations(@NotNull ClassDescriptor descriptor, @NotNull ProtoBuf.Class classProto) {
        Annotations annotations;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
        }
        if (classProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
        }
        KotlinJvmBinaryClass kotlinClass = this.findKotlinClassByDescriptor(descriptor);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading class annotations is not found: " + descriptor, null);
            Annotations annotations2 = Annotations.EMPTY;
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
            }
            return annotations2;
        }
        try {
            annotations = this.loadClassAnnotationsFromClass(kotlinClass);
        }
        catch (IOException e) {
            this.errorReporter.reportLoadingError("Error loading member annotations from Kotlin class: " + kotlinClass, e);
            Annotations annotations3 = Annotations.EMPTY;
            if (annotations3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
            }
            return annotations3;
        }
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
        }
        return annotations;
    }

    @NotNull
    private Annotations loadClassAnnotationsFromClass(@NotNull KotlinJvmBinaryClass kotlinClass) throws IOException {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotationsFromClass"));
        }
        final ArrayList<AnnotationDescriptor> result2 = new ArrayList<AnnotationDescriptor>();
        kotlinClass.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(){

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull JvmClassName className) {
                if (className == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$1", "visitAnnotation"));
                }
                return AnnotationDescriptorDeserializer.resolveAnnotation(className, result2, AnnotationDescriptorDeserializer.this.classResolver);
            }

            @Override
            public void visitEnd() {
            }
        });
        AnnotationsImpl annotationsImpl = new AnnotationsImpl(result2);
        if (annotationsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotationsFromClass"));
        }
        return annotationsImpl;
    }

    @Nullable
    public static KotlinJvmBinaryClass.AnnotationArgumentVisitor resolveAnnotation(@NotNull JvmClassName className, final @NotNull List<AnnotationDescriptor> result2, final @NotNull DependencyClassByQualifiedNameResolver classResolver) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveAnnotation"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveAnnotation"));
        }
        if (classResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveAnnotation"));
        }
        if (JvmAnnotationNames.isSpecialAnnotation(className)) {
            return null;
        }
        final ClassDescriptor annotationClass = AnnotationDescriptorDeserializer.resolveClass(className, classResolver);
        return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){
            private final Map<ValueParameterDescriptor, CompileTimeConstant<?>> arguments = new HashMap();

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                if (name != null) {
                    ErrorValue argument = ConstantsPackage.createCompileTimeConstant(value, true, false, false, null);
                    this.setArgumentValueByName(name, argument != null ? argument : ErrorValue.create("Unsupported annotation argument: " + name));
                }
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassName", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "visitEnum"));
                }
                this.setArgumentValueByName(name, this.enumEntryValue(enumClassName, enumEntryName));
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "visitArray"));
                }
                return null;
            }

            @NotNull
            private CompileTimeConstant<?> enumEntryValue(@NotNull JvmClassName enumClassName, @NotNull Name name) {
                ClassifierDescriptor classifier2;
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassName", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "enumEntryValue"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "enumEntryValue"));
                }
                ClassDescriptor enumClass = AnnotationDescriptorDeserializer.resolveClass(enumClassName, classResolver);
                if (enumClass.getKind() == ClassKind.ENUM_CLASS && (classifier2 = enumClass.getUnsubstitutedInnerClassesScope().getClassifier(name)) instanceof ClassDescriptor) {
                    EnumValue enumValue = new EnumValue((ClassDescriptor)classifier2, false);
                    if (enumValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "enumEntryValue"));
                    }
                    return enumValue;
                }
                ErrorValue errorValue = ErrorValue.create("Unresolved enum entry: " + enumClassName.getInternalName() + "." + name);
                if (errorValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "enumEntryValue"));
                }
                return errorValue;
            }

            @Override
            public void visitEnd() {
                result2.add(new AnnotationDescriptorImpl(annotationClass.getDefaultType(), this.arguments));
            }

            private void setArgumentValueByName(@NotNull Name name, @NotNull CompileTimeConstant<?> argumentValue) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "setArgumentValueByName"));
                }
                if (argumentValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentValue", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "setArgumentValueByName"));
                }
                ValueParameterDescriptor parameter = DescriptorResolverUtils.getAnnotationParameterByName(name, annotationClass);
                if (parameter != null) {
                    this.arguments.put(parameter, argumentValue);
                }
            }
        };
    }

    @NotNull
    private static ClassDescriptor resolveClass(@NotNull JvmClassName className, DependencyClassByQualifiedNameResolver classResolver) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveClass"));
        }
        ClassDescriptor annotationClass = classResolver.resolveClass(className.getFqNameForClassNameWithoutDollars());
        ClassDescriptor classDescriptor = annotationClass != null ? annotationClass : new ErrorClassDescriptor(className.getInternalName());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveClass"));
        }
        return classDescriptor;
    }

    @Override
    @NotNull
    public Annotations loadCallableAnnotations(@NotNull ClassOrPackageFragmentDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull Deserializers.AnnotatedCallableKind kind) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        DescriptorDeserializersStorage.MemberSignature signature = AnnotationDescriptorDeserializer.getCallableSignature(proto, nameResolver, kind);
        if (signature == null) {
            Annotations annotations = Annotations.EMPTY;
            if (annotations == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
            }
            return annotations;
        }
        Annotations annotations = this.findClassAndLoadMemberAnnotations(container, proto, nameResolver, kind, signature);
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        return annotations;
    }

    @NotNull
    private Annotations findClassAndLoadMemberAnnotations(@NotNull ClassOrPackageFragmentDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull Deserializers.AnnotatedCallableKind kind, @NotNull DescriptorDeserializersStorage.MemberSignature signature) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        KotlinJvmBinaryClass kotlinClass = this.findClassWithAnnotationsAndInitializers(container, proto, nameResolver, kind);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading member annotations is not found: " + container, null);
            Annotations annotations = Annotations.EMPTY;
            if (annotations == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
            }
            return annotations;
        }
        List<AnnotationDescriptor> annotations = ((DescriptorDeserializersStorage.Storage)this.storage.getStorage().invoke(kotlinClass)).getMemberAnnotations().get(signature);
        Annotations annotations2 = annotations == null ? Annotations.EMPTY : new AnnotationsImpl(annotations);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassAndLoadMemberAnnotations"));
        }
        return annotations2;
    }

    @Override
    @NotNull
    public Annotations loadValueParameterAnnotations(@NotNull ClassOrPackageFragmentDescriptor container, @NotNull ProtoBuf.Callable callable2, @NotNull NameResolver nameResolver, @NotNull Deserializers.AnnotatedCallableKind kind, @NotNull ProtoBuf.Callable.ValueParameter proto) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        DescriptorDeserializersStorage.MemberSignature methodSignature = AnnotationDescriptorDeserializer.getCallableSignature(callable2, nameResolver, kind);
        if (methodSignature != null && proto.hasExtension(JavaProtoBuf.index)) {
            DescriptorDeserializersStorage.MemberSignature paramSignature = DescriptorDeserializersStorage.MemberSignature.fromMethodSignatureAndParameterIndex(methodSignature, proto.getExtension(JavaProtoBuf.index));
            Annotations annotations = this.findClassAndLoadMemberAnnotations(container, callable2, nameResolver, kind, paramSignature);
            if (annotations == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
            }
            return annotations;
        }
        Annotations annotations = Annotations.EMPTY;
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        return annotations;
    }
}

