/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeBounds;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;
import org.jetbrains.jet.lang.types.checker.TypingConstraints;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ConstraintSystemImpl
implements ConstraintSystem {
    private final Map<TypeParameterDescriptor, TypeBoundsImpl> typeParameterBounds = Maps.newLinkedHashMap();
    private final Set<ConstraintPosition> errorConstraintPositions = Sets.newHashSet();
    private boolean hasErrorInConstrainingTypes;
    private final ConstraintSystemStatus constraintSystemStatus = new ConstraintSystemStatus(){

        @Override
        public boolean isSuccessful() {
            return !this.hasContradiction() && !this.hasUnknownParameters();
        }

        @Override
        public boolean hasContradiction() {
            return this.hasTypeConstructorMismatch() || this.hasConflictingConstraints();
        }

        @Override
        public boolean hasViolatedUpperBound() {
            if (this.isSuccessful()) {
                return false;
            }
            return ConstraintSystemImpl.this.getSystemWithoutWeakConstraints().getStatus().isSuccessful();
        }

        @Override
        public boolean hasConflictingConstraints() {
            for (TypeBoundsImpl typeBounds : ConstraintSystemImpl.this.typeParameterBounds.values()) {
                if (typeBounds.getValues().size() <= 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasUnknownParameters() {
            for (TypeBoundsImpl typeBounds : ConstraintSystemImpl.this.typeParameterBounds.values()) {
                if (!typeBounds.isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasTypeConstructorMismatch() {
            return !ConstraintSystemImpl.this.errorConstraintPositions.isEmpty();
        }

        @Override
        public boolean hasTypeConstructorMismatchAt(@NotNull ConstraintPosition constraintPosition) {
            if (constraintPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintPosition", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$1", "hasTypeConstructorMismatchAt"));
            }
            return ConstraintSystemImpl.this.errorConstraintPositions.contains(constraintPosition);
        }

        @Override
        public boolean hasOnlyErrorsFromPosition(ConstraintPosition constraintPosition) {
            if (this.isSuccessful()) {
                return false;
            }
            ConstraintSystem systemWithoutConstraintsFromPosition = ConstraintSystemImpl.this.filterConstraintsOut(constraintPosition);
            if (systemWithoutConstraintsFromPosition.getStatus().isSuccessful()) {
                return true;
            }
            return ConstraintSystemImpl.this.errorConstraintPositions.size() == 1 && ConstraintSystemImpl.this.errorConstraintPositions.contains(constraintPosition);
        }

        @Override
        public boolean hasErrorInConstrainingTypes() {
            return ConstraintSystemImpl.this.hasErrorInConstrainingTypes;
        }
    };

    @NotNull
    private static Map<TypeParameterDescriptor, TypeProjection> getParameterToInferredValueMap(@NotNull Map<TypeParameterDescriptor, TypeBoundsImpl> typeParameterBounds, @NotNull Function1<TypeParameterDescriptor, TypeProjection> getDefaultTypeProjection) {
        if (typeParameterBounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterBounds", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getParameterToInferredValueMap"));
        }
        if (getDefaultTypeProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getDefaultTypeProjection", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getParameterToInferredValueMap"));
        }
        HashMap<TypeParameterDescriptor, TypeProjection> substitutionContext = Maps.newHashMap();
        for (Map.Entry<TypeParameterDescriptor, TypeBoundsImpl> entry : typeParameterBounds.entrySet()) {
            TypeParameterDescriptor typeParameter = entry.getKey();
            TypeBounds typeBounds = entry.getValue();
            JetType value = typeBounds.getValue();
            TypeProjection typeProjection = value != null && !TypeUtils.containsSpecialType(value, TypeUtils.DONT_CARE) ? new TypeProjectionImpl(value) : getDefaultTypeProjection.invoke(typeParameter);
            substitutionContext.put(typeParameter, typeProjection);
        }
        HashMap<TypeParameterDescriptor, TypeProjection> hashMap = substitutionContext;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getParameterToInferredValueMap"));
        }
        return hashMap;
    }

    private TypeSubstitutor replaceUninferredBy(@NotNull Function1<TypeParameterDescriptor, TypeProjection> getDefaultValue) {
        if (getDefaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getDefaultValue", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "replaceUninferredBy"));
        }
        return TypeUtils.makeSubstitutorForTypeParametersMap(ConstraintSystemImpl.getParameterToInferredValueMap(this.typeParameterBounds, getDefaultValue));
    }

    private TypeSubstitutor replaceUninferredBy(final @NotNull JetType defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "replaceUninferredBy"));
        }
        return this.replaceUninferredBy(new Function1<TypeParameterDescriptor, TypeProjection>(){

            @Override
            public TypeProjection invoke(TypeParameterDescriptor descriptor) {
                return new TypeProjectionImpl(defaultValue);
            }
        });
    }

    private TypeSubstitutor replaceUninferredBySpecialErrorType() {
        return this.replaceUninferredBy(new Function1<TypeParameterDescriptor, TypeProjection>(){

            @Override
            public TypeProjection invoke(TypeParameterDescriptor descriptor) {
                return new TypeProjectionImpl(ErrorUtils.createUninferredParameterType(descriptor));
            }
        });
    }

    @Override
    @NotNull
    public ConstraintSystemStatus getStatus() {
        ConstraintSystemStatus constraintSystemStatus = this.constraintSystemStatus;
        if (constraintSystemStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getStatus"));
        }
        return constraintSystemStatus;
    }

    @Override
    public void registerTypeVariables(@NotNull Map<TypeParameterDescriptor, Variance> typeVariables) {
        if (typeVariables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeVariables", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "registerTypeVariables"));
        }
        for (Map.Entry<TypeParameterDescriptor, Variance> entry : typeVariables.entrySet()) {
            TypeParameterDescriptor typeVariable = entry.getKey();
            Variance positionVariance = entry.getValue();
            this.typeParameterBounds.put(typeVariable, new TypeBoundsImpl(typeVariable, positionVariance));
        }
        TypeSubstitutor constantSubstitutor = TypeUtils.makeConstantSubstitutor(this.typeParameterBounds.keySet(), TypeUtils.DONT_CARE);
        for (Map.Entry<TypeParameterDescriptor, TypeBoundsImpl> entry : this.typeParameterBounds.entrySet()) {
            TypeParameterDescriptor typeVariable = entry.getKey();
            TypeBoundsImpl typeBounds = entry.getValue();
            for (JetType declaredUpperBound : typeVariable.getUpperBounds()) {
                JetType substitutedBound;
                if (((Object)KotlinBuiltIns.getInstance().getNullableAnyType()).equals(declaredUpperBound) || (substitutedBound = constantSubstitutor.substitute(declaredUpperBound, Variance.INVARIANT)) == null) continue;
                typeBounds.addBound(TypeBounds.BoundKind.UPPER_BOUND, substitutedBound, ConstraintPosition.getTypeBoundPosition(typeVariable.getIndex()));
            }
        }
    }

    @Override
    @NotNull
    public ConstraintSystem copy() {
        ConstraintSystem constraintSystem = this.createNewConstraintSystemFromThis(Functions.<TypeParameterDescriptor>identity(), new Function<TypeBoundsImpl, TypeBoundsImpl>(){

            @Override
            public TypeBoundsImpl apply(TypeBoundsImpl typeBounds) {
                return typeBounds.copy();
            }
        }, Conditions.<ConstraintPosition>alwaysTrue());
        if (constraintSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "copy"));
        }
        return constraintSystem;
    }

    @NotNull
    public ConstraintSystem substituteTypeVariables(@NotNull Function<TypeParameterDescriptor, TypeParameterDescriptor> typeVariablesMap) {
        if (typeVariablesMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeVariablesMap", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "substituteTypeVariables"));
        }
        ConstraintSystem constraintSystem = this.createNewConstraintSystemFromThis(typeVariablesMap, Functions.<TypeBoundsImpl>identity(), Conditions.<ConstraintPosition>alwaysTrue());
        if (constraintSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "substituteTypeVariables"));
        }
        return constraintSystem;
    }

    @NotNull
    public ConstraintSystem filterConstraintsOut(ConstraintPosition ... excludePositions) {
        if (excludePositions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludePositions", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "filterConstraintsOut"));
        }
        final HashSet<ConstraintPosition> positions = Sets.newHashSet(excludePositions);
        ConstraintSystem constraintSystem = this.filterConstraints(new Condition<ConstraintPosition>(){

            @Override
            public boolean value(ConstraintPosition constraintPosition) {
                return !positions.contains(constraintPosition);
            }
        });
        if (constraintSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "filterConstraintsOut"));
        }
        return constraintSystem;
    }

    @NotNull
    public ConstraintSystem filterConstraints(final @NotNull Condition<ConstraintPosition> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "filterConstraints"));
        }
        ConstraintSystem constraintSystem = this.createNewConstraintSystemFromThis(Functions.<TypeParameterDescriptor>identity(), new Function<TypeBoundsImpl, TypeBoundsImpl>(){

            @Override
            public TypeBoundsImpl apply(TypeBoundsImpl typeBounds) {
                return typeBounds.filter(condition);
            }
        }, condition);
        if (constraintSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "filterConstraints"));
        }
        return constraintSystem;
    }

    @NotNull
    public ConstraintSystem getSystemWithoutWeakConstraints() {
        ConstraintSystem constraintSystem = this.filterConstraints(new Condition<ConstraintPosition>(){

            @Override
            public boolean value(ConstraintPosition constraintPosition) {
                if (constraintPosition instanceof ConstraintPosition.CompoundConstraintPosition) {
                    ConstraintPosition.CompoundConstraintPosition position = (ConstraintPosition.CompoundConstraintPosition)constraintPosition;
                    return position.consistsOfOnlyStrongConstraints();
                }
                return constraintPosition.isStrong();
            }
        });
        if (constraintSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getSystemWithoutWeakConstraints"));
        }
        return constraintSystem;
    }

    @NotNull
    private ConstraintSystem createNewConstraintSystemFromThis(@NotNull Function<TypeParameterDescriptor, TypeParameterDescriptor> substituteTypeVariable, @NotNull Function<TypeBoundsImpl, TypeBoundsImpl> replaceTypeBounds, @NotNull Condition<ConstraintPosition> filterConstraintPosition) {
        if (substituteTypeVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substituteTypeVariable", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "createNewConstraintSystemFromThis"));
        }
        if (replaceTypeBounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaceTypeBounds", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "createNewConstraintSystemFromThis"));
        }
        if (filterConstraintPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterConstraintPosition", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "createNewConstraintSystemFromThis"));
        }
        ConstraintSystemImpl newSystem = new ConstraintSystemImpl();
        for (Map.Entry<TypeParameterDescriptor, TypeBoundsImpl> entry : this.typeParameterBounds.entrySet()) {
            TypeParameterDescriptor typeParameter = entry.getKey();
            TypeBoundsImpl typeBounds = entry.getValue();
            TypeParameterDescriptor newTypeParameter = substituteTypeVariable.apply(typeParameter);
            assert (newTypeParameter != null);
            newSystem.typeParameterBounds.put(newTypeParameter, replaceTypeBounds.apply(typeBounds));
        }
        newSystem.errorConstraintPositions.addAll(ContainerUtil.filter(this.errorConstraintPositions, filterConstraintPosition));
        newSystem.hasErrorInConstrainingTypes = this.hasErrorInConstrainingTypes;
        ConstraintSystemImpl constraintSystemImpl = newSystem;
        if (constraintSystemImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "createNewConstraintSystemFromThis"));
        }
        return constraintSystemImpl;
    }

    @Override
    public void addSupertypeConstraint(@Nullable JetType constrainingType, @NotNull JetType subjectType, @NotNull ConstraintPosition constraintPosition) {
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addSupertypeConstraint"));
        }
        if (constraintPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintPosition", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addSupertypeConstraint"));
        }
        if (constrainingType != null && TypeUtils.noExpectedType(constrainingType)) {
            return;
        }
        this.addConstraint(ConstraintKind.SUB_TYPE, subjectType, constrainingType, constraintPosition);
    }

    @Override
    public void addSubtypeConstraint(@Nullable JetType constrainingType, @NotNull JetType subjectType, @NotNull ConstraintPosition constraintPosition) {
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addSubtypeConstraint"));
        }
        if (constraintPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintPosition", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addSubtypeConstraint"));
        }
        this.addConstraint(ConstraintKind.SUB_TYPE, constrainingType, subjectType, constraintPosition);
    }

    private void addConstraint(@NotNull ConstraintKind constraintKind, @Nullable JetType subType, @Nullable JetType superType, final @NotNull ConstraintPosition constraintPosition) {
        if (constraintKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintKind", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addConstraint"));
        }
        if (constraintPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintPosition", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "addConstraint"));
        }
        TypeCheckingProcedure typeCheckingProcedure = new TypeCheckingProcedure(new TypingConstraints(){

            @Override
            public boolean assertEqualTypes(@NotNull JetType a, @NotNull JetType b, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
                if (a == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$8", "assertEqualTypes"));
                }
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$8", "assertEqualTypes"));
                }
                if (typeCheckingProcedure == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCheckingProcedure", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$8", "assertEqualTypes"));
                }
                ConstraintSystemImpl.this.doAddConstraint(ConstraintKind.EQUAL, a, b, constraintPosition, typeCheckingProcedure);
                return true;
            }

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
                if (a == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$8", "assertEqualTypeConstructors"));
                }
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$8", "assertEqualTypeConstructors"));
                }
                throw new IllegalStateException("'assertEqualTypeConstructors' shouldn't be invoked inside 'isSubtypeOf'");
            }

            @Override
            public boolean assertSubtype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
                if (subtype == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$8", "assertSubtype"));
                }
                if (supertype == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$8", "assertSubtype"));
                }
                if (typeCheckingProcedure == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCheckingProcedure", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$8", "assertSubtype"));
                }
                ConstraintSystemImpl.this.doAddConstraint(ConstraintKind.SUB_TYPE, subtype, supertype, constraintPosition, typeCheckingProcedure);
                return true;
            }

            @Override
            public boolean noCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
                if (subtype == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$8", "noCorrespondingSupertype"));
                }
                if (supertype == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl$8", "noCorrespondingSupertype"));
                }
                ConstraintSystemImpl.this.errorConstraintPositions.add(constraintPosition);
                return true;
            }
        });
        this.doAddConstraint(constraintKind, subType, superType, constraintPosition, typeCheckingProcedure);
    }

    private boolean isErrorOrSpecialType(@Nullable JetType type) {
        if (type == TypeUtils.DONT_CARE || ErrorUtils.isUninferredParameter(type)) {
            return true;
        }
        if (type == null || type.isError() && type != TypeUtils.PLACEHOLDER_FUNCTION_TYPE) {
            this.hasErrorInConstrainingTypes = true;
            return true;
        }
        return false;
    }

    private void doAddConstraint(@NotNull ConstraintKind constraintKind, @Nullable JetType subType, @Nullable JetType superType, @NotNull ConstraintPosition constraintPosition, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
        if (constraintKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintKind", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "doAddConstraint"));
        }
        if (constraintPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintPosition", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "doAddConstraint"));
        }
        if (typeCheckingProcedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCheckingProcedure", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "doAddConstraint"));
        }
        if (this.isErrorOrSpecialType(subType) || this.isErrorOrSpecialType(superType)) {
            return;
        }
        assert (subType != null && superType != null);
        assert (superType != TypeUtils.PLACEHOLDER_FUNCTION_TYPE) : "The type for " + constraintPosition + " shouldn't be a placeholder for function type";
        KotlinBuiltIns kotlinBuiltIns = KotlinBuiltIns.getInstance();
        if (subType == TypeUtils.PLACEHOLDER_FUNCTION_TYPE) {
            if (!kotlinBuiltIns.isFunctionOrExtensionFunctionType(superType)) {
                if (this.isMyTypeVariable(superType)) {
                    return;
                }
                this.errorConstraintPositions.add(constraintPosition);
            }
            return;
        }
        if (constraintKind == ConstraintKind.SUB_TYPE && kotlinBuiltIns.isFunctionType(subType) && kotlinBuiltIns.isExtensionFunctionType(superType)) {
            subType = ConstraintSystemImpl.createCorrespondingExtensionFunctionType(subType, TypeUtils.DONT_CARE);
        }
        if (((Object)subType).equals(superType)) {
            return;
        }
        assert (!this.isMyTypeVariable(subType) || !this.isMyTypeVariable(superType)) : "The constraint shouldn't contain different type variables on both sides: " + subType + " <: " + superType;
        if (this.isMyTypeVariable(subType)) {
            this.generateTypeParameterConstraint(subType, superType, constraintKind == ConstraintKind.SUB_TYPE ? TypeBounds.BoundKind.UPPER_BOUND : TypeBounds.BoundKind.EXACT_BOUND, constraintPosition);
            return;
        }
        if (this.isMyTypeVariable(superType)) {
            this.generateTypeParameterConstraint(superType, subType, constraintKind == ConstraintKind.SUB_TYPE ? TypeBounds.BoundKind.LOWER_BOUND : TypeBounds.BoundKind.EXACT_BOUND, constraintPosition);
            return;
        }
        typeCheckingProcedure.isSubtypeOf(TypeUtils.makeNotNullable(subType), TypeUtils.makeNotNullable(superType));
    }

    private void generateTypeParameterConstraint(@NotNull JetType parameterType, @NotNull JetType constrainingType, @NotNull TypeBounds.BoundKind boundKind, @NotNull ConstraintPosition constraintPosition) {
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "generateTypeParameterConstraint"));
        }
        if (constrainingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constrainingType", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "generateTypeParameterConstraint"));
        }
        if (boundKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundKind", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "generateTypeParameterConstraint"));
        }
        if (constraintPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintPosition", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "generateTypeParameterConstraint"));
        }
        TypeBoundsImpl typeBounds = this.getTypeBounds(parameterType);
        assert (typeBounds != null) : "constraint should be generated only for type variables";
        if (!parameterType.isNullable() || !constrainingType.isNullable()) {
            typeBounds.addBound(boundKind, constrainingType, constraintPosition);
            return;
        }
        JetType notNullConstrainingType = TypeUtils.makeNotNullable(constrainingType);
        if (boundKind == TypeBounds.BoundKind.EXACT_BOUND || boundKind == TypeBounds.BoundKind.LOWER_BOUND) {
            typeBounds.addBound(TypeBounds.BoundKind.LOWER_BOUND, notNullConstrainingType, constraintPosition);
        }
        if (boundKind == TypeBounds.BoundKind.EXACT_BOUND || boundKind == TypeBounds.BoundKind.UPPER_BOUND) {
            typeBounds.addBound(TypeBounds.BoundKind.UPPER_BOUND, constrainingType, constraintPosition);
        }
    }

    public void processDeclaredBoundConstraints() {
        for (Map.Entry<TypeParameterDescriptor, TypeBoundsImpl> entry : this.typeParameterBounds.entrySet()) {
            TypeParameterDescriptor typeParameterDescriptor = entry.getKey();
            TypeBoundsImpl typeBounds = entry.getValue();
            for (JetType declaredUpperBound : typeParameterDescriptor.getUpperBounds()) {
                ArrayList<TypeBounds.Bound> bounds = Lists.newArrayList(typeBounds.getBounds());
                for (TypeBounds.Bound bound : bounds) {
                    if (bound.kind != TypeBounds.BoundKind.LOWER_BOUND && bound.kind != TypeBounds.BoundKind.EXACT_BOUND) continue;
                    ConstraintPosition position = ConstraintPosition.getCompoundConstraintPosition(ConstraintPosition.getTypeBoundPosition(typeParameterDescriptor.getIndex()), bound.position);
                    this.addSubtypeConstraint(bound.type, declaredUpperBound, position);
                }
                ClassifierDescriptor declarationDescriptor = declaredUpperBound.getConstructor().getDeclarationDescriptor();
                if (!(declarationDescriptor instanceof TypeParameterDescriptor) || !this.typeParameterBounds.containsKey(declarationDescriptor)) continue;
                TypeBoundsImpl typeBoundsForUpperBound = this.typeParameterBounds.get(declarationDescriptor);
                for (TypeBounds.Bound bound : typeBoundsForUpperBound.getBounds()) {
                    if (bound.kind != TypeBounds.BoundKind.UPPER_BOUND && bound.kind != TypeBounds.BoundKind.EXACT_BOUND) continue;
                    ConstraintPosition position = ConstraintPosition.getCompoundConstraintPosition(ConstraintPosition.getTypeBoundPosition(typeParameterDescriptor.getIndex()), bound.position);
                    typeBounds.addBound(TypeBounds.BoundKind.UPPER_BOUND, bound.type, position);
                }
            }
        }
    }

    @Override
    @NotNull
    public Set<TypeParameterDescriptor> getTypeVariables() {
        Set<TypeParameterDescriptor> set = this.typeParameterBounds.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getTypeVariables"));
        }
        return set;
    }

    @Override
    @NotNull
    public TypeBounds getTypeBounds(@NotNull TypeParameterDescriptor typeVariable) {
        if (typeVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeVariable", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getTypeBounds"));
        }
        TypeBoundsImpl typeBounds = this.typeParameterBounds.get(typeVariable);
        assert (typeBounds != null) : "TypeParameterDescriptor is not a type variable for constraint system: " + typeVariable;
        TypeBoundsImpl typeBoundsImpl = typeBounds;
        if (typeBoundsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getTypeBounds"));
        }
        return typeBoundsImpl;
    }

    @Nullable
    private TypeBoundsImpl getTypeBounds(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getTypeBounds"));
        }
        ClassifierDescriptor parameterDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (parameterDescriptor instanceof TypeParameterDescriptor) {
            return this.typeParameterBounds.get(parameterDescriptor);
        }
        return null;
    }

    private boolean isMyTypeVariable(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "isMyTypeVariable"));
        }
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        return descriptor instanceof TypeParameterDescriptor && this.typeParameterBounds.get(descriptor) != null;
    }

    @Override
    @NotNull
    public TypeSubstitutor getResultingSubstitutor() {
        TypeSubstitutor typeSubstitutor = this.replaceUninferredBySpecialErrorType();
        if (typeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getResultingSubstitutor"));
        }
        return typeSubstitutor;
    }

    @Override
    @NotNull
    public TypeSubstitutor getCurrentSubstitutor() {
        TypeSubstitutor typeSubstitutor = this.replaceUninferredBy(TypeUtils.DONT_CARE);
        if (typeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "getCurrentSubstitutor"));
        }
        return typeSubstitutor;
    }

    @NotNull
    public static JetType createCorrespondingExtensionFunctionType(@NotNull JetType functionType, @NotNull JetType receiverType) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "createCorrespondingExtensionFunctionType"));
        }
        if (receiverType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverType", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "createCorrespondingExtensionFunctionType"));
        }
        assert (KotlinBuiltIns.getInstance().isFunctionType(functionType));
        List<TypeProjection> typeArguments = functionType.getArguments();
        assert (!typeArguments.isEmpty());
        ArrayList<JetType> arguments = Lists.newArrayList();
        int index = 0;
        int lastIndex = typeArguments.size() - 1;
        for (TypeProjection typeArgument : typeArguments) {
            if (index < lastIndex) {
                arguments.add(typeArgument.getType());
            }
            ++index;
        }
        JetType returnType = typeArguments.get(lastIndex).getType();
        JetType jetType = KotlinBuiltIns.getInstance().getFunctionType(functionType.getAnnotations(), receiverType, arguments, returnType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintSystemImpl", "createCorrespondingExtensionFunctionType"));
        }
        return jetType;
    }

    public static enum ConstraintKind {
        SUB_TYPE,
        EQUAL;

    }
}

