/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodyResolver;
import org.jetbrains.jet.lang.resolve.DeclarationResolver;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverloadResolver;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.lazy.LazyImportScope;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class LazyTopDownAnalyzer {
    @NotNull
    private BindingTrace trace;
    @NotNull
    private DeclarationResolver declarationResolver;
    @NotNull
    private OverrideResolver overrideResolver;
    @NotNull
    private OverloadResolver overloadResolver;
    @NotNull
    private ModuleDescriptor moduleDescriptor;
    @NotNull
    private BodyResolver bodyResolver;

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "setTrace"));
        }
        this.trace = trace;
    }

    public void setDeclarationResolver(@NotNull DeclarationResolver declarationResolver) {
        if (declarationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationResolver", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "setDeclarationResolver"));
        }
        this.declarationResolver = declarationResolver;
    }

    public void setOverrideResolver(@NotNull OverrideResolver overrideResolver) {
        if (overrideResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideResolver", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "setOverrideResolver"));
        }
        this.overrideResolver = overrideResolver;
    }

    public void setOverloadResolver(@NotNull OverloadResolver overloadResolver) {
        if (overloadResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloadResolver", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "setOverloadResolver"));
        }
        this.overloadResolver = overloadResolver;
    }

    public void setModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "setModuleDescriptor"));
        }
        this.moduleDescriptor = moduleDescriptor;
    }

    public void setBodyResolver(@NotNull BodyResolver bodyResolver) {
        if (bodyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyResolver", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "setBodyResolver"));
        }
        this.bodyResolver = bodyResolver;
    }

    @NotNull
    public TopDownAnalysisContext analyzeDeclarations(final KotlinCodeAnalyzer resolveSession, @NotNull TopDownAnalysisParameters topDownAnalysisParameters, @NotNull Collection<? extends PsiElement> declarations) {
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "analyzeDeclarations"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "analyzeDeclarations"));
        }
        assert (topDownAnalysisParameters.isLazyTopDownAnalysis()) : "Lazy analyzer is run in non-lazy mode";
        final TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisParameters);
        final HashMultimap<FqName, JetElement> topLevelFqNames = HashMultimap.create();
        final ArrayList<JetProperty> properties = new ArrayList<JetProperty>();
        final ArrayList<JetNamedFunction> functions2 = new ArrayList<JetNamedFunction>();
        for (PsiElement psiElement : declarations) {
            psiElement.accept(new JetVisitorVoid(){

                private void registerDeclarations(@NotNull List<JetDeclaration> declarations) {
                    if (declarations == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "registerDeclarations"));
                    }
                    for (JetDeclaration jetDeclaration : declarations) {
                        jetDeclaration.accept(this);
                    }
                }

                @Override
                public void visitDeclaration(@NotNull JetDeclaration dcl) {
                    if (dcl == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitDeclaration"));
                    }
                    throw new IllegalArgumentException("Unsupported declaration: " + dcl + " " + dcl.getText());
                }

                @Override
                public void visitJetFile(@NotNull JetFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitJetFile"));
                    }
                    if (file.isScript()) {
                        JetScript script = file.getScript();
                        assert (script != null);
                        c.getScripts().put(script, resolveSession.getScriptDescriptor(script));
                    } else {
                        JetPackageDirective packageDirective = file.getPackageDirective();
                        assert (packageDirective != null) : "No package in a non-script file: " + file;
                        c.addFile(file);
                        packageDirective.accept(this);
                        DescriptorResolver.registerFileInPackage(LazyTopDownAnalyzer.this.trace, file);
                        this.registerDeclarations(file.getDeclarations());
                        topLevelFqNames.put(file.getPackageFqName(), packageDirective);
                    }
                }

                @Override
                public void visitPackageDirective(@NotNull JetPackageDirective directive) {
                    if (directive == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directive", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitPackageDirective"));
                    }
                    DescriptorResolver.resolvePackageHeader(directive, LazyTopDownAnalyzer.this.moduleDescriptor, LazyTopDownAnalyzer.this.trace);
                }

                @Override
                public void visitImportDirective(@NotNull JetImportDirective importDirective) {
                    if (importDirective == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitImportDirective"));
                    }
                    LazyImportScope importScope = resolveSession.getScopeProvider().getExplicitImportsScopeForFile(importDirective.getContainingJetFile());
                    importScope.forceResolveImportDirective(importDirective);
                }

                private void visitClassOrObject(@NotNull JetClassOrObject classOrObject) {
                    if (classOrObject == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitClassOrObject"));
                    }
                    ClassDescriptorWithResolutionScopes descriptor = (ClassDescriptorWithResolutionScopes)resolveSession.getClassDescriptor(classOrObject);
                    c.getDeclaredClasses().put(classOrObject, descriptor);
                    this.registerDeclarations(classOrObject.getDeclarations());
                    LazyTopDownAnalyzer.registerTopLevelFqName(topLevelFqNames, classOrObject, descriptor);
                    this.checkManyClassObjects(classOrObject);
                }

                private void checkManyClassObjects(JetClassOrObject classOrObject) {
                    boolean classObjectAlreadyFound = false;
                    for (JetDeclaration jetDeclaration : classOrObject.getDeclarations()) {
                        jetDeclaration.accept(this);
                        if (!(jetDeclaration instanceof JetClassObject)) continue;
                        if (classObjectAlreadyFound) {
                            LazyTopDownAnalyzer.this.trace.report(Errors.MANY_CLASS_OBJECTS.on((JetClassObject)jetDeclaration));
                        }
                        classObjectAlreadyFound = true;
                    }
                }

                @Override
                public void visitClass(@NotNull JetClass klass) {
                    if (klass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitClass"));
                    }
                    this.visitClassOrObject(klass);
                    this.registerPrimaryConstructorParameters(klass);
                }

                private void registerPrimaryConstructorParameters(@NotNull JetClass klass) {
                    if (klass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "registerPrimaryConstructorParameters"));
                    }
                    for (JetParameter jetParameter : klass.getPrimaryConstructorParameters()) {
                        if (jetParameter.getValOrVarNode() == null) continue;
                        c.getPrimaryConstructorParameterProperties().put(jetParameter, (PropertyDescriptor)resolveSession.resolveToDescriptor(jetParameter));
                    }
                }

                @Override
                public void visitClassObject(@NotNull JetClassObject classObject) {
                    if (classObject == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitClassObject"));
                    }
                    this.visitClassOrObject(classObject.getObjectDeclaration());
                }

                @Override
                public void visitEnumEntry(@NotNull JetEnumEntry enumEntry) {
                    if (enumEntry == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitEnumEntry"));
                    }
                    this.visitClassOrObject(enumEntry);
                }

                @Override
                public void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration) {
                    if (declaration == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitObjectDeclaration"));
                    }
                    this.visitClassOrObject(declaration);
                }

                @Override
                public void visitAnonymousInitializer(@NotNull JetClassInitializer initializer) {
                    if (initializer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitAnonymousInitializer"));
                    }
                    LazyTopDownAnalyzer.registerScope(c, resolveSession, initializer);
                    JetClassOrObject classOrObject = PsiTreeUtil.getParentOfType((PsiElement)initializer, JetClassOrObject.class);
                    c.getAnonymousInitializers().put(initializer, (ClassDescriptorWithResolutionScopes)resolveSession.resolveToDescriptor(classOrObject));
                }

                @Override
                public void visitTypedef(@NotNull JetTypedef typedef) {
                    if (typedef == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedef", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitTypedef"));
                    }
                    LazyTopDownAnalyzer.this.trace.report(Errors.UNSUPPORTED.on(typedef, "Typedefs are not supported"));
                }

                @Override
                public void visitMultiDeclaration(@NotNull JetMultiDeclaration multiDeclaration) {
                    if (multiDeclaration == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitMultiDeclaration"));
                    }
                }

                @Override
                public void visitNamedFunction(@NotNull JetNamedFunction function) {
                    if (function == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitNamedFunction"));
                    }
                    functions2.add(function);
                }

                @Override
                public void visitProperty(@NotNull JetProperty property2) {
                    if (property2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer$1", "visitProperty"));
                    }
                    properties.add(property2);
                }
            });
        }
        LazyTopDownAnalyzer.createFunctionDescriptors(c, resolveSession, functions2);
        LazyTopDownAnalyzer.createPropertyDescriptors(c, resolveSession, topLevelFqNames, properties);
        LazyTopDownAnalyzer.resolveAllHeadersInClasses(c);
        this.declarationResolver.checkRedeclarationsInPackages(resolveSession, topLevelFqNames);
        this.declarationResolver.checkRedeclarationsInInnerClassNames(c);
        this.overrideResolver.check(c);
        LazyTopDownAnalyzer.resolveImportsInAllFiles(c, resolveSession);
        this.overloadResolver.process(c);
        this.bodyResolver.resolveBodies(c);
        TopDownAnalysisContext topDownAnalysisContext = c;
        if (topDownAnalysisContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "analyzeDeclarations"));
        }
        return topDownAnalysisContext;
    }

    private static void resolveImportsInAllFiles(TopDownAnalysisContext c, KotlinCodeAnalyzer resolveSession) {
        for (JetFile file : c.getFiles()) {
            LazyTopDownAnalyzer.resolveAndCheckImports(file, resolveSession);
        }
        for (JetScript script : c.getScripts().keySet()) {
            LazyTopDownAnalyzer.resolveAndCheckImports(script.getContainingJetFile(), resolveSession);
        }
    }

    private static void resolveAllHeadersInClasses(TopDownAnalysisContext c) {
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getAllClasses()) {
            ((LazyClassDescriptor)classDescriptor).resolveMemberHeaders();
        }
    }

    private static void createPropertyDescriptors(TopDownAnalysisContext c, KotlinCodeAnalyzer resolveSession, Multimap<FqName, JetElement> topLevelFqNames, List<JetProperty> properties) {
        for (JetProperty property2 : properties) {
            PropertyDescriptor descriptor = (PropertyDescriptor)resolveSession.resolveToDescriptor(property2);
            c.getProperties().put(property2, descriptor);
            LazyTopDownAnalyzer.registerTopLevelFqName(topLevelFqNames, property2, descriptor);
            LazyTopDownAnalyzer.registerScope(c, resolveSession, property2);
            LazyTopDownAnalyzer.registerScope(c, resolveSession, property2.getGetter());
            LazyTopDownAnalyzer.registerScope(c, resolveSession, property2.getSetter());
        }
    }

    private static void createFunctionDescriptors(TopDownAnalysisContext c, KotlinCodeAnalyzer resolveSession, List<JetNamedFunction> functions2) {
        for (JetNamedFunction function : functions2) {
            c.getFunctions().put(function, (SimpleFunctionDescriptor)resolveSession.resolveToDescriptor(function));
            LazyTopDownAnalyzer.registerScope(c, resolveSession, function);
        }
    }

    private static void resolveAndCheckImports(@NotNull JetFile file, @NotNull KotlinCodeAnalyzer resolveSession) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "resolveAndCheckImports"));
        }
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "resolveAndCheckImports"));
        }
        LazyImportScope fileScope = resolveSession.getScopeProvider().getExplicitImportsScopeForFile(file);
        fileScope.forceResolveAllContents();
    }

    private static void registerScope(@NotNull TopDownAnalysisContext c, @NotNull KotlinCodeAnalyzer resolveSession, @Nullable JetDeclaration declaration) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "registerScope"));
        }
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "registerScope"));
        }
        if (declaration == null) {
            return;
        }
        c.registerDeclaringScope(declaration, resolveSession.getScopeProvider().getResolutionScopeForDeclaration(declaration));
    }

    private static void registerTopLevelFqName(@NotNull Multimap<FqName, JetElement> topLevelFqNames, @NotNull JetNamedDeclaration declaration, @NotNull DeclarationDescriptor descriptor) {
        FqName fqName;
        if (topLevelFqNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelFqNames", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "registerTopLevelFqName"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "registerTopLevelFqName"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/LazyTopDownAnalyzer", "registerTopLevelFqName"));
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor) && (fqName = declaration.getFqName()) != null) {
            topLevelFqNames.put(fqName, declaration);
        }
    }
}

