/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.Diagnostics;
import org.jetbrains.jet.lang.resolve.DiagnosticsWithSuppression;
import org.jetbrains.jet.lang.resolve.TraceEntryFilter;
import org.jetbrains.jet.util.slicedmap.MutableSlicedMap;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.SlicedMapImpl;
import org.jetbrains.jet.util.slicedmap.SlicedMapKey;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class DelegatingBindingTrace
implements BindingTrace {
    private final MutableSlicedMap map = SlicedMapImpl.create();
    private final BindingContext parentContext;
    private final List<Diagnostic> diagnostics = Lists.newArrayList();
    private final String name;
    private final BindingContext bindingContext = new BindingContext(){

        @Override
        @NotNull
        public Diagnostics getDiagnostics() {
            ArrayList<Diagnostic> mergedDiagnostics = new ArrayList<Diagnostic>(DelegatingBindingTrace.this.diagnostics);
            mergedDiagnostics.addAll(DelegatingBindingTrace.this.parentContext.getDiagnostics().noSuppression().all());
            DiagnosticsWithSuppression diagnosticsWithSuppression = new DiagnosticsWithSuppression(this, mergedDiagnostics);
            if (diagnosticsWithSuppression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace$1", "getDiagnostics"));
            }
            return diagnosticsWithSuppression;
        }

        @Override
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            return DelegatingBindingTrace.this.get(slice, key);
        }

        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            Collection<K> collection = DelegatingBindingTrace.this.getKeys(slice);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace$1", "getKeys"));
            }
            return collection;
        }

        @Override
        @NotNull
        public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
            if (slice == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace$1", "getSliceContents"));
            }
            HashMap<K, V> result2 = Maps.newHashMap();
            result2.putAll(DelegatingBindingTrace.this.parentContext.getSliceContents(slice));
            result2.putAll(DelegatingBindingTrace.this.map.getSliceContents(slice));
            ImmutableMap immutableMap = ImmutableMap.copyOf(result2);
            if (immutableMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace$1", "getSliceContents"));
            }
            return immutableMap;
        }
    };

    public DelegatingBindingTrace(BindingContext parentContext, String debugName) {
        this.parentContext = parentContext;
        this.name = debugName;
    }

    public DelegatingBindingTrace(BindingContext parentContext, String debugName, @Nullable Object resolutionSubjectForMessage) {
        this(parentContext, AnalyzingUtils.formDebugNameForBindingTrace(debugName, resolutionSubjectForMessage));
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace", "getBindingContext"));
        }
        return bindingContext;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
        this.map.put(slice, key, value);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        V value = this.map.get(slice, key);
        if (slice instanceof Slices.SetSlice) {
            assert (value != null);
            if (value.equals(true)) {
                return value;
            }
        } else if (value != null) {
            return value;
        }
        return this.parentContext.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> keys = this.map.getKeys(slice);
        Collection<K> fromParent = this.parentContext.getKeys(slice);
        if (keys.isEmpty()) {
            Collection<K> collection = fromParent;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace", "getKeys"));
            }
            return collection;
        }
        if (fromParent.isEmpty()) {
            Collection<K> collection = keys;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace", "getKeys"));
            }
            return collection;
        }
        ArrayList<K> result2 = Lists.newArrayList(keys);
        result2.addAll(fromParent);
        ArrayList<K> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace", "getKeys"));
        }
        return arrayList;
    }

    public void addAllMyDataTo(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace", "addAllMyDataTo"));
        }
        this.addAllMyDataTo(trace, null, true);
    }

    public void moveAllMyDataTo(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace", "moveAllMyDataTo"));
        }
        this.addAllMyDataTo(trace, null, true);
        this.clear();
    }

    public void addAllMyDataTo(@NotNull BindingTrace trace, @Nullable TraceEntryFilter filter, boolean commitDiagnostics) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace", "addAllMyDataTo"));
        }
        for (Map.Entry entry : this.map) {
            SlicedMapKey slicedMapKey = (SlicedMapKey)entry.getKey();
            WritableSlice slice = slicedMapKey.getSlice();
            Object key = slicedMapKey.getKey();
            Object value = entry.getValue();
            if (filter != null && !filter.accept(slice, key)) continue;
            trace.record(slice, key, value);
        }
        if (!commitDiagnostics) {
            return;
        }
        for (Diagnostic diagnostic : this.diagnostics) {
            if (filter != null && !filter.accept(null, diagnostic.getPsiElement())) continue;
            trace.report(diagnostic);
        }
    }

    public void clear() {
        this.map.clear();
        this.diagnostics.clear();
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/jet/lang/resolve/DelegatingBindingTrace", "report"));
        }
        this.diagnostics.add(diagnostic);
    }

    public String toString() {
        return this.name;
    }
}

