/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.stubs.PsiJetParameterStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiJetParameterStubImpl
extends StubBase<JetParameter>
implements PsiJetParameterStub {
    private final StringRef name;
    private final boolean isMutable;
    private final boolean isVarArg;
    private final StringRef typeText;
    private final StringRef defaultValueText;
    private final FqName fqName;

    public PsiJetParameterStubImpl(StubElement parent, FqName fqName, StringRef name, boolean isMutable, boolean isVarArg, StringRef typeText, StringRef defaultValueText) {
        super(parent, JetStubElementTypes.VALUE_PARAMETER);
        this.name = name;
        this.isMutable = isMutable;
        this.isVarArg = isVarArg;
        this.typeText = typeText;
        this.defaultValueText = defaultValueText;
        this.fqName = fqName;
    }

    public PsiJetParameterStubImpl(StubElement parent, FqName fqName, String name, boolean isMutable, boolean isVarArg, String typeText, String defaultValueText) {
        this(parent, fqName, StringRef.fromString(name), isMutable, isVarArg, StringRef.fromString(typeText), StringRef.fromString(defaultValueText));
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public boolean isVarArg() {
        return this.isVarArg;
    }

    @Override
    @Nullable
    public String getTypeText() {
        return StringRef.toString(this.typeText);
    }

    @Override
    public String getDefaultValueText() {
        return StringRef.toString(this.defaultValueText);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiJetParameterStubImpl[");
        builder.append(this.isMutable() ? "var " : "val ");
        if (this.isVarArg()) {
            builder.append("vararg ");
        }
        builder.append("name=").append(this.getName());
        if (this.fqName != null) {
            builder.append(" fqName=").append(this.fqName.toString()).append(" ");
        }
        builder.append(" typeText=").append(this.getTypeText());
        builder.append(" defaultValue=").append(this.getDefaultValueText());
        builder.append("]");
        return builder.toString();
    }

    @Override
    @Nullable
    public FqName getFqName() {
        return this.fqName;
    }
}

