/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.diagnostics.Severity;

public abstract class DiagnosticFactoryWithPsiElement<E extends PsiElement>
extends DiagnosticFactory {
    protected final PositioningStrategy<? super E> positioningStrategy;

    public DiagnosticFactoryWithPsiElement(Severity severity, PositioningStrategy<? super E> positioningStrategy) {
        super(severity);
        this.positioningStrategy = positioningStrategy;
    }

    protected List<TextRange> getTextRanges(ParametrizedDiagnostic<E> diagnostic) {
        return this.positioningStrategy.mark(diagnostic.getPsiElement());
    }

    protected boolean isValid(ParametrizedDiagnostic<E> diagnostic) {
        return this.positioningStrategy.isValid(diagnostic.getPsiElement());
    }
}

