/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationUtil;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.NamePackage;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class ResolveSessionUtils {
    public static final Name NO_NAME_FOR_LAZY_RESOLVE = Name.identifier("no_name_in_PSI_for_lazy_resolve_3d19d79d_1ba9_4cd0_b7f5_b46aa3cd5d40");
    public static final Predicate<ClassDescriptor> NON_SINGLETON_FILTER = new Predicate<ClassDescriptor>(){

        @Override
        public boolean apply(@Nullable ClassDescriptor descriptor) {
            assert (descriptor != null);
            return !descriptor.getKind().isSingleton();
        }
    };
    public static final Predicate<ClassDescriptor> SINGLETON_FILTER = new Predicate<ClassDescriptor>(){

        @Override
        public boolean apply(@Nullable ClassDescriptor descriptor) {
            assert (descriptor != null);
            return descriptor.getKind().isSingleton();
        }
    };

    private ResolveSessionUtils() {
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassDescriptorsByFqName(@NotNull KotlinCodeAnalyzer analyzer, @NotNull FqName fqName) {
        if (analyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        Collection<ClassDescriptor> collection = ResolveSessionUtils.getClassOrObjectDescriptorsByFqName(analyzer, fqName, NON_SINGLETON_FILTER);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassDescriptorsByFqName"));
        }
        return collection;
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassOrObjectDescriptorsByFqName(@NotNull KotlinCodeAnalyzer analyzer, @NotNull FqName fqName, @NotNull Predicate<ClassDescriptor> filter) {
        if (analyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        if (fqName.isRoot()) {
            List<ClassDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
            }
            return list;
        }
        ArrayList<ClassDescriptor> classDescriptors = Lists.newArrayList();
        FqName packageFqName = fqName.parent();
        while (true) {
            PackageViewDescriptor packageDescriptor;
            if ((packageDescriptor = analyzer.getModuleDescriptor().getPackage(packageFqName)) != null) {
                FqName classInPackagePath = NamePackage.tail(fqName, packageFqName);
                ClassDescriptor classDescriptor = ResolveSessionUtils.findByQualifiedName(packageDescriptor.getMemberScope(), classInPackagePath, filter);
                if (classDescriptor != null) {
                    classDescriptors.add(classDescriptor);
                }
            }
            if (packageFqName.isRoot()) break;
            packageFqName = packageFqName.parent();
        }
        ArrayList<ClassDescriptor> arrayList = classDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "getClassOrObjectDescriptorsByFqName"));
        }
        return arrayList;
    }

    @Nullable
    public static ClassDescriptor findByQualifiedName(@NotNull JetScope packageScope, @NotNull FqName path) {
        if (packageScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageScope", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "findByQualifiedName"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "findByQualifiedName"));
        }
        return ResolveSessionUtils.findByQualifiedName(packageScope, path, Predicates.<ClassDescriptor>alwaysTrue());
    }

    @Nullable
    private static ClassDescriptor findByQualifiedName(@NotNull JetScope jetScope, @NotNull FqName path, @NotNull Predicate<ClassDescriptor> filter) {
        if (jetScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetScope", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "findByQualifiedName"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "findByQualifiedName"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "findByQualifiedName"));
        }
        if (path.isRoot()) {
            return null;
        }
        if (NamePackage.isOneSegmentFQN(path)) {
            ClassDescriptor resultDescriptor;
            Name shortName = path.shortName();
            ClassifierDescriptor classifier2 = jetScope.getClassifier(shortName);
            if (classifier2 instanceof ClassDescriptor && filter.apply(resultDescriptor = (ClassDescriptor)classifier2)) {
                return resultDescriptor;
            }
            return null;
        }
        Name firstName = NamePackage.getFirstSegment(path);
        ClassifierDescriptor classifier3 = jetScope.getClassifier(firstName);
        if (classifier3 instanceof ClassDescriptor) {
            return ResolveSessionUtils.findByQualifiedName(((ClassDescriptor)classifier3).getUnsubstitutedInnerClassesScope(), NamePackage.withoutFirstSegment(path), filter);
        }
        return null;
    }

    @NotNull
    public static Name safeNameForLazyResolve(@NotNull JetNamedDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        Name name = ResolveSessionUtils.safeNameForLazyResolve(declaration.getNameAsName());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        return name;
    }

    @NotNull
    public static Name safeNameForLazyResolve(@Nullable Name name) {
        Name name2 = name != null ? name : NO_NAME_FOR_LAZY_RESOLVE;
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "safeNameForLazyResolve"));
        }
        return name2;
    }

    @Nullable
    public static FqName safeFqNameForLazyResolve(@NotNull JetNamedDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/lazy/ResolveSessionUtils", "safeFqNameForLazyResolve"));
        }
        FqName parentFqName = JetNamedDeclarationUtil.getParentFqName(declaration);
        return parentFqName != null ? parentFqName.child(ResolveSessionUtils.safeNameForLazyResolve(declaration)) : null;
    }
}

