/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.lazy.LazyEntity;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;

public class ForceResolveUtil {
    private static final Logger LOG = Logger.getInstance(ForceResolveUtil.class);

    private ForceResolveUtil() {
    }

    public static <T extends DeclarationDescriptor> T forceResolveAllContents(@NotNull T descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        LOG.debug("descriptor: " + descriptor);
        ForceResolveUtil.doForceResolveAllContents(descriptor);
        LOG.debug("<<< " + descriptor);
        return descriptor;
    }

    public static void forceResolveAllContents(@NotNull JetScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        ForceResolveUtil.forceResolveAllContents(scope.getAllDescriptors());
    }

    public static void forceResolveAllContents(@NotNull Iterable<? extends DeclarationDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            ForceResolveUtil.forceResolveAllContents(declarationDescriptor);
        }
    }

    public static void forceResolveAllContents(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        for (JetType type : types) {
            ForceResolveUtil.forceResolveAllContents(type);
        }
    }

    public static void forceResolveAllContents(@NotNull TypeConstructor typeConstructor) {
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        LOG.debug("descriptor: " + typeConstructor);
        ForceResolveUtil.doForceResolveAllContents(typeConstructor);
        LOG.debug("<<< " + typeConstructor);
    }

    public static void forceResolveAllContents(@NotNull Annotations annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/resolve/lazy/ForceResolveUtil", "forceResolveAllContents"));
        }
        ForceResolveUtil.doForceResolveAllContents(annotations);
        for (AnnotationDescriptor annotation : annotations) {
            ForceResolveUtil.doForceResolveAllContents(annotation);
        }
    }

    private static void doForceResolveAllContents(Object object2) {
        if (object2 instanceof LazyEntity) {
            LazyEntity lazyEntity = (LazyEntity)object2;
            lazyEntity.forceResolveAllContents();
        } else if (object2 instanceof CallableDescriptor) {
            CallableDescriptor callableDescriptor = (CallableDescriptor)object2;
            ForceResolveUtil.forceResolveAllContents(callableDescriptor.getReturnType());
        }
    }

    public static void forceResolveAllContents(@Nullable JetType type) {
        if (type == null) {
            return;
        }
        ForceResolveUtil.forceResolveAllContents(type.getConstructor());
        for (TypeProjection projection : type.getArguments()) {
            ForceResolveUtil.forceResolveAllContents(projection.getType());
        }
    }
}

