/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeSubstitutor;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeSubstitutorImpl;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

class PropagationHeuristics {
    static void checkArrayInReturnType(@NotNull SignaturesPropagationData data2, @NotNull JetType type, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "checkArrayInReturnType"));
        }
        List<SignaturesPropagationData.TypeAndVariance> arrayTypesFromSuper = ContainerUtil.filter(typesFromSuper, new Condition<SignaturesPropagationData.TypeAndVariance>(){

            @Override
            public boolean value(SignaturesPropagationData.TypeAndVariance typeAndVariance) {
                return typeAndVariance.type.getConstructor().getDeclarationDescriptor() == KotlinBuiltIns.getInstance().getArray();
            }
        });
        if (KotlinBuiltIns.getInstance().getArray() == type.getConstructor().getDeclarationDescriptor() && !arrayTypesFromSuper.isEmpty()) {
            assert (type.getArguments().size() == 1);
            if (type.getArguments().get(0).getProjectionKind() == Variance.INVARIANT) {
                for (SignaturesPropagationData.TypeAndVariance typeAndVariance : arrayTypesFromSuper) {
                    JetType arrayTypeFromSuper = typeAndVariance.type;
                    assert (arrayTypeFromSuper.getArguments().size() == 1);
                    JetType elementTypeInSuper = arrayTypeFromSuper.getArguments().get(0).getType();
                    JetType elementType = type.getArguments().get(0).getType();
                    if (!JetTypeChecker.INSTANCE.isSubtypeOf(elementType, elementTypeInSuper) || JetTypeChecker.INSTANCE.equalTypes(elementType, elementTypeInSuper)) continue;
                    JetTypeImpl betterTypeInSuper = new JetTypeImpl(arrayTypeFromSuper.getAnnotations(), arrayTypeFromSuper.getConstructor(), arrayTypeFromSuper.isNullable(), Arrays.asList(new TypeProjectionImpl(Variance.OUT_VARIANCE, elementTypeInSuper)), JetScope.EMPTY);
                    data2.reportError("Return type is not a subtype of overridden method. To fix it, add annotation with Kotlin signature to super method with type " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(arrayTypeFromSuper) + " replaced with " + DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(betterTypeInSuper) + " in return type");
                }
            }
        }
    }

    @Nullable
    static ClassifierDescriptor tryToFixOverridingTWithRawType(@NotNull SignaturesPropagationData data2, @NotNull List<SignaturesPropagationData.TypeAndVariance> typesFromSuper) {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "tryToFixOverridingTWithRawType"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "tryToFixOverridingTWithRawType"));
        }
        ArrayList<TypeParameterDescriptor> typeParameterClassifiersFromSuper = Lists.newArrayList();
        for (SignaturesPropagationData.TypeAndVariance typeFromSuper : typesFromSuper) {
            ClassifierDescriptor classifierFromSuper = typeFromSuper.type.getConstructor().getDeclarationDescriptor();
            if (!(classifierFromSuper instanceof TypeParameterDescriptor)) continue;
            typeParameterClassifiersFromSuper.add((TypeParameterDescriptor)classifierFromSuper);
        }
        if (!typeParameterClassifiersFromSuper.isEmpty() && typeParameterClassifiersFromSuper.size() == typesFromSuper.size()) {
            for (TypeParameterDescriptor typeParameter : typeParameterClassifiersFromSuper) {
                if (typeParameter.getContainingDeclaration() != data2.containingClass) continue;
                return typeParameter;
            }
        }
        return null;
    }

    @NotNull
    static List<JavaMethodImpl> getSuperMethods(@NotNull JavaMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "getSuperMethods"));
        }
        List<JavaMethod> list = new SuperMethodCollector(method).collect();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics", "getSuperMethods"));
        }
        return list;
    }

    private PropagationHeuristics() {
    }

    private static class SuperMethodCollector {
        private final JavaMethod initialMethod;
        private final Name initialMethodName;
        private final List<JavaType> initialParametersErasure;
        private final Set<JavaClass> visitedSuperclasses;
        private final List<JavaMethod> collectedMethods;

        private SuperMethodCollector(@NotNull JavaMethod initialMethod) {
            if (initialMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialMethod", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "<init>"));
            }
            this.visitedSuperclasses = Sets.newHashSet();
            this.collectedMethods = Lists.newArrayList();
            this.initialMethod = initialMethod;
            this.initialMethodName = initialMethod.getName();
            List<JavaValueParameter> valueParameters = initialMethod.getValueParameters();
            this.initialParametersErasure = Lists.newArrayListWithExpectedSize(valueParameters.size());
            for (JavaValueParameter parameter : valueParameters) {
                this.initialParametersErasure.add(DescriptorResolverUtils.erasure(SuperMethodCollector.varargToArray(parameter.getType(), parameter.isVararg())));
            }
        }

        @NotNull
        public List<JavaMethod> collect() {
            if (!SuperMethodCollector.canHaveSuperMethod(this.initialMethod)) {
                List<JavaMethod> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "collect"));
                }
                return list;
            }
            for (JavaClassifierType supertype : this.initialMethod.getContainingClass().getSupertypes()) {
                this.collectFromSupertype(supertype);
            }
            List<JavaMethod> list = this.collectedMethods;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "collect"));
            }
            return list;
        }

        private void collectFromSupertype(@NotNull JavaClassifierType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "collectFromSupertype"));
            }
            JavaClassifier classifier2 = type.getClassifier();
            if (!(classifier2 instanceof JavaClass)) {
                return;
            }
            JavaClass klass = (JavaClass)classifier2;
            if (!this.visitedSuperclasses.add(klass)) {
                return;
            }
            JavaTypeSubstitutor supertypeSubstitutor = SuperMethodCollector.getErasedSubstitutor(type);
            for (JavaMethod methodFromSuper : klass.getMethods()) {
                if (!this.isSubMethodOf(methodFromSuper, supertypeSubstitutor)) continue;
                this.collectedMethods.add(methodFromSuper);
                return;
            }
            for (JavaClassifierType supertype : type.getSupertypes()) {
                this.collectFromSupertype(supertype);
            }
        }

        private boolean isSubMethodOf(@NotNull JavaMethod methodFromSuper, @NotNull JavaTypeSubstitutor supertypeSubstitutor) {
            if (methodFromSuper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodFromSuper", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "isSubMethodOf"));
            }
            if (supertypeSubstitutor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypeSubstitutor", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "isSubMethodOf"));
            }
            if (!methodFromSuper.getName().equals(this.initialMethodName)) {
                return false;
            }
            List<JavaValueParameter> fromSuperParameters = methodFromSuper.getValueParameters();
            if (fromSuperParameters.size() != this.initialParametersErasure.size()) {
                return false;
            }
            Iterator<JavaType> originalIterator = this.initialParametersErasure.iterator();
            Iterator superIterator = fromSuperParameters.iterator();
            while (originalIterator.hasNext()) {
                JavaValueParameter parameterFromSuper;
                JavaType typeFromSuper;
                JavaType originalType = originalIterator.next();
                if (Comparing.equal(originalType, typeFromSuper = DescriptorResolverUtils.erasure(SuperMethodCollector.varargToArray(supertypeSubstitutor.substitute((parameterFromSuper = (JavaValueParameter)superIterator.next()).getType()), parameterFromSuper.isVararg())))) continue;
                return false;
            }
            return true;
        }

        @NotNull
        private static JavaType varargToArray(@NotNull JavaType type, boolean isVararg) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "varargToArray"));
            }
            JavaType javaType = isVararg ? ((JavaArrayType)type).getComponentType().createArrayType() : type;
            if (javaType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "varargToArray"));
            }
            return javaType;
        }

        @NotNull
        private static JavaTypeSubstitutor getErasedSubstitutor(@NotNull JavaClassifierType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "getErasedSubstitutor"));
            }
            Map<JavaTypeParameter, JavaType> unerasedMap = type.getSubstitutor().getSubstitutionMap();
            HashMap<JavaTypeParameter, JavaType> erasedMap = Maps.newHashMapWithExpectedSize(unerasedMap.size());
            for (Map.Entry<JavaTypeParameter, JavaType> entry : unerasedMap.entrySet()) {
                JavaType value = entry.getValue();
                erasedMap.put(entry.getKey(), value == null ? null : DescriptorResolverUtils.erasure(value));
            }
            JavaTypeSubstitutor javaTypeSubstitutor = JavaTypeSubstitutorImpl.create(erasedMap);
            if (javaTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "getErasedSubstitutor"));
            }
            return javaTypeSubstitutor;
        }

        private static boolean canHaveSuperMethod(@NotNull JavaMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/kotlinSignature/PropagationHeuristics$SuperMethodCollector", "canHaveSuperMethod"));
            }
            return !method.isConstructor() && !method.isStatic() && method.getVisibility() != Visibilities.PRIVATE && !DescriptorResolverUtils.OBJECT_FQ_NAME.equals(method.getContainingClass().getFqName());
        }
    }
}

