/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.codeFragmentUtil.CodeFragmentUtilPackage;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public abstract class AbstractTracingStrategy
implements TracingStrategy {
    protected final JetExpression reference;
    protected final Call call;

    protected AbstractTracingStrategy(@NotNull JetExpression reference, @NotNull Call call) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "<init>"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "<init>"));
        }
        this.reference = reference;
        this.call = call;
    }

    @Override
    public <D extends CallableDescriptor> void recordAmbiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "recordAmbiguity"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "recordAmbiguity"));
        }
        HashSet<D> descriptors = Sets.newHashSet();
        for (ResolvedCall<D> candidate : candidates) {
            descriptors.add(candidate.getCandidateDescriptor());
        }
        trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, this.reference, descriptors);
    }

    @Override
    public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "noValueForParameter"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "noValueForParameter"));
        }
        JetValueArgumentList valueArgumentList = this.call.getValueArgumentList();
        JetElement reportOn = valueArgumentList != null ? valueArgumentList : this.reference;
        trace.report(Errors.NO_VALUE_FOR_PARAMETER.on(reportOn, valueParameter));
    }

    @Override
    public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "missingReceiver"));
        }
        if (expectedReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "missingReceiver"));
        }
        trace.report(Errors.MISSING_RECEIVER.on(this.reference, expectedReceiver.getType()));
    }

    @Override
    public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "wrongReceiverType"));
        }
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "wrongReceiverType"));
        }
        if (receiverArgument2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "wrongReceiverType"));
        }
        if (receiverArgument2 instanceof ExpressionReceiver) {
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverArgument2;
            trace.report(Errors.TYPE_MISMATCH.on(expressionReceiver.getExpression(), receiverParameter.getType(), receiverArgument2.getType()));
        } else {
            trace.report(Errors.TYPE_MISMATCH.on(this.reference, receiverParameter.getType(), receiverArgument2.getType()));
        }
    }

    @Override
    public void noReceiverAllowed(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "noReceiverAllowed"));
        }
        trace.report(Errors.NO_RECEIVER_ADMITTED.on(this.reference));
    }

    @Override
    public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "wrongNumberOfTypeArguments"));
        }
        JetTypeArgumentList typeArgumentList = this.call.getTypeArgumentList();
        if (typeArgumentList != null) {
            trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(typeArgumentList, expectedTypeArgumentCount));
        } else {
            trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(this.reference, expectedTypeArgumentCount));
        }
    }

    @Override
    public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "ambiguity"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "ambiguity"));
        }
        trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "noneApplicable"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "noneApplicable"));
        }
        trace.report(Errors.NONE_APPLICABLE.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "cannotCompleteResolve"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "cannotCompleteResolve"));
        }
        trace.report(Errors.CANNOT_COMPLETE_RESOLVE.on(this.reference, descriptors));
    }

    @Override
    public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "instantiationOfAbstractClass"));
        }
        trace.report(Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(this.call.getCallElement()));
    }

    @Override
    public void unsafeCall(@NotNull BindingTrace trace, @NotNull JetType type, boolean isCallForImplicitInvoke) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "unsafeCall"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "unsafeCall"));
        }
        ASTNode callOperationNode = this.call.getCallOperationNode();
        if (callOperationNode != null && !isCallForImplicitInvoke) {
            trace.report(Errors.UNSAFE_CALL.on(callOperationNode.getPsi(), type));
        } else {
            JetElement callElement = this.call.getCallElement();
            if (callElement instanceof JetBinaryExpression) {
                JetBinaryExpression binaryExpression = (JetBinaryExpression)callElement;
                JetSimpleNameExpression operationReference = binaryExpression.getOperationReference();
                Name operationString = operationReference.getReferencedNameElementType() == JetTokens.IDENTIFIER ? Name.identifier(operationReference.getText()) : OperatorConventions.getNameForOperationSymbol((JetToken)operationReference.getReferencedNameElementType());
                JetExpression left = binaryExpression.getLeft();
                JetExpression right = binaryExpression.getRight();
                if (left != null && right != null) {
                    trace.report(Errors.UNSAFE_INFIX_CALL.on(this.reference, left.getText(), operationString.asString(), right.getText()));
                }
            } else {
                trace.report(Errors.UNSAFE_CALL.on(this.reference, type));
            }
        }
    }

    @Override
    public void unnecessarySafeCall(@NotNull BindingTrace trace, @NotNull JetType type) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "unnecessarySafeCall"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "unnecessarySafeCall"));
        }
        ASTNode callOperationNode = this.call.getCallOperationNode();
        assert (callOperationNode != null);
        trace.report(Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type));
    }

    @Override
    public void danglingFunctionLiteralArgumentSuspected(@NotNull BindingTrace trace, @NotNull List<JetExpression> functionLiteralArguments) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "danglingFunctionLiteralArgumentSuspected"));
        }
        if (functionLiteralArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteralArguments", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "danglingFunctionLiteralArgumentSuspected"));
        }
        for (JetExpression functionLiteralArgument : functionLiteralArguments) {
            trace.report(Errors.DANGLING_FUNCTION_LITERAL_ARGUMENT_SUSPECTED.on(functionLiteralArgument));
        }
    }

    @Override
    public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "invisibleMember"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "invisibleMember"));
        }
        if (!CodeFragmentUtilPackage.skipVisibilityCheck(this.call.getCallElement().getContainingJetFile())) {
            trace.report(Errors.INVISIBLE_MEMBER.on(this.call.getCallElement(), descriptor, descriptor.getVisibility(), descriptor.getContainingDeclaration()));
        }
    }

    @Override
    public void typeInferenceFailed(@NotNull BindingTrace trace, @NotNull InferenceErrorData data2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "typeInferenceFailed"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/jet/lang/resolve/calls/tasks/AbstractTracingStrategy", "typeInferenceFailed"));
        }
        ConstraintSystem constraintSystem = data2.constraintSystem;
        ConstraintSystemStatus status = constraintSystem.getStatus();
        assert (!status.isSuccessful()) : "Report error only for not successful constraint system";
        if (status.hasErrorInConstrainingTypes()) {
            return;
        }
        if (status.hasOnlyErrorsFromPosition(ConstraintPosition.EXPECTED_TYPE_POSITION)) {
            JetType declaredReturnType = data2.descriptor.getReturnType();
            if (declaredReturnType == null) {
                return;
            }
            ConstraintSystem systemWithoutExpectedTypeConstraint = ((ConstraintSystemImpl)constraintSystem).filterConstraintsOut(ConstraintPosition.EXPECTED_TYPE_POSITION);
            JetType substitutedReturnType = systemWithoutExpectedTypeConstraint.getResultingSubstitutor().substitute(declaredReturnType, Variance.INVARIANT);
            assert (substitutedReturnType != null);
            assert (!TypeUtils.noExpectedType(data2.expectedType)) : "Expected type doesn't exist, but there is an expected type mismatch error";
            trace.report(Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH.on(this.reference, data2.expectedType, substitutedReturnType));
        } else if (status.hasViolatedUpperBound()) {
            trace.report(Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.on(this.reference, data2));
        } else if (status.hasTypeConstructorMismatch()) {
            trace.report(Errors.TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH.on(this.reference, data2));
        } else if (status.hasConflictingConstraints()) {
            trace.report(Errors.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS.on(this.reference, data2));
        } else {
            assert (status.hasUnknownParameters());
            trace.report(Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER.on(this.reference, data2));
        }
    }
}

