/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.stubs.PsiJetTypeParameterStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiJetTypeParameterStubImpl
extends StubBase<JetTypeParameter>
implements PsiJetTypeParameterStub {
    private final StringRef name;
    private final StringRef extendBoundTypeText;
    private final boolean isInVariance;
    private final boolean isOutVariance;

    public PsiJetTypeParameterStubImpl(StubElement parent, StringRef name, StringRef extendBoundTypeText, boolean isInVariance, boolean isOutVariance) {
        super(parent, JetStubElementTypes.TYPE_PARAMETER);
        this.name = name;
        this.extendBoundTypeText = extendBoundTypeText;
        this.isInVariance = isInVariance;
        this.isOutVariance = isOutVariance;
    }

    public PsiJetTypeParameterStubImpl(StubElement parent, String name, String extendBoundTypeText, boolean isInVariance, boolean isOutVariance) {
        this(parent, StringRef.fromString(name), StringRef.fromString(extendBoundTypeText), isInVariance, isOutVariance);
    }

    @Override
    public String getExtendBoundTypeText() {
        return StringRef.toString(this.extendBoundTypeText);
    }

    @Override
    public boolean isInVariance() {
        return this.isInVariance;
    }

    @Override
    public boolean isOutVariance() {
        return this.isOutVariance;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiJetTypeParameterStubImpl[");
        if (this.isInVariance()) {
            builder.append("in ");
        }
        if (this.isOutVariance()) {
            builder.append("out ");
        }
        builder.append("name=").append(this.getName());
        builder.append(" extendText=").append(this.getExtendBoundTypeText());
        builder.append("]");
        return builder.toString();
    }

    @Override
    @Nullable
    public FqName getFqName() {
        return null;
    }
}

