/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.kdoc.psi.api.KDocElement;
import org.jetbrains.jet.lang.parsing.JetExpressionParsing;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPostfixExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetPsiUtil {
    public static final Predicate<JetElement> ANY_JET_ELEMENT = new Predicate<JetElement>(){

        @Override
        public boolean apply(@Nullable JetElement input) {
            return true;
        }
    };

    private JetPsiUtil() {
    }

    public static <D> void visitChildren(@NotNull JetElement element, @NotNull JetTreeVisitor<D> visitor, D data2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil", "visitChildren"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetPsiUtil", "visitChildren"));
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof JetElement)) continue;
            ((JetElement)child).accept(visitor, data2);
        }
    }

    @NotNull
    public static JetExpression safeDeparenthesize(@NotNull JetExpression expression, boolean deparenthesizeBinaryExpressionWithTypeRHS) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "safeDeparenthesize"));
        }
        JetExpression deparenthesized = JetPsiUtil.deparenthesize(expression, deparenthesizeBinaryExpressionWithTypeRHS);
        JetExpression jetExpression = deparenthesized != null ? deparenthesized : expression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "safeDeparenthesize"));
        }
        return jetExpression;
    }

    @Nullable
    public static JetExpression deparenthesize(@Nullable JetExpression expression) {
        return JetPsiUtil.deparenthesize(expression, true);
    }

    @Nullable
    public static JetExpression deparenthesize(@Nullable JetExpression expression, boolean deparenthesizeBinaryExpressionWithTypeRHS) {
        return JetPsiUtil.deparenthesizeWithResolutionStrategy(expression, deparenthesizeBinaryExpressionWithTypeRHS, null);
    }

    @Deprecated
    @Nullable
    public static JetExpression deparenthesizeWithResolutionStrategy(@Nullable JetExpression expression, boolean deparenthesizeBinaryExpressionWithTypeRHS, @Nullable Function<JetTypeReference, Void> typeResolutionStrategy) {
        if (deparenthesizeBinaryExpressionWithTypeRHS && expression instanceof JetBinaryExpressionWithTypeRHS) {
            JetBinaryExpressionWithTypeRHS binaryExpression = (JetBinaryExpressionWithTypeRHS)expression;
            JetSimpleNameExpression operationSign = binaryExpression.getOperationReference();
            if (JetTokens.COLON.equals(operationSign.getReferencedNameElementType())) {
                expression = binaryExpression.getLeft();
                JetTypeReference typeReference = binaryExpression.getRight();
                if (typeResolutionStrategy != null && typeReference != null) {
                    typeResolutionStrategy.apply(typeReference);
                }
            }
        } else if (expression instanceof JetPrefixExpression) {
            JetExpression baseExpression = JetPsiUtil.getBaseExpressionIfLabeledExpression((JetPrefixExpression)expression);
            if (baseExpression != null) {
                expression = baseExpression;
            }
        } else if (expression instanceof JetExpressionWrapper) {
            expression = ((JetExpressionWrapper)((Object)expression)).getBaseExpression();
        }
        if (expression instanceof JetParenthesizedExpression) {
            JetExpression innerExpression = ((JetParenthesizedExpression)expression).getExpression();
            return innerExpression != null ? JetPsiUtil.deparenthesizeWithResolutionStrategy(innerExpression, deparenthesizeBinaryExpressionWithTypeRHS, typeResolutionStrategy) : null;
        }
        return expression;
    }

    @Nullable
    public static JetExpression getBaseExpressionIfLabeledExpression(@NotNull JetPrefixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getBaseExpressionIfLabeledExpression"));
        }
        if (JetPsiUtil.isLabeledExpression(expression)) {
            return expression.getBaseExpression();
        }
        return null;
    }

    public static boolean isLabeledExpression(JetPrefixExpression expression) {
        return JetTokens.LABELS.contains(expression.getOperationReference().getReferencedNameElementType());
    }

    @NotNull
    public static Name safeName(@Nullable String name) {
        Name name2 = name == null ? SpecialNames.NO_NAME_PROVIDED : Name.identifier(name);
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "safeName"));
        }
        return name2;
    }

    @NotNull
    public static Set<JetElement> findRootExpressions(@NotNull Collection<JetElement> unreachableElements) {
        if (unreachableElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unreachableElements", "org/jetbrains/jet/lang/psi/JetPsiUtil", "findRootExpressions"));
        }
        HashSet<JetElement> rootElements = new HashSet<JetElement>();
        final HashSet shadowedElements = new HashSet();
        JetVisitorVoid shadowAllChildren = new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil$1", "visitJetElement"));
                }
                if (shadowedElements.add(element)) {
                    element.acceptChildren(this);
                }
            }
        };
        for (JetElement element : unreachableElements) {
            if (shadowedElements.contains(element)) continue;
            element.acceptChildren(shadowAllChildren);
            rootElements.removeAll(shadowedElements);
            rootElements.add(element);
        }
        HashSet<JetElement> hashSet = rootElements;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "findRootExpressions"));
        }
        return hashSet;
    }

    @NotNull
    public static String unquoteIdentifier(@NotNull String quoted) {
        if (quoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "org/jetbrains/jet/lang/psi/JetPsiUtil", "unquoteIdentifier"));
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "unquoteIdentifier"));
            }
            return string;
        }
        if (quoted.startsWith("`") && quoted.endsWith("`") && quoted.length() >= 2) {
            String string = quoted.substring(1, quoted.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "unquoteIdentifier"));
            }
            return string;
        }
        String string = quoted;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "unquoteIdentifier"));
        }
        return string;
    }

    @NotNull
    public static String unquoteIdentifierOrFieldReference(@NotNull String quoted) {
        if (quoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "org/jetbrains/jet/lang/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
            }
            return string;
        }
        if (quoted.startsWith("$")) {
            String string = "$" + JetPsiUtil.unquoteIdentifier(quoted.substring(1));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
            }
            return string;
        }
        String string = JetPsiUtil.unquoteIdentifier(quoted);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
        }
        return string;
    }

    @Nullable
    public static FqName toQualifiedName(@NotNull JetUserType userType) {
        if (userType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userType", "org/jetbrains/jet/lang/psi/JetPsiUtil", "toQualifiedName"));
        }
        ArrayList<String> reversedNames = Lists.newArrayList();
        for (JetUserType current = userType; current != null; current = current.getQualifier()) {
            String name = current.getReferencedName();
            if (name == null) {
                return null;
            }
            reversedNames.add(name);
        }
        return FqName.fromSegments(ContainerUtil.reverse(reversedNames));
    }

    @Nullable
    public static Name getShortName(@NotNull JetAnnotationEntry annotation) {
        JetUserType userType;
        String shortName;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getShortName"));
        }
        JetTypeReference typeReference = annotation.getTypeReference();
        assert (typeReference != null) : "Annotation entry hasn't typeReference " + annotation.getText();
        JetTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement instanceof JetUserType && (shortName = (userType = (JetUserType)typeElement).getReferencedName()) != null) {
            return Name.identifier(shortName);
        }
        return null;
    }

    public static boolean isDeprecated(@NotNull JetModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isDeprecated"));
        }
        JetModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            List<JetAnnotationEntry> annotationEntries = modifierList.getAnnotationEntries();
            for (JetAnnotationEntry annotation : annotationEntries) {
                Name shortName = JetPsiUtil.getShortName(annotation);
                if (!KotlinBuiltIns.getInstance().getDeprecatedAnnotation().getName().equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    @IfNotParsed
    @Nullable
    public static ImportPath getImportPath(@NotNull JetImportDirective importDirective) {
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getImportPath"));
        }
        if (PsiTreeUtil.hasErrorElements(importDirective)) {
            return null;
        }
        FqName importFqn = JetPsiUtil.getFQName(importDirective.getImportedReference());
        if (importFqn == null) {
            return null;
        }
        Name alias = null;
        String aliasName = importDirective.getAliasName();
        if (aliasName != null) {
            alias = Name.identifier(aliasName);
        }
        return new ImportPath(importFqn, importDirective.isAllUnder(), alias);
    }

    @Nullable
    public static <T extends PsiElement> T getDirectParentOfTypeForBlock(@NotNull JetBlockExpression block, @NotNull Class<T> aClass) {
        JetFunctionLiteral functionLiteral;
        JetIfExpression ifExpression;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getDirectParentOfTypeForBlock"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getDirectParentOfTypeForBlock"));
        }
        T parent = PsiTreeUtil.getParentOfType((PsiElement)block, aClass);
        if (parent instanceof JetIfExpression && ((ifExpression = (JetIfExpression)parent).getElse() == block || ifExpression.getThen() == block)) {
            return parent;
        }
        if (parent instanceof JetWhenExpression) {
            JetWhenExpression whenExpression = (JetWhenExpression)parent;
            for (JetWhenEntry whenEntry : whenExpression.getEntries()) {
                if (whenEntry.getExpression() != block) continue;
                return parent;
            }
        }
        if (parent instanceof JetFunctionLiteral && (functionLiteral = (JetFunctionLiteral)parent).getBodyExpression() == block) {
            return parent;
        }
        if (parent instanceof JetTryExpression) {
            JetTryExpression tryExpression = (JetTryExpression)parent;
            if (tryExpression.getTryBlock() == block) {
                return parent;
            }
            for (JetCatchClause clause : tryExpression.getCatchClauses()) {
                if (clause.getCatchBody() != block) continue;
                return parent;
            }
        }
        return null;
    }

    public static boolean isImplicitlyUsed(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isImplicitlyUsed"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JetBlockExpression)) {
            return true;
        }
        JetBlockExpression block = (JetBlockExpression)parent;
        List<JetElement> statements = block.getStatements();
        if (statements.get(statements.size() - 1) == element) {
            JetExpression expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetIfExpression.class);
            if (expression == null) {
                expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetWhenExpression.class);
            }
            if (expression == null) {
                expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetFunctionLiteral.class);
            }
            if (expression == null) {
                expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetTryExpression.class);
            }
            if (expression != null) {
                return JetPsiUtil.isImplicitlyUsed(expression);
            }
        }
        return false;
    }

    public static void deleteClass(@NotNull JetClassOrObject clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/jet/lang/psi/JetPsiUtil", "deleteClass"));
        }
        CheckUtil.checkWritable(clazz);
        JetFile file = clazz.getContainingJetFile();
        if (JetPsiUtil.isLocal(clazz) || file.getDeclarations().size() > 1) {
            PsiElement parent = clazz.getParent();
            CodeEditUtil.removeChild(parent.getNode(), clazz.getNode());
        } else {
            file.delete();
        }
    }

    @Nullable
    public static Name getAliasName(@NotNull JetImportDirective importDirective) {
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getAliasName"));
        }
        String aliasName = importDirective.getAliasName();
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return null;
        }
        JetSimpleNameExpression referenceExpression = JetPsiUtil.getLastReference(importedReference);
        if (aliasName == null) {
            aliasName = referenceExpression != null ? referenceExpression.getReferencedName() : null;
        }
        return aliasName != null && !aliasName.isEmpty() ? Name.identifier(aliasName) : null;
    }

    @Nullable
    public static JetSimpleNameExpression getLastReference(@NotNull JetExpression importedReference) {
        if (importedReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedReference", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getLastReference"));
        }
        JetElement selector = PsiUtilPackage.getQualifiedElementSelector(importedReference);
        return selector instanceof JetSimpleNameExpression ? (JetSimpleNameExpression)selector : null;
    }

    public static boolean isSelectorInQualified(@NotNull JetSimpleNameExpression nameExpression) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isSelectorInQualified"));
        }
        JetElement qualifiedElement = PsiUtilPackage.getQualifiedElement(nameExpression);
        return qualifiedElement instanceof JetQualifiedExpression || qualifiedElement instanceof JetUserType && ((JetUserType)qualifiedElement).getQualifier() != null;
    }

    public static boolean isLHSOfDot(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isLHSOfDot"));
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof JetQualifiedExpression)) {
            return false;
        }
        JetQualifiedExpression qualifiedParent = (JetQualifiedExpression)parent;
        return qualifiedParent.getReceiverExpression() == expression || JetPsiUtil.isLHSOfDot(qualifiedParent);
    }

    public static boolean isVoidType(@Nullable JetTypeReference typeReference) {
        if (typeReference == null) {
            return false;
        }
        return KotlinBuiltIns.getInstance().getUnit().getName().asString().equals(typeReference.getText());
    }

    public static boolean isSafeCall(@NotNull Call call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isSafeCall"));
        }
        ASTNode callOperationNode = call.getCallOperationNode();
        return callOperationNode != null && callOperationNode.getElementType() == JetTokens.SAFE_ACCESS;
    }

    public static boolean isScriptDeclaration(@NotNull JetDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isScriptDeclaration"));
        }
        return JetPsiUtil.getScript(namedDeclaration) != null;
    }

    @Nullable
    public static JetScript getScript(@NotNull JetDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getScript"));
        }
        PsiElement parent = namedDeclaration.getParent();
        if (parent != null && parent.getParent() instanceof JetScript) {
            return (JetScript)parent.getParent();
        }
        return null;
    }

    public static boolean isVariableNotParameterDeclaration(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isVariableNotParameterDeclaration"));
        }
        if (!(declaration instanceof JetVariableDeclaration)) {
            return false;
        }
        if (declaration instanceof JetProperty) {
            return true;
        }
        assert (declaration instanceof JetMultiDeclarationEntry);
        JetMultiDeclarationEntry multiDeclarationEntry = (JetMultiDeclarationEntry)declaration;
        return !(multiDeclarationEntry.getParent().getParent() instanceof JetForExpression);
    }

    @Nullable
    public static Name getConventionName(@NotNull JetSimpleNameExpression simpleNameExpression) {
        IElementType elementType;
        if (simpleNameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleNameExpression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getConventionName"));
        }
        if (simpleNameExpression.getIdentifier() != null) {
            return simpleNameExpression.getReferencedNameAsName();
        }
        PsiElement firstChild = simpleNameExpression.getFirstChild();
        if (firstChild != null && (elementType = firstChild.getNode().getElementType()) instanceof JetToken) {
            JetToken jetToken = (JetToken)elementType;
            return OperatorConventions.getNameForOperationSymbol(jetToken);
        }
        return null;
    }

    @Nullable
    public static PsiElement getTopmostParentOfTypes(@Nullable PsiElement element, Class<? extends PsiElement> ... parentTypes) {
        if (parentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentTypes", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getTopmostParentOfTypes"));
        }
        if (element == null) {
            return null;
        }
        PsiElement result2 = null;
        for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            if (!PsiTreeUtil.instanceOf(parent, parentTypes)) continue;
            result2 = parent;
        }
        return result2;
    }

    public static boolean isNullConstant(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isNullConstant"));
        }
        JetExpression deparenthesized = JetPsiUtil.deparenthesize(expression);
        return deparenthesized instanceof JetConstantExpression && deparenthesized.getNode().getElementType() == JetNodeTypes.NULL;
    }

    public static boolean isAbstract(@NotNull JetDeclarationWithBody declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isAbstract"));
        }
        return declaration.getBodyExpression() == null;
    }

    public static boolean isBackingFieldReference(@NotNull JetSimpleNameExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isBackingFieldReference"));
        }
        return expression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER;
    }

    public static boolean isBackingFieldReference(@Nullable JetElement element) {
        return element instanceof JetSimpleNameExpression && JetPsiUtil.isBackingFieldReference((JetSimpleNameExpression)element);
    }

    @Nullable
    private static FqName getFQName(@Nullable JetExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JetDotQualifiedExpression) {
            JetDotQualifiedExpression dotQualifiedExpression = (JetDotQualifiedExpression)expression;
            FqName parentFqn = JetPsiUtil.getFQName(dotQualifiedExpression.getReceiverExpression());
            Name child = JetPsiUtil.getName(dotQualifiedExpression.getSelectorExpression());
            return parentFqn != null && child != null ? parentFqn.child(child) : null;
        }
        if (expression instanceof JetSimpleNameExpression) {
            JetSimpleNameExpression simpleNameExpression = (JetSimpleNameExpression)expression;
            return FqName.topLevel(simpleNameExpression.getReferencedNameAsName());
        }
        throw new IllegalArgumentException("Can't construct fqn for: " + expression.getClass().toString());
    }

    @Nullable
    private static Name getName(@Nullable JetExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JetSimpleNameExpression) {
            return ((JetSimpleNameExpression)expression).getReferencedNameAsName();
        }
        throw new IllegalArgumentException("Can't construct name for: " + expression.getClass().toString());
    }

    @Nullable
    public static JetElement getLastStatementInABlock(@Nullable JetBlockExpression blockExpression) {
        if (blockExpression == null) {
            return null;
        }
        List<JetElement> statements = blockExpression.getStatements();
        return statements.isEmpty() ? null : statements.get(statements.size() - 1);
    }

    public static boolean isTrait(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isTrait"));
        }
        return classOrObject instanceof JetClass && ((JetClass)classOrObject).isTrait();
    }

    @Nullable
    public static JetClassOrObject getOutermostClassOrObject(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getOutermostClassOrObject"));
        }
        JetClassOrObject current = classOrObject;
        while (true) {
            PsiElement parent = current.getParent();
            assert (classOrObject.getParent() != null) : "Class with no parent: " + classOrObject.getText();
            if (parent instanceof PsiFile) {
                return current;
            }
            if (parent instanceof JetClassObject) {
                parent = parent.getParent();
                assert (parent instanceof JetClassBody) : "Parent of class object is not a class body: " + parent;
            }
            if (!(parent instanceof JetClassBody)) {
                return current;
            }
            current = (JetClassOrObject)parent.getParent();
        }
    }

    @Nullable
    public static JetClass getClassIfParameterIsProperty(@NotNull JetParameter jetParameter) {
        PsiElement parent;
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getClassIfParameterIsProperty"));
        }
        if (jetParameter.getValOrVarNode() != null && (parent = jetParameter.getParent()) instanceof JetParameterList && parent.getParent() instanceof JetClass) {
            return (JetClass)parent.getParent();
        }
        return null;
    }

    @Nullable
    private static IElementType getOperation(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getOperation"));
        }
        if (expression instanceof JetQualifiedExpression) {
            return ((JetQualifiedExpression)expression).getOperationSign();
        }
        if (expression instanceof JetOperationExpression) {
            return ((JetOperationExpression)((Object)expression)).getOperationReference().getReferencedNameElementType();
        }
        return null;
    }

    private static int getPriority(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getPriority"));
        }
        int maxPriority = JetExpressionParsing.Precedence.values().length + 1;
        if (expression instanceof JetPostfixExpression || expression instanceof JetQualifiedExpression || expression instanceof JetCallExpression || expression instanceof JetArrayAccessExpression) {
            return maxPriority - 1;
        }
        if (expression instanceof JetPrefixExpression) {
            return maxPriority - 2;
        }
        if (expression instanceof JetDeclaration || expression instanceof JetStatementExpression || expression instanceof JetIfExpression) {
            return 0;
        }
        IElementType operation = JetPsiUtil.getOperation(expression);
        for (JetExpressionParsing.Precedence precedence : JetExpressionParsing.Precedence.values()) {
            if (precedence == JetExpressionParsing.Precedence.PREFIX || precedence == JetExpressionParsing.Precedence.POSTFIX || !precedence.getOperations().contains(operation)) continue;
            return maxPriority - precedence.ordinal() - 1;
        }
        return maxPriority;
    }

    public static boolean areParenthesesUseless(@NotNull JetParenthesizedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "areParenthesesUseless"));
        }
        JetExpression innerExpression = expression.getExpression();
        if (innerExpression == null) {
            return true;
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof JetExpression)) {
            return true;
        }
        return !JetPsiUtil.areParenthesesNecessary(innerExpression, expression, (JetExpression)parent);
    }

    public static boolean areParenthesesNecessary(@NotNull JetExpression innerExpression, @NotNull JetExpression currentInner, @NotNull JetExpression parentExpression) {
        int parentPriority;
        if (innerExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerExpression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "areParenthesesNecessary"));
        }
        if (currentInner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInner", "org/jetbrains/jet/lang/psi/JetPsiUtil", "areParenthesesNecessary"));
        }
        if (parentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentExpression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "areParenthesesNecessary"));
        }
        if (parentExpression instanceof JetParenthesizedExpression || innerExpression instanceof JetParenthesizedExpression) {
            return false;
        }
        if (parentExpression instanceof JetPackageDirective) {
            return false;
        }
        if (parentExpression instanceof JetWhenExpression || innerExpression instanceof JetWhenExpression) {
            return false;
        }
        if (innerExpression instanceof JetIfExpression) {
            PsiElement current = parentExpression;
            while (!(current instanceof JetBlockExpression || current instanceof JetDeclaration || current instanceof JetStatementExpression)) {
                if (current.getTextRange().getEndOffset() != currentInner.getTextRange().getEndOffset()) {
                    return current.getText().charAt(current.getTextLength() - 1) != ')';
                }
                current = current.getParent();
            }
        }
        IElementType innerOperation = JetPsiUtil.getOperation(innerExpression);
        IElementType parentOperation = JetPsiUtil.getOperation(parentExpression);
        if (parentExpression instanceof JetReturnExpression && innerOperation == JetTokens.LABEL_IDENTIFIER) {
            return true;
        }
        if (innerExpression instanceof JetBinaryExpressionWithTypeRHS && parentOperation == JetTokens.LT) {
            return true;
        }
        int innerPriority = JetPsiUtil.getPriority(innerExpression);
        if (innerPriority == (parentPriority = JetPsiUtil.getPriority(parentExpression))) {
            if (parentExpression instanceof JetBinaryExpression) {
                if (innerOperation == JetTokens.ANDAND || innerOperation == JetTokens.OROR) {
                    return false;
                }
                return ((JetBinaryExpression)parentExpression).getRight() == currentInner;
            }
            if (parentExpression instanceof JetPrefixExpression && innerExpression instanceof JetPrefixExpression) {
                return innerOperation == parentOperation && (innerOperation == JetTokens.PLUS || innerOperation == JetTokens.MINUS);
            }
            return false;
        }
        return innerPriority < parentPriority;
    }

    public static boolean isAssignment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isAssignment"));
        }
        return element instanceof JetBinaryExpression && JetTokens.ALL_ASSIGNMENTS.contains(((JetBinaryExpression)element).getOperationToken());
    }

    public static boolean isOrdinaryAssignment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isOrdinaryAssignment"));
        }
        return element instanceof JetBinaryExpression && ((JetBinaryExpression)element).getOperationToken().equals(JetTokens.EQ);
    }

    @Nullable
    public static JetElement getOutermostLastBlockElement(@Nullable JetElement element, @NotNull Predicate<JetElement> checkElement) {
        if (checkElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkElement", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getOutermostLastBlockElement"));
        }
        if (element == null) {
            return null;
        }
        if (!(element instanceof JetBlockExpression)) {
            return checkElement.apply(element) ? element : null;
        }
        JetBlockExpression block = (JetBlockExpression)element;
        int n = block.getStatements().size();
        if (n == 0) {
            return null;
        }
        JetElement lastElement = block.getStatements().get(n - 1);
        return checkElement.apply(lastElement) ? lastElement : null;
    }

    public static boolean checkVariableDeclarationInBlock(@NotNull JetBlockExpression block, @NotNull String varName) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/jet/lang/psi/JetPsiUtil", "checkVariableDeclarationInBlock"));
        }
        if (varName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varName", "org/jetbrains/jet/lang/psi/JetPsiUtil", "checkVariableDeclarationInBlock"));
        }
        for (JetElement element : block.getStatements()) {
            if (!(element instanceof JetVariableDeclaration) || !((JetVariableDeclaration)element).getNameAsSafeName().asString().equals(varName)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWhenExpressionHasSingleElse(@NotNull JetWhenExpression whenExpression) {
        if (whenExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "checkWhenExpressionHasSingleElse"));
        }
        int elseCount = 0;
        for (JetWhenEntry entry : whenExpression.getEntries()) {
            if (!entry.isElse()) continue;
            ++elseCount;
        }
        return elseCount == 1;
    }

    @Nullable
    public static PsiElement skipTrailingWhitespacesAndComments(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward(element, PsiWhiteSpace.class, PsiComment.class);
    }

    @NotNull
    public static String getText(@Nullable PsiElement element) {
        String string = element != null ? element.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getText"));
        }
        return string;
    }

    @Nullable
    public static String getNullableText(@Nullable PsiElement element) {
        return element != null ? element.getText() : null;
    }

    public static boolean isInComment(PsiElement element) {
        return CommentUtilCore.isComment(element) || element instanceof KDocElement;
    }

    @Nullable
    public static PsiElement getOutermostParent(@NotNull PsiElement element, @NotNull PsiElement upperBound, boolean strict) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getOutermostParent"));
        }
        if (upperBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperBound", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getOutermostParent"));
        }
        PsiElement psiElement = parent = strict ? element.getParent() : element;
        while (parent != null && parent.getParent() != upperBound) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static <T extends PsiElement> T getLastChildByType(@NotNull PsiElement root, Class<? extends T> ... elementTypes) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getLastChildByType"));
        }
        if (elementTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementTypes", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getLastChildByType"));
        }
        PsiElement[] children = root.getChildren();
        for (int i = children.length - 1; i >= 0; --i) {
            if (!PsiTreeUtil.instanceOf(children[i], elementTypes)) continue;
            return (T)children[i];
        }
        return null;
    }

    @Nullable
    public static JetElement getOutermostDescendantElement(@Nullable PsiElement root, boolean first, final @NotNull Predicate<JetElement> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getOutermostDescendantElement"));
        }
        if (!(root instanceof JetElement)) {
            return null;
        }
        final ArrayList results = Lists.newArrayList();
        root.accept(new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil$3", "visitJetElement"));
                }
                if (predicate.apply(element)) {
                    results.add(element);
                } else {
                    element.acceptChildren(this);
                }
            }
        });
        if (results.isEmpty()) {
            return null;
        }
        return first ? (JetElement)results.get(0) : (JetElement)results.get(results.size() - 1);
    }

    @Nullable
    public static PsiElement findChildByType(@NotNull PsiElement element, @NotNull IElementType type) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil", "findChildByType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/psi/JetPsiUtil", "findChildByType"));
        }
        ASTNode node = element.getNode().findChildByType(type);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public static JetExpression getCalleeExpressionIfAny(@NotNull JetExpression expression) {
        JetExpression selectorExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getCalleeExpressionIfAny"));
        }
        if (expression instanceof JetSimpleNameExpression) {
            return expression;
        }
        if (expression instanceof JetCallElement) {
            JetCallElement callExpression = (JetCallElement)((Object)expression);
            return callExpression.getCalleeExpression();
        }
        if (expression instanceof JetQualifiedExpression && (selectorExpression = ((JetQualifiedExpression)expression).getSelectorExpression()) != null) {
            return JetPsiUtil.getCalleeExpressionIfAny(selectorExpression);
        }
        if (expression instanceof JetUnaryExpression) {
            return ((JetUnaryExpression)expression).getOperationReference();
        }
        if (expression instanceof JetBinaryExpression) {
            return ((JetBinaryExpression)expression).getOperationReference();
        }
        return null;
    }

    @Nullable
    public static PsiElement skipSiblingsBackwardByPredicate(@Nullable PsiElement element, Predicate<PsiElement> elementsToSkip) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (elementsToSkip.apply(e)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    public static PsiElement skipSiblingsForwardByPredicate(@Nullable PsiElement element, Predicate<PsiElement> elementsToSkip) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (elementsToSkip.apply(e)) continue;
            return e;
        }
        return null;
    }

    public static void deleteElementWithDelimiters(@NotNull PsiElement element) {
        PsiElement to;
        PsiElement from;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil", "deleteElementWithDelimiters"));
        }
        Object paramBefore = PsiTreeUtil.getPrevSiblingOfType(element, element.getClass());
        if (paramBefore != null) {
            from = paramBefore.getNextSibling();
            to = element;
        } else {
            Object paramAfter = PsiTreeUtil.getNextSiblingOfType(element, element.getClass());
            from = element;
            to = paramAfter != null ? paramAfter.getPrevSibling() : element;
        }
        PsiElement parent = element.getParent();
        parent.deleteChildRange(from, to);
    }

    public static <T extends PsiElement> void deleteChildlessElement(PsiElement element, Class<T> childClass) {
        if (PsiTreeUtil.getChildrenOfType((PsiElement)element, childClass) == null) {
            element.delete();
        }
    }

    public static PsiElement ascendIfPropertyAccessor(PsiElement element) {
        if (element instanceof JetPropertyAccessor) {
            return element.getParent();
        }
        return element;
    }

    @NotNull
    public static String getElementTextWithContext(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getElementTextWithContext"));
        }
        if (element instanceof JetFile) {
            String string = element.getContainingFile().getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getElementTextWithContext"));
            }
            return string;
        }
        PsiElement inFileParent = PsiTreeUtil.findFirstParent(element, new Condition<PsiElement>(){

            @Override
            public boolean value(PsiElement parentCandidate) {
                return parentCandidate != null && parentCandidate.getParent() instanceof JetFile;
            }
        });
        assert (inFileParent != null) : "For non-file element we should always be able to find parent in file children";
        int startContextOffset = inFileParent.getTextRange().getStartOffset();
        int elementContextOffset = element.getTextRange().getStartOffset();
        int inFileParentOffset = elementContextOffset - startContextOffset;
        String string = new StringBuilder(inFileParent.getText()).insert(inFileParentOffset, "<caret>").toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getElementTextWithContext"));
        }
        return string;
    }

    @Nullable
    public static JetModifierList replaceModifierList(@NotNull JetModifierListOwner owner, @Nullable JetModifierList modifierList) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/psi/JetPsiUtil", "replaceModifierList"));
        }
        JetModifierList oldModifierList = owner.getModifierList();
        if (modifierList == null) {
            if (oldModifierList != null) {
                oldModifierList.delete();
            }
            return null;
        }
        if (oldModifierList == null) {
            PsiElement firstChild = owner.getFirstChild();
            return (JetModifierList)owner.addBefore(modifierList, firstChild);
        }
        return (JetModifierList)oldModifierList.replace(modifierList);
    }

    @Nullable
    public static String getPackageName(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getPackageName"));
        }
        JetFile file = element.getContainingJetFile();
        JetPackageDirective header = PsiTreeUtil.findChildOfType(file, JetPackageDirective.class);
        return header != null ? header.getQualifiedName() : null;
    }

    @Nullable
    public static JetElement getEnclosingElementForLocalDeclaration(@Nullable JetDeclaration declaration) {
        PsiElement parent;
        if (declaration instanceof JetTypeParameter) {
            declaration = PsiTreeUtil.getParentOfType((PsiElement)declaration, JetNamedDeclaration.class);
        } else if (declaration instanceof JetParameter && (parent = declaration.getParent()) != null && parent.getParent() instanceof JetNamedFunction) {
            declaration = (JetNamedFunction)parent.getParent();
        }
        JetElement container = (JetElement)PsiTreeUtil.getParentOfType((PsiElement)declaration, JetBlockExpression.class, JetClassInitializer.class, JetProperty.class, JetFunction.class, JetParameter.class);
        if (container == null) {
            return null;
        }
        return container instanceof JetClassInitializer ? ((JetClassInitializer)container).getBody() : container;
    }

    public static boolean isLocal(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/psi/JetPsiUtil", "isLocal"));
        }
        return JetPsiUtil.getEnclosingElementForLocalDeclaration(declaration) != null;
    }

    @Nullable
    public static JetToken getOperationToken(@NotNull JetOperationExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/psi/JetPsiUtil", "getOperationToken"));
        }
        JetSimpleNameExpression operationExpression = expression.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType == null || elementType instanceof JetToken) : "JetOperationExpression should have operation token of type JetToken: " + expression;
        return (JetToken)elementType;
    }

    public static boolean isLabelIdentifierExpression(PsiElement element) {
        return element instanceof JetSimpleNameExpression && ((JetSimpleNameExpression)element).getReferencedNameElementType() == JetTokens.LABEL_IDENTIFIER;
    }

    public static interface JetExpressionWrapper {
        public JetExpression getBaseExpression();
    }
}

