/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lexer.JetTokens;

public class JetNullableType
extends JetTypeElement {
    public JetNullableType(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetNullableType", "<init>"));
        }
        super(node);
    }

    @NotNull
    public ASTNode getQuestionMarkNode() {
        ASTNode aSTNode = this.getNode().findChildByType(JetTokens.QUEST);
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNullableType", "getQuestionMarkNode"));
        }
        return aSTNode;
    }

    @Override
    @NotNull
    public List<JetTypeReference> getTypeArgumentsAsTypes() {
        JetTypeElement innerType = this.getInnerType();
        List<Object> list = innerType == null ? Collections.emptyList() : innerType.getTypeArgumentsAsTypes();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNullableType", "getTypeArgumentsAsTypes"));
        }
        return list;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetNullableType", "accept"));
        }
        return visitor.visitNullableType(this, data2);
    }

    @IfNotParsed
    @Nullable
    public JetTypeElement getInnerType() {
        return this.findChildByClass(JetTypeElement.class);
    }
}

